/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.dbeaver.db.ycql.data.CasMapValue;
import com.dbeaver.db.ycql.data.CasSetValue;
import com.dbeaver.db.ycql.data.CasTupleValue;
import com.dbeaver.db.ycql.data.CasUDTValue;
import com.dbeaver.db.ycql.exec.CasSession;
import com.dbeaver.db.ycql.model.CasAbstractDataType;
import com.dbeaver.db.ycql.model.CasDataSource;
import com.dbeaver.db.ycql.model.CasExecutionContext;
import com.dbeaver.db.ycql.model.CasPrivilegeGrant;
import com.dbeaver.model.data.DBContentByteBuffer;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasUtils {
    private static final Log log = Log.getLog(CasUtils.class);
    private static Field typeProtocolField;

    public static DBPDataKind getDataKind(DataType typeName) {
        return switch (typeName.getProtocolCode()) {
            case 4 -> DBPDataKind.BOOLEAN;
            case 1, 13 -> DBPDataKind.STRING;
            case 2, 5, 6, 7, 8, 9, 14, 19, 20 -> DBPDataKind.NUMERIC;
            case 11, 17, 18 -> DBPDataKind.DATETIME;
            case 0, 12, 15, 16, 49 -> DBPDataKind.OBJECT;
            case 48 -> DBPDataKind.STRUCT;
            case 33 -> DBPDataKind.ARRAY;
            case 128 -> DBPDataKind.CONTENT;
            case 32, 34 -> DBPDataKind.ARRAY;
            default -> DBPDataKind.BINARY;
        };
    }

    @NotNull
    public static String transformCQL(@NotNull CasDataSource dataSource, @NotNull String original, @Nullable DBDDataFilter filter) throws DBException {
        StringBuilder cql = new StringBuilder(original);
        if (filter != null && filter.hasConditions()) {
            cql.append(" WHERE ");
            SQLUtils.appendConditionString((DBDDataFilter)filter, (DBPDataSource)dataSource, null, (StringBuilder)cql, (boolean)true);
        }
        if (filter != null && filter.hasOrdering()) {
            cql.append(" ORDER BY ");
            SQLUtils.appendOrderString((DBDDataFilter)filter, (DBPDataSource)dataSource, null, (boolean)false, (StringBuilder)cql);
        }
        return cql.toString();
    }

    public static Object wrapValue(DBCExecutionContext executionContext, String keyspace, Object value) throws DBCException {
        if (value instanceof ByteBuffer) {
            return new DBContentByteBuffer(executionContext, (ByteBuffer)value);
        }
        if (value instanceof UdtValue) {
            return ((UdtValue)value).getFormattedContents();
        }
        if (value instanceof TupleValue) {
            return ((TupleValue)value).getFormattedContents();
        }
        return value;
    }

    public static Object unwrapValue(Object value) {
        if (value instanceof DBContentByteBuffer) {
            return ((DBContentByteBuffer)value).getData();
        }
        if (value instanceof CasSetValue) {
            return ((CasSetValue)((Object)value)).makeSet();
        }
        if (value instanceof CasMapValue) {
            return ((CasMapValue)((Object)value)).makeMap();
        }
        if (value instanceof CasUDTValue) {
            return ((CasUDTValue)value).getRawValue();
        }
        if (value instanceof CasTupleValue) {
            return ((CasTupleValue)value).getRawValue();
        }
        return value;
    }

    @NotNull
    public static LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime toCasTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
    }

    public static CasAbstractDataType resolveDataType(DBRProgressMonitor monitor, CasDataSource dataSource, String keyspace, DataType dataType) throws DBException {
        if (dataType instanceof TupleType) {
            return dataSource.getCachedTupleType((TupleType)dataType);
        }
        if (dataType instanceof UserDefinedType) {
            return dataSource.getKeyspace(keyspace).getUserType(monitor, dataType);
        }
        return dataSource.getLocalDataType(dataType.toString());
    }

    public static List<CasPrivilegeGrant> readPermissions(DBRProgressMonitor monitor, CasDataSource dataSource, String query) throws DBCException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (CasSession session = ((CasExecutionContext)dataSource.getDefaultContext(monitor, false)).openSession(monitor, DBCExecutionPurpose.UTIL, "Read privileges");){
            SimpleStatement privStat = SimpleStatement.newInstance((String)query);
            ResultSet resultSet = session.getImpl().execute((Statement)privStat);
            try {
                ArrayList<CasPrivilegeGrant> grants = new ArrayList<CasPrivilegeGrant>();
                for (Row row : resultSet.all()) {
                    String username = (String)row.get("username", String.class);
                    String resource = (String)row.get("resource", String.class);
                    List permission = row.getList("permissions", String.class);
                    CasPrivilegeGrant grant = new CasPrivilegeGrant(dataSource, username, resource, permission);
                    grants.add(grant);
                }
                return grants;
            }
            catch (Throwable e) {
                throw new DBCException("Error reading privileges", e);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static GenericType<Object> getClassFromType(DataType dataType) {
        TypeCodec codec = CodecRegistry.DEFAULT.codecFor(dataType);
        return codec.getJavaType();
    }

    public static Object convertLocalDateTime(@NotNull LocalDateTime localDateTime, @NotNull DBSTypedObject type) {
        if (type.getTypeID() == DataTypes.TIME.getProtocolCode()) {
            return CasUtils.toCasTime(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }
}

