/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.ui;

import com.dbeaver.model.DBPApplicationEAP;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTSchedulerDescriptor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;

public abstract class TaskHandlerScheduleBase
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        DBTTask task = (DBTTask)((IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)).getFirstElement();
        DBTSchedulerDescriptor scheduler = TaskRegistry.getInstance().getActiveScheduler();
        if (task != null && scheduler != null) {
            try {
                this.execute(event, task, scheduler, scheduler.getInstance());
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Scheduler error", "Scheduler error", (Throwable)e);
            }
        }
        return null;
    }

    protected void refreshScheduledInfo(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart != null) {
            ActionUtils.runCommand((String)"org.eclipse.ui.file.refresh", (IServiceLocator)activePart.getSite());
        }
    }

    protected boolean ensureCanSchedule() {
        DBPApplicationEAP app;
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        if (dBPApplication instanceof DBPApplicationEAP && (app = (DBPApplicationEAP)dBPApplication).isEarlyAccessProgram()) {
            DBWorkbench.getPlatformUI().showError("Can't schedule the task", "Task scheduling is not available when participating in Early Access Program");
            return false;
        }
        return true;
    }

    protected abstract void execute(@NotNull ExecutionEvent var1, @NotNull DBTTask var2, @NotNull DBTSchedulerDescriptor var3, @NotNull DBTScheduler var4) throws DBException;
}

