/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql.exec;

import com.dbeaver.db.cosmos.nosql.DCosmosContainer;
import com.dbeaver.db.cosmos.nosql.DCosmosSession;
import com.dbeaver.model.document.exec.DocumentReadStatement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;

public abstract class DCosmosBaseStatement
extends DocumentReadStatement<DCosmosSession> {
    private static final int DEFAULT_FETCH_SIZE = 1000;
    private long limit = 0L;
    private long offset = 0L;
    private int fetchSize = 1000;
    private long updateRowCount = -1L;
    private Throwable executeError;

    public DCosmosBaseStatement(@NotNull DCosmosSession session) {
        super((DBCSession)session);
        QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
    }

    public abstract DCosmosContainer getSourceEntity();

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getUpdateRowCount() {
        return this.updateRowCount;
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
        if (fetchSize < 0) {
            throw new DBCException("Fetch size must be a non-negative integer, got: " + fetchSize);
        }
        if (fetchSize == 0) {
            fetchSize = 1000;
        }
        this.fetchSize = fetchSize;
    }

    public int getResultsFetchSize() {
        return Math.min(this.fetchSize, 1000);
    }

    protected void beforeExecute() {
        this.executeError = null;
        if (((DCosmosSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock();
    }

    protected void afterExecute() {
        this.endBlock();
        if (((DCosmosSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, this.getUpdateRowCount(), this.executeError);
        }
    }

    protected DBCException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (ex instanceof DBCException) {
            return (DBCException)ex;
        }
        return new DBCException(ex, (DBCExecutionContext)((DCosmosSession)this.getSession()).getExecutionContext());
    }

    protected void startBlock() {
        ((DCosmosSession)this.getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, null);
    }

    protected void endBlock() {
        ((DCosmosSession)this.getSession()).getProgressMonitor().endBlock();
    }
}

