/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.truncate;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.AbstractOracleChange;
import liquibase.ext.ora.truncate.TruncateStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="truncate", description="Truncate", priority=201)
public class TruncateChange
extends AbstractOracleChange {
    private String schemaName;
    private String tableName;
    private String clusterName;
    private Boolean purgeMaterializedViewLog;
    private Boolean reuseStorage;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public Boolean getPurgeMaterializedViewLog() {
        return this.purgeMaterializedViewLog;
    }

    public void setPurgeMaterializedViewLog(Boolean purgeMaterializedViewLog) {
        this.purgeMaterializedViewLog = purgeMaterializedViewLog;
    }

    public Boolean getReuseStorage() {
        return this.reuseStorage;
    }

    public void setReuseStorage(Boolean reuseStorage) {
        this.reuseStorage = reuseStorage;
    }

    public String getConfirmationMessage() {
        if (this.tableName != null && this.tableName.length() > 0) {
            return "Table " + this.tableName + " truncated";
        }
        return "Cluster " + this.clusterName + " truncated";
    }

    public SqlStatement[] generateStatements(Database database) {
        boolean purgeMaterializedViewLog = false;
        if (this.getPurgeMaterializedViewLog() != null) {
            purgeMaterializedViewLog = this.getPurgeMaterializedViewLog();
        }
        return new SqlStatement[]{new TruncateStatement(this.schemaName, this.tableName, this.clusterName).setPurgeMaterializedViewLog(purgeMaterializedViewLog).setReuseStorage(this.reuseStorage)};
    }
}

