/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.encapsulateTableWithView;

import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.core.DropViewChange;
import liquibase.change.core.RenameTableChange;
import liquibase.database.Database;
import liquibase.ext.ora.AbstractOracleChange;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateViewStatement;
import liquibase.statement.core.RenameTableStatement;

@DatabaseChange(name="encapsulateTableWithView", description="Encapsulate table with view", priority=201)
public class EncapsulateTableWithViewChange
extends AbstractOracleChange {
    private String schemaName;
    private String tableName;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new RenameTableStatement(null, this.schemaName, this.tableName, "T" + this.tableName), new CreateViewStatement(null, this.schemaName, this.tableName, "SELECT * FROM T" + this.tableName, true)};
    }

    public String getConfirmationMessage() {
        return "Table " + this.tableName + " encapsulated with view";
    }

    protected Change[] createInverses() {
        DropViewChange dropView = new DropViewChange();
        dropView.setViewName(this.tableName);
        RenameTableChange renameTable = new RenameTableChange();
        renameTable.setOldTableName("T" + this.tableName);
        renameTable.setNewTableName(this.tableName);
        return new Change[]{dropView, renameTable};
    }
}

