/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.CorsRuleAllowedMethodsItem;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class CorsRule {
    @JsonProperty(value="allowedOrigins", required=true)
    private List<String> allowedOrigins;
    @JsonProperty(value="allowedMethods", required=true)
    private List<CorsRuleAllowedMethodsItem> allowedMethods;
    @JsonProperty(value="maxAgeInSeconds", required=true)
    private int maxAgeInSeconds;
    @JsonProperty(value="exposedHeaders", required=true)
    private List<String> exposedHeaders;
    @JsonProperty(value="allowedHeaders", required=true)
    private List<String> allowedHeaders;
    private static final ClientLogger LOGGER = new ClientLogger(CorsRule.class);

    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public CorsRule withAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public List<CorsRuleAllowedMethodsItem> allowedMethods() {
        return this.allowedMethods;
    }

    public CorsRule withAllowedMethods(List<CorsRuleAllowedMethodsItem> allowedMethods) {
        this.allowedMethods = allowedMethods;
        return this;
    }

    public int maxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    public CorsRule withMaxAgeInSeconds(int maxAgeInSeconds) {
        this.maxAgeInSeconds = maxAgeInSeconds;
        return this;
    }

    public List<String> exposedHeaders() {
        return this.exposedHeaders;
    }

    public CorsRule withExposedHeaders(List<String> exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
        return this;
    }

    public List<String> allowedHeaders() {
        return this.allowedHeaders;
    }

    public CorsRule withAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
        return this;
    }

    public void validate() {
        if (this.allowedOrigins() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property allowedOrigins in model CorsRule"));
        }
        if (this.allowedMethods() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property allowedMethods in model CorsRule"));
        }
        if (this.exposedHeaders() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property exposedHeaders in model CorsRule"));
        }
        if (this.allowedHeaders() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property allowedHeaders in model CorsRule"));
        }
    }
}

