/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.files.model;

import com.dbeaver.db.files.model.FFExecutionContext;
import com.dbeaver.jdbc.files.api.FFProperties;
import java.nio.file.Path;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class FFDataSource
extends GenericDataSource {
    private static final Log log = Log.getLog(FFDataSource.class);

    public FFDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel, @NotNull SQLDialect dialect) throws DBException {
        super(monitor, container, metaModel, dialect);
    }

    protected JDBCExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) throws DBCException {
        String customPath = this.getContainer().getConnectionConfiguration().getProperty(FFProperties.INTERNAL_DATABASE_DIR_PROPERTY.name());
        if (DBWorkbench.getPlatform().getApplication().isMultiuser() && CommonUtils.isNotEmpty((String)customPath)) {
            throw new DBCException("Custom internal db path is not supported");
        }
        return new FFExecutionContext(instance, type);
    }

    @Nullable
    protected Map<String, String> getInternalConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull JDBCExecutionContext context, @NotNull String purpose, @NotNull DBPConnectionConfiguration connectionInfo) throws DBCException {
        try {
            FFExecutionContext fe = (FFExecutionContext)context;
            Path dbTempFolder = fe.getDbTempFolder();
            return Map.of(FFProperties.INTERNAL_DATABASE_DIR_PROPERTY.name(), dbTempFolder.toString());
        }
        catch (Exception e) {
            throw new DBCException("Error creating internal database", (Throwable)e);
        }
    }
}

