/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.registry;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.registry.CPCloudSessionProvider;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.auth.SMSessionProviderService;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class CloudSessionProviderService
implements SMSessionProviderService {
    private static final Log log = Log.getLog(CloudSessionProviderService.class);

    @Nullable
    public SMSession acquireSession(@NotNull DBRProgressMonitor monitor, @NotNull SMSessionContext context, @NotNull SMAuthSpace space) throws DBException {
        CPCloudSessionProvider<?, ?> sessionProvider;
        if (space instanceof CPCloud && (sessionProvider = CloudProviderRegistry.getInstance().getSessionProvider((CPCloud)space)) != null) {
            DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
            SMSession mainSession = context.getSpaceSession(monitor, (SMAuthSpace)workspace, true);
            if (mainSession == null) {
                log.error((Object)"Cloud session was requested but there is no authorization to the cloud");
                return null;
            }
            return sessionProvider.openSession(monitor, context, mainSession, (CPCloud)space);
        }
        return null;
    }
}

