/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import com.raima.rdm.util.RDMConversionException;
import com.raima.rdm.util.RDMException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class StringInputStream
extends InputStream {
    byte[] data;
    int offset;
    int mark = 0;
    private static CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();

    private static boolean isPureAscii(String str) {
        return asciiEncoder.canEncode(str);
    }

    public StringInputStream(String str) throws RDMException {
        if (!StringInputStream.isPureAscii(str)) {
            throw new RDMConversionException("Unable to convert data into ASCII stream");
        }
        char[] tmp = str.toCharArray();
        this.data = new byte[tmp.length];
        for (int ii = 0; ii < tmp.length; ++ii) {
            this.data[ii] = (byte)tmp[ii];
        }
        this.offset = 0;
        this.mark = 0;
    }

    @Override
    public int available() throws IOException {
        if (this.data == null) {
            throw new IOException("Stream is closed");
        }
        return this.data.length - this.offset;
    }

    @Override
    public void close() throws IOException {
        if (this.data != null) {
            this.data = null;
        }
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.offset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.data == null) {
            throw new IOException("Stream is closed");
        }
        if (this.offset < this.data.length) {
            return this.data[this.offset++];
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.data == null) {
            throw new IOException("Stream is closed");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.offset >= this.data.length) {
            return -1;
        }
        int bytes = Math.min(len, this.data.length - this.offset);
        System.arraycopy(this.data, this.offset, b, off, bytes);
        this.offset += bytes;
        return bytes;
    }

    @Override
    public void reset() throws IOException {
        if (this.data == null) {
            throw new IOException("Stream is closed");
        }
        this.offset = this.mark;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.data == null) {
            throw new IOException("Stream is closed");
        }
        if (n <= 0L) {
            return 0L;
        }
        long count = Math.min(n, (long)(this.data.length - this.offset));
        this.offset = (int)((long)this.offset + count);
        return count;
    }
}

