/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.DateTimeConverter;
import com.raima.rdm.sql.RSQLParam;
import com.raima.rdm.sql.RSQLStatement;
import com.raima.rdm.util.BinaryConverter;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMUnexpectedException;
import com.raima.rdm.util.RPC;
import com.raima.rdm.util.UTF8;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;

public class RSQLClobParam
extends RSQLParam {
    Reader reader;
    long maxlen;
    String data;

    public RSQLClobParam() {
        super(4104, (short)3);
    }

    public RSQLClobParam(Reader rdr) {
        super(4104);
        this.reader = rdr;
        this.maxlen = -1L;
    }

    public RSQLClobParam(short t, Reader rdr) {
        super(4104, t);
        this.reader = rdr;
        this.maxlen = -1L;
    }

    public RSQLClobParam(Reader rdr, long maxlen) {
        super(4104);
        this.reader = rdr;
        this.maxlen = maxlen;
    }

    public RSQLClobParam(short t, Reader rdr, long maxlen) {
        super(4104, t);
        this.reader = rdr;
        this.maxlen = maxlen;
    }

    public RSQLClobParam(Clob clob) throws SQLException {
        super(4104);
        this.reader = clob.getCharacterStream();
        this.maxlen = -1L;
    }

    public RSQLClobParam(short t, Clob clob) throws SQLException {
        super(4104, t);
        this.reader = clob.getCharacterStream();
        this.maxlen = -1L;
    }

    @Override
    public String getString() throws RDMException {
        if (this.data != null) {
            return this.data;
        }
        try {
            int b;
            StringBuilder str = new StringBuilder();
            int ii = 0;
            while ((long)ii != this.maxlen && (b = this.reader.read()) != -1) {
                str.append((char)b);
                ++ii;
            }
            this.data = str.toString();
            return this.data;
        }
        catch (IOException e) {
            throw new RDMUnexpectedException(e.getMessage());
        }
    }

    @Override
    public byte[] getBytes() throws RDMException {
        return BinaryConverter.convertFromString(this.getString());
    }

    @Override
    public boolean getBoolean() throws RDMException {
        return Boolean.parseBoolean(this.getString());
    }

    @Override
    public byte getByte() throws RDMException {
        return Byte.parseByte(this.getString());
    }

    @Override
    public short getShort() throws RDMException {
        return Short.parseShort(this.getString());
    }

    @Override
    public int getInt() throws RDMException {
        return Integer.parseInt(this.getString());
    }

    @Override
    public long getLong() throws RDMException {
        return Long.parseLong(this.getString());
    }

    @Override
    public float getFloat() throws RDMException {
        return Float.parseFloat(this.getString());
    }

    @Override
    public double getDouble() throws RDMException {
        return Double.parseDouble(this.getString());
    }

    @Override
    public int getDate() throws RDMException {
        return DateTimeConverter.RDateFromDate(Date.valueOf(this.getString()));
    }

    @Override
    public int getTime() throws RDMException {
        return DateTimeConverter.RTimeFromTime(Time.valueOf(this.getString()));
    }

    @Override
    public int[] getTimestamp() throws RDMException {
        return DateTimeConverter.RTimestampFromTimestamp(Timestamp.valueOf(this.getString()));
    }

    @Override
    public BigDecimal getDecimal() throws RDMException {
        return new BigDecimal(this.getString());
    }

    @Override
    public UUID getGuid() throws RDMException {
        return UUID.fromString(this.getString());
    }

    @Override
    public void send(RPC rpc) throws IOException {
        try {
            rpc.sendInt32(8);
            rpc.sendString(this.getString());
        }
        catch (RDMException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void set(RPC rpc) throws IOException {
        this.data = rpc.getString();
    }

    private byte[] getNextChunk(int max) throws IOException {
        int data;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int ii = 0; ii < max && (data = this.reader.read()) != -1; ++ii) {
            baos.write(UTF8.convertToUTF8((char)data));
        }
        return baos.toByteArray();
    }

    @Override
    public void sendDataAtExec(RSQLStatement stmt) throws RDMException {
        try {
            byte[] barr;
            while ((barr = this.getNextChunk(1024)).length != 0) {
                stmt.putData(4104, barr);
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException(e.getMessage());
        }
    }
}

