/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RSQLColumn;
import com.raima.rdm.util.BinaryConverter;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMInvalidColumnTypeException;
import com.raima.rdm.util.RPC;
import com.raima.rdm.util.StringInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.UUID;

public class RSQLBinaryColumn
implements RSQLColumn {
    byte[] barr;

    public RSQLBinaryColumn(byte[] b, int max) {
        if (max > 0 && b.length > max) {
            this.barr = new byte[max];
            System.arraycopy(b, 0, this.barr, 0, max);
        } else {
            this.barr = (byte[])b.clone();
        }
    }

    @Override
    public boolean isNull() throws RDMException {
        return false;
    }

    @Override
    public String getString() throws RDMException {
        return BinaryConverter.convertToString(this.barr);
    }

    @Override
    public byte[] getBytes() throws RDMException {
        return (byte[])this.barr.clone();
    }

    @Override
    public boolean getBoolean() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public byte getByte() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public short getShort() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public int getInt() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public long getLong() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public float getFloat() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public double getDouble() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public BigDecimal getBigDecimal() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Date getDate() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Date getDate(Calendar cal) throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Time getTime() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Time getTime(Calendar cal) throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Timestamp getTimestamp() throws RDMException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public UUID getUUID() throws RDMException {
        return UUID.nameUUIDFromBytes(this.barr);
    }

    @Override
    public InputStream getAsciiStream() throws RDMException {
        return new StringInputStream(this.getString());
    }

    @Override
    public InputStream getBinaryStream() throws RDMException {
        return new ByteArrayInputStream(this.barr);
    }

    @Override
    public Reader getCharacterStream() throws RDMException {
        return new StringReader(this.getString());
    }

    @Override
    public Object getObject() throws RDMException {
        return this.barr.clone();
    }

    public void send(RPC rpc) throws IOException {
        rpc.sendInt32(6);
        rpc.sendBytes(this.barr);
    }
}

