/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.logging.Logger;

public class RDMSavepoint
implements Savepoint {
    int id;
    String name;
    private Logger logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    private static final String className = "RDMSavepoint";

    protected RDMSavepoint(int id) {
        this.id = id;
        this.name = null;
    }

    protected RDMSavepoint(String name) {
        this.id = -1;
        this.name = name;
    }

    protected String getInternalName() {
        if (this.name == null) {
            return "Savepoint." + this.id;
        }
        return this.name;
    }

    @Override
    public int getSavepointId() throws SQLException {
        String methodName = "getSavepointId";
        this.logger.entering(className, methodName);
        if (this.name != null) {
            throw this.createSQLException(methodName, "Accessing id of named savepoint");
        }
        this.logger.exiting(className, methodName, this.id);
        return this.id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        String methodName = "getSavepointId";
        this.logger.entering(className, methodName);
        if (this.name == null) {
            throw this.createSQLException(methodName, "Accessing name of un-named savepoint)");
        }
        this.logger.exiting(className, methodName, this.name);
        return this.name;
    }

    private SQLException createSQLException(String methodName, String error) throws SQLException {
        SQLException sqlex = new SQLException(error);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }
}

