/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.RDMConnection;
import com.raima.rdm.jdbc.RDMJDBCURL;
import com.raima.rdm.util.RDMHostInfo;
import com.raima.rdm.util.RDMVersion;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class RDMDataSource
implements DataSource {
    private int loginTimeout;
    private String dataSourceName;
    private String description;
    private RDMHostInfo hostinfo;
    private RDMJDBCURL url;
    protected Logger logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    private static final String className = "RDMDataSource";

    public RDMDataSource() throws SQLException {
        try {
            this.url = new RDMJDBCURL();
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
        this.dataSourceName = null;
        this.description = "RDM " + RDMVersion.getVersion() + " JDBC Data Source";
        this.loginTimeout = 0;
        this.hostinfo = new RDMHostInfo();
    }

    protected RDMConnection makeConnection(String methodName) throws SQLException {
        RDMConnection con = null;
        if (this.dataSourceName != null) {
            try {
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(this.dataSourceName);
                return (RDMConnection)ds.getConnection();
            }
            catch (NamingException e) {
                throw this.createSQLException(methodName, e.toString());
            }
        }
        try {
            con = new RDMConnection(this.url);
        }
        catch (SQLException e) {
            this.logger.throwing(className, methodName, e);
            throw e;
        }
        return con;
    }

    @Override
    public Connection getConnection() throws SQLException {
        String methodName = "getConnection";
        this.logger.entering(className, methodName);
        RDMConnection conn = this.makeConnection(methodName);
        this.logger.exiting(className, methodName, conn);
        return conn;
    }

    @Override
    public Connection getConnection(String u, String p) throws SQLException {
        String methodName = "getConnection";
        this.logger.entering(className, methodName, new Object[]{u, p});
        RDMConnection conn = this.makeConnection(methodName);
        this.logger.exiting(className, methodName, conn);
        return conn;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        String methodName = "getLoginTimeout";
        this.logger.entering(className, methodName);
        this.logger.exiting(className, methodName, this.loginTimeout);
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        String methodName = "getParentLogger";
        this.logger.entering(className, methodName);
        throw this.createSQLFeatureNotSupportedException(methodName, "not supported");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        String methodName = "getLogWriter";
        this.logger.entering(className, methodName);
        this.logger.exiting(className, methodName, null);
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodName = "isWrapperFor";
        this.logger.entering(className, methodName, iface);
        boolean result = iface.isInstance(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        String methodName = "setLoginTimeout";
        this.logger.entering(className, methodName, seconds);
        this.loginTimeout = seconds;
        this.logger.exiting(className, methodName);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        String methodName = "setLogWriter";
        this.logger.entering(className, methodName, out);
        this.logger.exiting(className, methodName);
    }

    public boolean getAutoCommit() throws SQLException {
        String methodName = "getAutoCommit";
        this.logger.entering(className, methodName);
        boolean autocommit = this.url.getAutoCommit();
        this.logger.exiting(className, methodName, autocommit);
        return autocommit;
    }

    public void setAutoCommit(boolean flag) throws SQLException {
        String methodName = "setAutoCommit";
        this.logger.entering(className, methodName, flag);
        this.url.setAutoCommit(flag);
        this.logger.exiting(className, methodName);
    }

    public String getDataSourceName() throws SQLException {
        String methodName = "getDataSourceName";
        this.logger.entering(className, methodName);
        this.logger.exiting(className, methodName, this.dataSourceName);
        return this.dataSourceName;
    }

    public void setDataSourceName(String name) throws SQLException {
        String methodName = "setDataSourceName";
        this.logger.entering(className, methodName, name);
        this.dataSourceName = name;
        this.logger.exiting(className, methodName);
    }

    public String getDescription() throws SQLException {
        String methodName = "getDescription";
        this.logger.entering(className, methodName);
        this.logger.exiting(className, methodName, this.description);
        return this.description;
    }

    public void setDescription(String desc) throws SQLException {
        String methodName = "setDescription";
        this.logger.entering(className, methodName, desc);
        this.description = desc;
        this.logger.exiting(className, methodName);
    }

    public int getPortNumber() throws SQLException {
        String methodName = "getPortNumber";
        this.logger.entering(className, methodName);
        int port = this.hostinfo.port;
        this.logger.exiting(className, methodName, port);
        return port;
    }

    public void setPortNumber(int port) throws SQLException {
        String methodName = "setPortNumber";
        this.logger.entering(className, methodName, port);
        this.hostinfo.port = port;
        this.logger.exiting(className, methodName);
    }

    public String getServerName() throws SQLException {
        String methodName = "getServerName";
        this.logger.entering(className, methodName);
        String host = this.hostinfo.host;
        this.logger.exiting(className, methodName, host);
        return host;
    }

    public void setServerName(String name) throws SQLException {
        String methodName = "setServerName";
        this.logger.entering(className, methodName, name);
        this.hostinfo.host = name;
        this.logger.exiting(className, methodName);
    }

    public boolean getLocal() throws SQLException {
        String methodName = "getLocal";
        this.logger.entering(className, methodName);
        boolean local = this.url.getHostList().size() == 0;
        this.logger.exiting(className, methodName, local);
        return local;
    }

    public void setLocal(boolean local) throws SQLException {
        String methodName = "setLocal";
        this.logger.entering(className, methodName, local);
        LinkedList<RDMHostInfo> hostlist = this.url.getHostList();
        if (local) {
            hostlist.clear();
        } else if (hostlist.size() == 0) {
            hostlist.add(this.hostinfo);
        }
        this.logger.exiting(className, methodName);
    }

    public int getTransactionIsolation() throws SQLException {
        String methodName = "getTransactionIsolation";
        this.logger.entering(className, methodName);
        int transIsolation = this.url.getTransIsolation();
        this.logger.exiting(className, methodName, transIsolation);
        return transIsolation;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        String methodName = "setTransactionIsolation";
        this.logger.entering(className, methodName, level);
        this.url.setTransIsolation(level);
        this.logger.exiting(className, methodName);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodName = "unwrap";
        this.logger.entering(className, methodName, iface);
        if (!iface.isInstance(this)) {
            throw this.createSQLException(methodName, "not an instance");
        }
        T result = iface.cast(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    private SQLException createSQLException(String methodName, String error) throws SQLException {
        SQLException sqlex = new SQLException(error);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }

    private SQLFeatureNotSupportedException createSQLFeatureNotSupportedException(String methodName, String error) throws SQLFeatureNotSupportedException {
        SQLFeatureNotSupportedException sqlex = new SQLFeatureNotSupportedException(error);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }
}

