/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.RDMBlob;
import com.raima.rdm.jdbc.RDMCallableStatement;
import com.raima.rdm.jdbc.RDMClob;
import com.raima.rdm.jdbc.RDMDatabaseMetaData;
import com.raima.rdm.jdbc.RDMDriver;
import com.raima.rdm.jdbc.RDMJDBCURL;
import com.raima.rdm.jdbc.RDMNClob;
import com.raima.rdm.jdbc.RDMPreparedStatement;
import com.raima.rdm.jdbc.RDMSavepoint;
import com.raima.rdm.jdbc.RDMStatement;
import com.raima.rdm.sql.RDMSQLException;
import com.raima.rdm.sql.RSQL;
import com.raima.rdm.sql.RSQLJNI;
import com.raima.rdm.sql.RSQLTCP;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMHostInfo;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

public class RDMConnection
implements Connection {
    private RDMDatabaseMetaData meta;
    private RSQL sql;
    private int nextSavePointId;
    private LinkedList<RDMStatement> stmtList;
    private LinkedList<RDMSavepoint> savepointList;
    private SQLWarning warnings;
    private Object warningsSync;
    private Logger logger;
    private Map<String, Class<?>> typeMap;
    private RDMJDBCURL url;
    private int defaultFetchSize = 10;
    private static final String className = "RDMConnection";
    private static final String savepointNotValid = "Savepoint not valid for this Connection";
    private static final String cannotRollback = "Cannot rollback in auto-commit mode";
    private static final String cannotCreateSavepoint = "Cannot create Savepoint in auto-commit mode";

    protected RDMConnection(RDMJDBCURL url) throws SQLException {
        try {
            this.sql = this.connect(url);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        this.logger = Logger.getLogger("com.raima.rdm.jdbc.API");
        this.url = url;
        this.nextSavePointId = 0;
        this.typeMap = new HashMap();
        this.stmtList = new LinkedList();
        this.savepointList = new LinkedList();
        this.meta = new RDMDatabaseMetaData(url.getURL(), this);
        this.setDefaultFetchSize(url.getPrefetchSize());
        this.setSQLOptions();
        this.warningsSync = new Object();
    }

    private RSQL connect(RDMJDBCURL url) throws RDMException {
        RSQLTCP newsql = null;
        RDMException first = null;
        LinkedList<RDMHostInfo> hostlist = url.getHostList();
        if (hostlist.size() == 0) {
            return new RSQLJNI(url);
        }
        Iterator iter = hostlist.iterator();
        while (iter.hasNext()) {
            try {
                newsql = new RSQLTCP(url, (RDMHostInfo)iter.next());
            }
            catch (RDMException e) {
                if (first != null) continue;
                first = e;
            }
        }
        if (newsql == null) {
            throw first;
        }
        return newsql;
    }

    @Override
    public void abort(Executor exec) throws SQLException {
        String methodName = "clearWarnings";
        this.logger.entering(className, "clearWarnings");
        throw this.createSQLFeatureNotSupportedException("clearWarnings", "not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearWarnings() throws RDMException {
        Object object = this.warningsSync;
        synchronized (object) {
            this.sql.clearWarnings();
            this.warnings = null;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        String methodName = "clearWarnings";
        this.logger.entering(className, "clearWarnings");
        try {
            this._clearWarnings();
        }
        catch (RDMException e) {
            throw this.createSQLException("clearWarnings", e);
        }
        this.logger.exiting(className, "clearWarnings");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeResultSets() throws SQLException {
        LinkedList<RDMStatement> linkedList = this.stmtList;
        synchronized (linkedList) {
            ListIterator iter = this.stmtList.listIterator();
            while (iter.hasNext()) {
                RDMStatement stmt = (RDMStatement)iter.next();
                stmt.closeResultSet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        LinkedList<Object> linkedList;
        String methodName = "close";
        this.logger.entering(className, "close");
        this._validate("close");
        if (this.meta != null) {
            this.meta.close();
            this.meta = null;
        }
        if (this.stmtList != null) {
            linkedList = this.stmtList;
            synchronized (linkedList) {
                while (this.stmtList.size() > 0) {
                    this.stmtList.removeFirst().close();
                }
            }
            this.stmtList = null;
        }
        if (this.savepointList != null) {
            linkedList = this.savepointList;
            synchronized (linkedList) {
                this.savepointList.clear();
            }
            this.savepointList = null;
        }
        this.warnings = null;
        if (this.typeMap != null) {
            this.typeMap.clear();
            this.typeMap = null;
        }
        if (this.sql != null) {
            try {
                this.sql.free();
            }
            catch (RDMException rDMException) {
                // empty catch block
            }
            this.sql = null;
        }
        this.logger.exiting(className, "close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        String methodName = "commit";
        this.logger.entering(className, "commit");
        this._validate("commit");
        try {
            this._clearWarnings();
            this.sql.commit();
            SQLWarning warning = this.sql.getWarnings();
            if (warning != null) {
                this.addWarning(warning);
            }
        }
        catch (RDMException e) {
            throw this.createSQLException("commit", e);
        }
        LinkedList<RDMSavepoint> linkedList = this.savepointList;
        synchronized (linkedList) {
            this.savepointList.clear();
        }
        this.closeResultSets();
        this.logger.exiting(className, "commit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RDMStatement doCreateStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        RDMStatement stmt = new RDMStatement(this, resultSetType, resultSetConcurrency);
        LinkedList<RDMStatement> linkedList = this.stmtList;
        synchronized (linkedList) {
            this.stmtList.add(stmt);
        }
        return stmt;
    }

    private RDMPreparedStatement doCreatePreparedStatement(String sql) throws SQLException {
        return this.doCreatePreparedStatement(sql, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RDMPreparedStatement doCreatePreparedStatement(String sql, int autoGeneratedKeys) throws SQLException {
        RDMPreparedStatement stmt = new RDMPreparedStatement(this, sql, autoGeneratedKeys);
        LinkedList<RDMStatement> linkedList = this.stmtList;
        synchronized (linkedList) {
            this.stmtList.add(stmt);
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RDMPreparedStatement doCreatePreparedStatement(String sql, int[] columnIndexes) throws SQLException {
        RDMPreparedStatement stmt = new RDMPreparedStatement(this, sql, columnIndexes);
        LinkedList<RDMStatement> linkedList = this.stmtList;
        synchronized (linkedList) {
            this.stmtList.add(stmt);
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RDMPreparedStatement doCreatePreparedStatement(String sql, String[] columnNames) throws SQLException {
        RDMPreparedStatement stmt = new RDMPreparedStatement(this, sql, columnNames);
        LinkedList<RDMStatement> linkedList = this.stmtList;
        synchronized (linkedList) {
            this.stmtList.add(stmt);
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RDMPreparedStatement doCreatePreparedStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        RDMPreparedStatement stmt = new RDMPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
        LinkedList<RDMStatement> linkedList = this.stmtList;
        synchronized (linkedList) {
            this.stmtList.add(stmt);
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RDMCallableStatement doCreateCallableStatement(String sql) throws SQLException {
        RDMCallableStatement stmt = new RDMCallableStatement(this, sql);
        LinkedList<RDMStatement> linkedList = this.stmtList;
        synchronized (linkedList) {
            this.stmtList.add(stmt);
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RDMCallableStatement doCreateCallableStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        RDMCallableStatement stmt = new RDMCallableStatement(this, sql, resultSetType, resultSetConcurrency);
        LinkedList<RDMStatement> linkedList = this.stmtList;
        synchronized (linkedList) {
            this.stmtList.add(stmt);
        }
        return stmt;
    }

    @Override
    public Blob createBlob() throws SQLException {
        String methodName = "createBlob";
        this.logger.entering(className, "createBlob");
        this._validate("createBlob");
        RDMBlob blob = new RDMBlob();
        this.logger.exiting(className, "createBlob", blob);
        return blob;
    }

    @Override
    public Clob createClob() throws SQLException {
        String methodName = "createClob";
        this.logger.entering(className, "createClob");
        this._validate("createClob");
        RDMClob clob = new RDMClob();
        this.logger.exiting(className, "createClob", clob);
        return clob;
    }

    @Override
    public NClob createNClob() throws SQLException {
        String methodName = "createNClob";
        this.logger.entering(className, "createNClob");
        RDMNClob clob = new RDMNClob();
        this.logger.exiting(className, "createNClob", clob);
        return clob;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        String methodName = "createSQLXML";
        this.logger.entering(className, "createSQLXML");
        throw this.createSQLFeatureNotSupportedException("createSQLXML", "SQLXML not supported");
    }

    @Override
    public Statement createStatement() throws SQLException {
        String methodName = "createStatement";
        this.logger.entering(className, "createStatement");
        this._validate("createStatement");
        RDMStatement stmt = this.doCreateStatement(1003, 1007);
        this.logger.exiting(className, "createStatement", stmt);
        return stmt;
    }

    private void validateResultSetType(String methodName, int resultSetType) throws SQLException {
    }

    private void validateResultSetConcurrency(String methodName, int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw this.createSQLFeatureNotSupportedException(methodName, "database only supports read only concurrency");
        }
    }

    private void validateResultSetHoldability(String methodName, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 2) {
            if (resultSetHoldability == 1) {
                throw this.createSQLFeatureNotSupportedException(methodName, "database only supports cursors closed a commit");
            }
            throw this.createSQLException(methodName, "invalid result set holdability: " + resultSetHoldability);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        String methodName = "createStatement";
        this.logger.entering(className, "createStatement", new Object[]{resultSetType, resultSetConcurrency});
        this.validateResultSetType("createStatement", resultSetType);
        this.validateResultSetConcurrency("createStatement", resultSetConcurrency);
        this._validate("createStatement");
        RDMStatement stmt = this.doCreateStatement(resultSetType, resultSetConcurrency);
        this.logger.exiting(className, "createStatement", stmt);
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String methodName = "createStatement";
        this.logger.entering(className, "createStatement", new Object[]{resultSetType, resultSetConcurrency, resultSetHoldability});
        this._validate("createStatement");
        this.validateResultSetType("createStatement", resultSetType);
        this.validateResultSetConcurrency("createStatement", resultSetConcurrency);
        this.validateResultSetHoldability("createStatement", resultSetHoldability);
        RDMStatement stmt = this.doCreateStatement(resultSetType, resultSetConcurrency);
        this.logger.exiting(className, "createStatement", stmt);
        return stmt;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        String methodName = "createArrayOf";
        throw this.createSQLFeatureNotSupportedException("createArrayOf", "Array not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        String methodName = "createStruct";
        throw this.createSQLFeatureNotSupportedException("createStruct", "Struct not supported");
    }

    protected boolean _getAutoCommit() {
        return this.url.getAutoCommit();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        String methodName = "getAutoCommit";
        this.logger.entering(className, "getAutoCommit");
        this._validate("getAutoCommit");
        boolean autocommit = this._getAutoCommit();
        this.logger.exiting(className, "getAutoCommit", autocommit);
        return autocommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        String methodName = "getCatalog";
        this.logger.entering(className, "getCatalog");
        this._validate("getCatalog");
        this.logger.exiting(className, "getCatalog", null);
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        String methodName = "getClientInfo";
        this.logger.entering(className, "getClientInfo");
        this._validate("getClientInfo");
        Properties props = this.url.getProperties();
        this.logger.exiting(className, "getClientInfo", props);
        return props;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        String methodName = "getClientInfo";
        this.logger.entering(className, "getClientInfo", name);
        this._validate("getClientInfo");
        String value = this.url.getProperties().getProperty(name);
        this.logger.exiting(className, "getClientInfo", value);
        return value;
    }

    @Override
    public int getHoldability() throws SQLException {
        String methodName = "getHoldability";
        this.logger.entering(className, "getHoldability");
        this._validate("getHoldability");
        this.logger.exiting(className, "getHoldability", 2);
        return 2;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        String methodName = "getMetaData";
        this.logger.entering(className, "getMetaData");
        this._validate("getMetaData");
        this.logger.exiting(className, "getMetaData", this.meta);
        return this.meta;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        String methodName = "getNetworkTimeout";
        this.logger.entering(className, "getNetworkTimeout");
        throw this.createSQLFeatureNotSupportedException("getNetworkTimeout", "not supported");
    }

    @Override
    public String getSchema() throws SQLException {
        String methodName = "getSchema";
        this.logger.entering(className, "getSchema");
        throw this.createSQLFeatureNotSupportedException("getSchema", "not supported");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        String methodName = "getTransactionIsolation";
        this.logger.entering(className, "getTransactionIsolation");
        this._validate("getTransactionIsolation");
        int transIsolationLevel = this.url.getTransIsolation();
        this.logger.exiting(className, "getTransactionIsolation", transIsolationLevel);
        return transIsolationLevel;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        String methodName = "getTypeMap";
        this.logger.entering(className, "getTypeMap");
        this._validate("getTypeMap");
        this.logger.exiting(className, "getTypeMap", this.typeMap);
        return this.typeMap;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        String methodName = "getWarnings";
        this.logger.entering(className, "getWarnings");
        this._validate("getWarnings");
        this.logger.exiting(className, "getWarnings", this.warnings);
        return this.warnings;
    }

    @Override
    public boolean isClosed() throws SQLException {
        String methodName = "isClosed";
        this.logger.entering(className, "isClosed");
        boolean ret = this.sql == null;
        this.logger.exiting(className, "isClosed", ret);
        return ret;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        String methodName = "isReadOnly";
        this.logger.entering(className, "isReadOnly");
        this._validate("isReadOnly");
        boolean readonly = this.url.getReadOnlyMode();
        this.logger.exiting(className, "isReadOnly", readonly);
        return readonly;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean valid;
        String methodName = "isValid";
        this.logger.entering(className, methodName, timeout);
        if (timeout < 0) {
            throw this.createSQLException(methodName, "invalid parameter");
        }
        if (this.sql == null) {
            valid = false;
        } else {
            try {
                this.sql.transStatus();
                valid = true;
            }
            catch (RDMException e) {
                valid = false;
            }
        }
        this.logger.exiting(className, methodName, valid);
        return valid;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodName = "isWrapperFor";
        this.logger.entering(className, "isWrapperFor", iface);
        boolean result = iface.isInstance(this);
        this.logger.exiting(className, "isWrapperFor", result);
        return result;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        String methodName = "nativeSQL";
        this.logger.entering(className, "nativeSQL", sql);
        this._validate("nativeSQL");
        String str = RDMDriver.nativeSQL(sql);
        this.logger.exiting(className, "nativeSQL", str);
        return str;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        String methodName = "prepareCall";
        this.logger.entering(className, "prepareCall", sql);
        this._validate("prepareCall");
        RDMCallableStatement stmt = this.doCreateCallableStatement(sql);
        this.logger.entering(className, "prepareCall", stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String methodName = "prepareCall";
        this.logger.entering(className, "prepareCall", new Object[]{sql, resultSetType, resultSetConcurrency});
        this._validate("prepareCall");
        this.validateResultSetType("prepareCall", resultSetType);
        this.validateResultSetConcurrency("prepareCall", resultSetConcurrency);
        RDMCallableStatement stmt = this.doCreateCallableStatement(sql, resultSetType, resultSetConcurrency);
        this.logger.exiting(className, "prepareCall", stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String methodName = "prepareCall";
        this.logger.entering(className, "prepareCall", new Object[]{sql, resultSetType, resultSetConcurrency, resultSetHoldability});
        this._validate("prepareCall");
        this.validateResultSetType("prepareCall", resultSetType);
        this.validateResultSetConcurrency("prepareCall", resultSetConcurrency);
        this.validateResultSetHoldability("prepareCall", resultSetHoldability);
        RDMCallableStatement stmt = this.doCreateCallableStatement(sql, resultSetType, resultSetConcurrency);
        this.logger.exiting(className, "prepareCall", stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String methodName = "prepareStatement";
        this.logger.entering(className, "prepareStatement", sql);
        this._validate("prepareStatement");
        RDMPreparedStatement stmt = this.doCreatePreparedStatement(sql);
        this.logger.exiting(className, "prepareStatement", stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String methodName = "prepareStatement";
        this.logger.entering(className, "prepareStatement", new Object[]{sql, autoGeneratedKeys});
        this._validate("prepareStatement");
        RDMPreparedStatement stmt = this.doCreatePreparedStatement(sql, autoGeneratedKeys);
        this.logger.exiting(className, "prepareStatement", stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        String methodName = "prepareStatement";
        this.logger.entering(className, "prepareStatement", new Object[]{sql, columnIndexes});
        this._validate("prepareStatement");
        RDMPreparedStatement stmt = this.doCreatePreparedStatement(sql, columnIndexes);
        this.logger.exiting(className, "prepareStatement", stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String methodName = "prepareStatement";
        this.logger.entering(className, "prepareStatement", new Object[]{sql, resultSetType, resultSetConcurrency});
        this._validate("prepareStatement");
        this.validateResultSetType("prepareStatement", resultSetType);
        this.validateResultSetConcurrency("prepareStatement", resultSetConcurrency);
        RDMPreparedStatement stmt = this.doCreatePreparedStatement(sql, resultSetType, resultSetConcurrency);
        this.logger.exiting(className, "prepareStatement", stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String methodName = "prepareStatement";
        this.logger.entering(className, "prepareStatement", new Object[]{sql, resultSetType, resultSetConcurrency, resultSetHoldability});
        this._validate("prepareStatement");
        this.validateResultSetType("prepareStatement", resultSetType);
        this.validateResultSetConcurrency("prepareStatement", resultSetConcurrency);
        this.validateResultSetHoldability("prepareStatement", resultSetHoldability);
        RDMPreparedStatement stmt = this.doCreatePreparedStatement(sql, resultSetType, resultSetConcurrency);
        this.logger.exiting(className, "prepareStatement", stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String methodName = "prepareStatement";
        this.logger.entering(className, "prepareStatement", new Object[]{sql, columnNames});
        this._validate("prepareStatement");
        RDMPreparedStatement stmt = this.doCreatePreparedStatement(sql, columnNames);
        this.logger.exiting(className, "prepareStatement", stmt);
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        String methodName = "releaseSavepoint";
        this.logger.entering(className, methodName, savepoint);
        this._validate(methodName);
        if (this._getAutoCommit()) {
            throw this.createSQLException(methodName, cannotRollback);
        }
        LinkedList<RDMSavepoint> linkedList = this.savepointList;
        synchronized (linkedList) {
            int ndx = this.savepointList.indexOf(savepoint);
            if (ndx == -1) {
                throw this.createSQLException(methodName, savepointNotValid);
            }
            try {
                while (this.savepointList.size() > ndx) {
                    RDMSavepoint sp = this.savepointList.removeLast();
                    this.sql.releaseSavepoint(sp.getInternalName());
                }
            }
            catch (RDMException e) {
                throw this.createSQLException(methodName, e);
            }
        }
        this.logger.exiting(className, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        String methodName = "rollback";
        this.logger.entering(className, "rollback");
        this._validate("rollback");
        if (this._getAutoCommit()) {
            throw this.createSQLException("rollback", cannotRollback);
        }
        try {
            this._clearWarnings();
            this.sql.rollback();
            SQLWarning warning = this.sql.getWarnings();
            if (warning != null) {
                this.addWarning(warning);
            }
        }
        catch (RDMException e) {
            throw this.createSQLException("rollback", e);
        }
        LinkedList<RDMSavepoint> linkedList = this.savepointList;
        synchronized (linkedList) {
            this.savepointList.clear();
        }
        this.closeResultSets();
        this.logger.exiting(className, "rollback");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        String methodName = "rollback";
        this.logger.entering(className, "rollback", savepoint);
        this._validate("rollback");
        if (this._getAutoCommit()) {
            throw this.createSQLException("rollback", cannotRollback);
        }
        LinkedList<RDMSavepoint> linkedList = this.savepointList;
        synchronized (linkedList) {
            int ndx = this.savepointList.indexOf(savepoint);
            if (ndx == -1) {
                throw this.createSQLException("rollback", savepointNotValid);
            }
            try {
                this.sql.rollbackToSavepoint(((RDMSavepoint)savepoint).getInternalName());
            }
            catch (RDMException e) {
                throw this.createSQLException("rollback", e);
            }
            while (this.savepointList.size() > ndx) {
                this.savepointList.removeLast();
            }
        }
        this.logger.exiting(className, "rollback");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        String methodName = "setAutoCommit";
        this.logger.entering(className, "setAutoCommit", autoCommit);
        this._validate("setAutoCommit");
        try {
            this.sql.setOption("autocommit", autoCommit);
        }
        catch (RDMException e) {
            throw this.createSQLException("setAutoCommit", e);
        }
        this.url.setAutoCommit(autoCommit);
        this.logger.exiting(className, "setAutoCommit");
    }

    public void setSQLOptions() throws SQLException {
        String methodName = "setSQLOptions";
        this.logger.entering(className, "setSQLOptions");
        this._validate("setSQLOptions");
        try {
            String optString = String.format("cache_size=%d;autocommit=%d;dateformat='%s';timeout=%d;snapshotmode='%s';optimizeparameters=%d", this.url.getCacheSize(), this._getAutoCommit() ? 1 : 0, this.url.getDateFormat(), this.url.getLockTimeout(), this.url.getROTMode() ? "auto" : "manual", this.url.getOptimizeParameters() ? 1 : 0);
            String strStorage = this.url.getStorage();
            if (!strStorage.equals("")) {
                optString = optString + String.format(";storage=%s", strStorage);
            }
            this.sql.setOptions(optString);
        }
        catch (RDMException e) {
            throw this.createSQLException("setSQLOptions", e);
        }
        this.logger.exiting(className, "setSQLOptions");
    }

    @Override
    public void setNetworkTimeout(Executor exec, int milisecs) throws SQLException {
        String methodName = "setNetworkTimeout";
        this.logger.entering(className, "setNetworkTimeout");
        throw this.createSQLFeatureNotSupportedException("setNetworkTimeout", "not supported");
    }

    private void setDateFormat(String format) throws SQLException {
        String methodName = "setDateFormat";
        this.logger.entering(className, "setDateFormat", format);
        this._validate("setDateFormat");
        try {
            this.sql.setOption("dateformat", format);
        }
        catch (RDMException e) {
            throw this.createSQLException("setDateFormat", e);
        }
        this.logger.exiting(className, "setDateFormat");
    }

    public void setLockTimeout(int timeout) throws SQLException {
        String methodName = "setLockTimeout";
        this.logger.entering(className, "setLockTimeout", timeout);
        this._validate("setLockTimeout");
        try {
            this.sql.setOption("timeout", timeout);
        }
        catch (RDMException e) {
            throw this.createSQLException("setLockTimeout", e);
        }
        this.url.setLockTimeout(timeout);
        this.logger.exiting(className, "setLockTimeout");
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        String methodName = "setCatalog";
        this.logger.entering(className, "setCatalog", catalog);
        this._validate("setCatalog");
        this.logger.exiting(className, "setCatalog");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        String methodName = "setClientInfo";
        this.logger.entering(className, "setClientInfo", new Object[]{name, value});
        this._validateCI("setClientInfo");
        Properties props = this.url.getProperties();
        props.setProperty(name, value);
        this.url.override(props);
        this.logger.exiting(className, "setClientInfo");
    }

    @Override
    public void setClientInfo(Properties props) throws SQLClientInfoException {
        String methodName = "setClientInfo";
        this.logger.entering(className, "setClientInfo", props);
        this._validateCI("setClientInfo");
        this.url.override(props);
        this.logger.exiting(className, "setClientInfo");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        String methodName = "setHoldability";
        this.logger.entering(className, "setHoldability", holdability);
        this._validate("setHoldability");
        this.validateResultSetHoldability("setHoldability", holdability);
        this.logger.exiting(className, "setHoldability");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        String methodName = "setReadOnly";
        this.logger.entering(className, "setReadOnly", readOnly);
        this._validate("setReadOnly");
        if (readOnly != this.url.getReadOnlyMode()) {
            throw this.createSQLFeatureNotSupportedException("setReadOnly", "Cannot set or remove read only mode on an existing connection - instead use the 'open mode' connection property");
        }
        this.logger.exiting(className, "setReadOnly");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint() throws SQLException {
        RDMSavepoint sp;
        String methodName = "setSavepoint";
        this.logger.entering(className, "setSavepoint");
        this._validate("setSavepoint");
        if (this._getAutoCommit()) {
            throw this.createSQLException("setSavepoint", cannotCreateSavepoint);
        }
        LinkedList<RDMSavepoint> linkedList = this.savepointList;
        synchronized (linkedList) {
            int id = this.nextSavePointId;
            sp = new RDMSavepoint(id);
            try {
                this.sql.createSavepoint(sp.getSavepointName());
            }
            catch (RDMException e) {
                throw this.createSQLException("setSavepoint", e);
            }
            this.savepointList.add(sp);
        }
        this.logger.exiting(className, "setSavepoint", sp);
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        String methodName = "setSavepoint";
        this.logger.entering(className, "setSavepoint", name);
        this._validate("setSavepoint");
        if (this._getAutoCommit()) {
            throw this.createSQLException("setSavepoint", cannotCreateSavepoint);
        }
        RDMSavepoint sp = new RDMSavepoint(name);
        try {
            this.sql.createSavepoint(sp.getSavepointName());
        }
        catch (RDMException e) {
            throw this.createSQLException("setSavepoint", e);
        }
        LinkedList<RDMSavepoint> linkedList = this.savepointList;
        synchronized (linkedList) {
            this.savepointList.add(sp);
        }
        this.logger.exiting(className, "setSavepoint", sp);
        return sp;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        String methodName = "setSchema";
        this.logger.entering(className, "setSchema", schema);
        throw this.createSQLFeatureNotSupportedException("setSchema", "not supported");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        String methodName = "setTransactionIsolation";
        this.logger.entering(className, "setTransactionIsolation", level);
        this._validate("setTransactionIsolation");
        try {
            if (this.sql.transStatus()) {
                throw this.createSQLException("setTransactionIsolation", "Invalid operation - a transaction is active");
            }
        }
        catch (RDMException e) {
            throw this.createSQLException("setTransactionIsolation", e);
        }
        this.url.setTransIsolation(level);
        this.logger.exiting(className, "setTransactionIsolation");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        String methodName = "setTypeMap";
        this.logger.entering(className, "setTypeMap", map);
        this._validate("setTypeMap");
        this.typeMap = map;
        this.logger.exiting(className, "setTypeMap");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodName = "unwrap";
        this.logger.entering(className, "unwrap", iface);
        if (!iface.isInstance(this)) {
            throw this.createSQLException("unwrap", "not an instance");
        }
        T result = iface.cast(this);
        this.logger.exiting(className, "unwrap", result);
        return result;
    }

    protected RSQL getSQL() {
        return this.sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromList(RDMStatement s) {
        LinkedList<RDMStatement> linkedList = this.stmtList;
        synchronized (linkedList) {
            this.stmtList.remove(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWarning(SQLWarning warning) {
        Object object = this.warningsSync;
        synchronized (object) {
            if (this.warnings == null) {
                this.warnings = warning;
            } else {
                this.warnings.setNextWarning(warning);
            }
        }
    }

    private void _validate(String methodName) throws SQLException {
        if (this.sql == null) {
            throw new RDMSQLException().createSQLException();
        }
    }

    private void _validateCI(String methodName) throws SQLClientInfoException {
        if (this.sql == null) {
            SQLClientInfoException sqlex = new SQLClientInfoException("Invalid connection", null);
            this.logger.throwing(className, methodName, sqlex);
            throw sqlex;
        }
    }

    private SQLException createSQLException(String methodName, RDMException e) throws SQLException {
        SQLException sqlex = e.createSQLException();
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }

    private SQLException createSQLException(String methodName, String error) throws SQLException {
        SQLException sqlex = new SQLException(error);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }

    private SQLException createSQLFeatureNotSupportedException(String methodName, String error) throws SQLException {
        SQLFeatureNotSupportedException sqlex = new SQLFeatureNotSupportedException(error);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }

    protected void finalize() {
        if (this.sql != null) {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public int getDefaultFetchSize() throws SQLException {
        String methodName = "getDefaultFetchSize";
        this.logger.entering(className, "getDefaultFetchSize");
        this._validate("getDefaultFetchSize");
        int fetchSize = this.defaultFetchSize;
        this.logger.exiting(className, "getDefaultFetchSize", fetchSize);
        return fetchSize;
    }

    public void setDefaultFetchSize(int fetchSize) throws SQLException {
        String methodName = "stDefaultFetchSize";
        this.logger.entering(className, "stDefaultFetchSize");
        this._validate("stDefaultFetchSize");
        this.defaultFetchSize = fetchSize;
        this.logger.exiting(className, "stDefaultFetchSize", fetchSize);
    }
}

