/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.util.ClobHandler;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

class RDMClobReader
extends Reader {
    long pos;
    long markpos;
    long maxlen;
    ClobHandler clobhandler;

    public RDMClobReader(ClobHandler clobhandler) throws IOException {
        this.clobhandler = clobhandler;
        this.pos = 0L;
        this.markpos = 0L;
        this.maxlen = clobhandler.size();
    }

    public RDMClobReader(ClobHandler clobhandler, long pos, long len) throws IOException {
        this.clobhandler = clobhandler;
        this.pos = pos;
        this.markpos = pos;
        this.maxlen = len;
    }

    @Override
    public void close() {
        this.clobhandler = null;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (this.clobhandler == null) {
            throw new IOException();
        }
        this.markpos = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.clobhandler == null) {
            throw new IOException();
        }
        int c = this.clobhandler.read(this.pos);
        if (c != -1) {
            ++this.pos;
        }
        return c;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf == null ? 0 : cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.clobhandler == null) {
            throw new IOException();
        }
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len < 0 || off + len > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        len = this.clobhandler.read(this.pos, cbuf, off, len);
        this.pos += (long)len;
        return len;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        char[] cbuf = new char[1024];
        int len = this.read(cbuf);
        if (len != -1) {
            target.put(cbuf, 0, len);
        }
        return len;
    }

    @Override
    public boolean ready() throws IOException {
        if (this.clobhandler == null) {
            throw new IOException();
        }
        return true;
    }

    @Override
    public void reset() throws IOException {
        this.pos = this.markpos;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.clobhandler == null) {
            throw new IOException();
        }
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        if (this.pos >= this.maxlen) {
            return 0L;
        }
        if (this.maxlen - this.pos < n) {
            n = this.maxlen - this.pos;
        }
        this.pos += n;
        return n;
    }
}

