/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.util.ClobHandler;
import java.io.IOException;
import java.io.InputStream;

class RDMClobInputStream
extends InputStream {
    long pos;
    long maxlen;
    long markpos;
    ClobHandler clobhandler;

    public RDMClobInputStream(ClobHandler clobhandler) throws IOException {
        this.pos = 0L;
        this.markpos = 0L;
        this.clobhandler = clobhandler;
        this.maxlen = clobhandler.size();
    }

    public RDMClobInputStream(ClobHandler clobhandler, long pos, long len) throws IOException {
        this.pos = pos;
        this.markpos = pos;
        this.clobhandler = clobhandler;
        this.maxlen = len;
    }

    @Override
    public int available() throws IOException {
        if (this.clobhandler == null) {
            throw new IOException("InputStream is closed");
        }
        return (int)Math.min(this.maxlen, Integer.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
        this.clobhandler = null;
    }

    @Override
    public void mark(int readlimit) {
        this.markpos = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.clobhandler == null) {
            throw new IOException("InputStream is closed");
        }
        int c = this.clobhandler.read(this.pos);
        if (c != -1) {
            ++this.pos;
        }
        return c;
    }

    private int _read(byte[] b, int off, int len) throws IOException {
        char[] carray = new char[len];
        if ((len = this.clobhandler.read(this.pos, carray)) != -1) {
            for (int ii = 0; ii < len; ++ii) {
                b[off + ii] = (byte)carray[ii];
            }
            this.pos += (long)len;
        }
        return len;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.clobhandler == null) {
            throw new IOException("InputStream is closed");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        return this._read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.clobhandler == null) {
            throw new IOException("InputStream is closed");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        return this._read(b, off, len);
    }

    @Override
    public void reset() throws IOException {
        if (this.clobhandler == null) {
            throw new IOException("InputStream is closed");
        }
        this.pos = this.markpos;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.clobhandler == null) {
            throw new IOException("InputStream is closed");
        }
        long len = Math.min(n, this.maxlen - this.pos);
        this.pos += len;
        return len;
    }
}

