/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.StringTranslator;
import com.sap.dbtech.util.UnicodeUtil;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class UnicodeStringTranslator
extends StringTranslator {
    UnicodeStringTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
        this.characterDatatypePostfix = " UNICODE";
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            result = mem.getStrippedUnicodeString(this.bufpos_output, this.logicalLength * 2);
        }
        return result;
    }

    public byte[] getBytes(SQLParamController controller, DataPart mem) throws SQLException {
        String result = this.getString(controller, mem);
        if (result != null) {
            try {
                return result.getBytes("UTF-16BE");
            }
            catch (UnsupportedEncodingException ex) {
                throw this.newParseException(result, "UTF-16BE");
            }
        }
        return null;
    }

    public Object transBytesForInput(byte[] val) throws SQLException {
        if (val == null) {
            return val;
        }
        this.checkFieldLimits(val.length);
        return val;
    }

    public Object transStringForInput(String arg) throws SQLException {
        if (arg == null) {
            return null;
        }
        char[] chars = arg.toCharArray();
        byte[] bytes = UnicodeUtil.char2BigUnicode(chars);
        this.checkFieldLimits(bytes.length);
        return bytes;
    }

    protected void putSpecific(DataPart dataPart, Object data) {
        dataPart.putDefineByte(1, this.bufpos_input - 1);
        dataPart.putUnicodeBytes((byte[])data, this.bufpos_input, this.physicalLength - 1);
    }
}

