/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.InternalStatementSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import java.sql.SQLException;
import java.sql.Savepoint;

public class SavepointSapDB
implements Savepoint {
    private int SavepointId = 0;
    private String SavepointName = null;
    private boolean released = false;
    private static int savepointIndex = 0;
    private static final String savepointPrefix_C = "JDBC_SP_";
    private InternalStatementSapDB internalStmt = null;

    public SavepointSapDB(ConnectionSapDB conn) throws SQLException {
        this.SavepointId = SavepointSapDB.nextSavepointID();
        this.internalStmt = new InternalStatementSapDB(conn, 5);
    }

    public SavepointSapDB(String aSavepointName, ConnectionSapDB conn) throws SQLException {
        this.SavepointName = aSavepointName;
        this.internalStmt = new InternalStatementSapDB(conn, 5);
    }

    public int getSavepointId() throws SQLException {
        if (this.SavepointId == 0) {
            throw SQLExceptionSapDB.generateSQLException("error.named.savepoint");
        }
        return this.SavepointId;
    }

    public String getSavepointName() throws SQLException {
        if (this.SavepointName == null) {
            throw SQLExceptionSapDB.generateSQLException("error.unnamed.savepoint");
        }
        return this.SavepointName;
    }

    static final synchronized int nextSavepointID() {
        return ++savepointIndex;
    }

    final String getInternalSavepointName() {
        if (this.SavepointName == null) {
            return savepointPrefix_C + String.valueOf(this.SavepointId);
        }
        return this.SavepointName;
    }

    private void rollbackSavepoint() throws SQLException {
        this.internalStmt.execute("ROLLBACK TO SAVEPOINT " + this.getInternalSavepointName());
    }

    private void releaseSavepoint() throws SQLException {
        this.released = true;
        if (this.internalStmt.getConnectionSapDB().isReleaseSavePointSupported()) {
            try {
                this.internalStmt.execute("RELEASE SAVEPOINT " + this.getInternalSavepointName());
            }
            catch (SQLException sqlEx) {
                if (sqlEx.getErrorCode() == -3005) {
                    this.internalStmt.getConnectionSapDB().setReleaseSavePointSupported(false);
                }
                throw sqlEx;
            }
        }
    }

    private boolean isrelease() {
        return this.released;
    }

    public static Savepoint setSavepoint(ConnectionSapDB conn) throws SQLException {
        SavepointSapDB sp = new SavepointSapDB(conn);
        sp.internalStmt.execute("SAVEPOINT " + sp.getInternalSavepointName());
        return sp;
    }

    public static Savepoint setSavepoint(String SavepointName, ConnectionSapDB conn) throws SQLException {
        SavepointSapDB sp = new SavepointSapDB(SavepointName, conn);
        sp.internalStmt.execute("SAVEPOINT " + sp.getInternalSavepointName());
        return sp;
    }

    public static void rollback(Savepoint savepoint) throws SQLException {
        SavepointSapDB sp;
        try {
            sp = (SavepointSapDB)savepoint;
        }
        catch (ClassCastException classCastEx) {
            throw SQLExceptionSapDB.generateSQLException("error.nosavepointsapdb", savepoint.getClass());
        }
        if (sp.isrelease()) {
            throw SQLExceptionSapDB.generateSQLException("error.savepoint.released");
        }
        sp.rollbackSavepoint();
    }

    public static void releaseSavepoint(Savepoint savepoint) throws SQLException {
        SavepointSapDB sp;
        try {
            sp = (SavepointSapDB)savepoint;
        }
        catch (ClassCastException _exc) {
            throw SQLExceptionSapDB.generateSQLException("error.nosavepointsapdb", savepoint.getClass());
        }
        if (sp.isrelease()) {
            throw SQLExceptionSapDB.generateSQLException("error.savepoint.released");
        }
        sp.releaseSavepoint();
    }
}

