/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import oracle.jdbc.SecurityInformation;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.ucp.ConnectionCreationInformation;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.ConnectionFactoryAdapterBase;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;

public abstract class JDBCConnectionFactoryAdapter
extends ConnectionFactoryAdapterBase {
    static final String CLASS_NAME = JDBCConnectionFactoryAdapter.class.getName();
    protected String m_url = "";

    public JDBCConnectionFactoryAdapter(Diagnosable diagnosticsCollector) {
        super(diagnosticsCollector);
    }

    public JDBCConnectionFactoryAdapter() {
        this(DiagnosticsCollectorImpl.getCommon());
    }

    public void initializeUrlFromConnectionFactory() {
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    @Override
    public UniversalPooledConnection createPooledConnection(Object connection, ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        JDBCConnectionPool jdbccp = (JDBCConnectionPool)this.getUniversalConnectionPool();
        return new JDBCUniversalPooledConnection(jdbccp, connection, connectionRequestInfo, jdbccp.isFailoverEnabled());
    }

    private Consumer<ConnectionCreationInformation> getConnectionCreationConsumer() {
        try {
            UniversalConnectionPool pool = this.getUniversalConnectionPool();
            if (Objects.isNull(pool) || !(pool instanceof JDBCConnectionPool)) {
                this.trace(Level.WARNING, CLASS_NAME, "getConnectionCreationConsumer", "connection pool is null or not of a JDBC type", null, null, new Object[0]);
                return null;
            }
            return ((JDBCConnectionPool)pool).getConnectionCreationConsumer();
        }
        catch (Throwable e) {
            this.trace(Level.WARNING, CLASS_NAME, "getConnectionCreationConsumer", "failed to get connection creation consumer", null, null, new Object[0]);
            return null;
        }
    }

    protected void onFailedConnectionCreation(final Throwable throwable) {
        SQLException sqle;
        Consumer<ConnectionCreationInformation> consumer = this.getConnectionCreationConsumer();
        if (Objects.isNull(consumer)) {
            return;
        }
        if (Objects.isNull(throwable)) {
            this.trace(Level.WARNING, CLASS_NAME, "onFailedConnectionCreation", "null throwable passed", null, null, new Object[0]);
            return;
        }
        if (throwable instanceof SQLException) {
            sqle = (SQLException)throwable;
        } else {
            sqle = null;
            this.trace(Level.WARNING, CLASS_NAME, "onFailedConnectionCreation", "wrong connection creation error type", null, throwable, new Object[0]);
        }
        ConnectionCreationInformation info = new ConnectionCreationInformation(){

            @Override
            public ConnectionCreationInformation.Status getStatus() {
                return ConnectionCreationInformation.Status.FAILURE;
            }

            @Override
            public int getErrorCode() throws SQLException {
                if (Objects.isNull(sqle)) {
                    throw new SQLException("connection creation operation threw not an SQLException: " + Arrays.toString(throwable.getStackTrace()));
                }
                return sqle.getErrorCode();
            }

            @Override
            public String getNetConnectionId() {
                return null;
            }

            @Override
            public String getInstanceName() {
                return null;
            }

            @Override
            public String getServiceName() {
                return null;
            }

            @Override
            public String getHostName() {
                return null;
            }

            @Override
            public String getDatabaseUniqueId() {
                return null;
            }

            @Override
            public String getInstanceId() {
                return null;
            }

            @Override
            public SecurityInformation getSecurityInformation() {
                return null;
            }
        };
        try {
            this.getConnectionCreationConsumer().accept(info);
        }
        catch (Throwable e) {
            this.trace(Level.WARNING, CLASS_NAME, "onFailedConnectionCreation", "unchecked exception from connection creation consumer", null, e, new Object[0]);
        }
    }

    protected void onSuccessfulConnectionCreation(Object connection) {
        Consumer<ConnectionCreationInformation> consumer = this.getConnectionCreationConsumer();
        if (Objects.isNull(consumer)) {
            return;
        }
        if (Objects.isNull(connection)) {
            this.trace(Level.WARNING, CLASS_NAME, "onSuccessfulConnectionCreation", "null connection passed", null, null, new Object[0]);
            return;
        }
        oracle.jdbc.OracleConnection oc = null;
        try {
            if (connection instanceof oracle.jdbc.OracleConnection) {
                oc = (oracle.jdbc.OracleConnection)connection;
            } else if (connection instanceof OracleXAConnection) {
                oc = ((OracleXAConnection)connection).getPhysicalHandle().unwrap(oracle.jdbc.OracleConnection.class);
            } else if (connection instanceof OraclePooledConnection) {
                oc = ((OraclePooledConnection)connection).getConnection().unwrap(oracle.jdbc.OracleConnection.class);
            }
        }
        catch (SQLException sqle) {
            this.trace(Level.WARNING, CLASS_NAME, "onSuccessfulConnectionCreation", "not an Oracle connection " + connection, null, null, new Object[0]);
        }
        final oracle.jdbc.OracleConnection oracleConnection = oc;
        ConnectionCreationInformation info = new ConnectionCreationInformation(){

            @Override
            public ConnectionCreationInformation.Status getStatus() {
                return ConnectionCreationInformation.Status.SUCCESS;
            }

            @Override
            public int getErrorCode() {
                return 0;
            }

            @Override
            public String getNetConnectionId() throws SQLException {
                if (Objects.isNull(oracleConnection)) {
                    throw new SQLException("not an Oracle connection");
                }
                return oracleConnection.getNetConnectionId();
            }

            @Override
            public String getInstanceName() throws SQLException {
                if (Objects.isNull(oracleConnection)) {
                    throw new SQLException("not an Oracle connection");
                }
                OracleConnection internalOracleConnection = (OracleConnection)oracleConnection.unwrap(OracleConnection.class);
                return internalOracleConnection.getServerSessionInfo("INSTANCE_NAME");
            }

            @Override
            public String getServiceName() throws SQLException {
                if (Objects.isNull(oracleConnection)) {
                    throw new SQLException("not an Oracle connection");
                }
                OracleConnection internalOracleConnection = (OracleConnection)oracleConnection.unwrap(OracleConnection.class);
                return internalOracleConnection.getServerSessionInfo("SERVICE_NAME");
            }

            @Override
            public String getHostName() throws SQLException {
                if (Objects.isNull(oracleConnection)) {
                    throw new SQLException("not an Oracle connection");
                }
                OracleConnection internalOracleConnection = (OracleConnection)oracleConnection.unwrap(OracleConnection.class);
                return internalOracleConnection.getServerSessionInfo("SERVER_HOST");
            }

            @Override
            public String getDatabaseUniqueId() throws SQLException {
                if (Objects.isNull(oracleConnection)) {
                    throw new SQLException("not an Oracle connection");
                }
                OracleConnection internalOracleConnection = (OracleConnection)oracleConnection.unwrap(OracleConnection.class);
                return internalOracleConnection.getServerSessionInfo("AUTH_GLOBALLY_UNIQUE_DBID");
            }

            @Override
            public String getInstanceId() throws SQLException {
                if (Objects.isNull(oracleConnection)) {
                    throw new SQLException("not an Oracle connection");
                }
                OracleConnection internalOracleConnection = (OracleConnection)oracleConnection.unwrap(OracleConnection.class);
                return internalOracleConnection.getServerSessionInfo("AUTH_SC_INSTANCE_ID");
            }

            @Override
            public SecurityInformation getSecurityInformation() throws SQLException {
                if (Objects.isNull(oracleConnection)) {
                    throw new SQLException("not an Oracle connection");
                }
                return oracleConnection.getSecurityInformation();
            }
        };
        try {
            this.getConnectionCreationConsumer().accept(info);
        }
        catch (Throwable e) {
            this.trace(Level.WARNING, CLASS_NAME, "onSuccessfulConnectionCreation", "unchecked exception from connection creation consumer", null, e, new Object[0]);
        }
    }
}

