/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.prompt;

import com.dbeaver.model.ai.AIAssistantPro;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AIAssistantResponse;
import org.jkiss.dbeaver.model.ai.AICompletionSettings;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.AISqlFormatter;
import org.jkiss.dbeaver.model.ai.AITextUtils;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.impl.AIPromptUtils;
import org.jkiss.dbeaver.model.ai.impl.MessageChunk;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptAbstract;
import org.jkiss.dbeaver.model.ai.registry.AIAssistantRegistry;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSourceSupplier;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AIPromptSqlCompletion
extends AIPromptAbstract {
    private static final String[] SQL_COMPLETION_GOALS = new String[]{"Provide a meaningful SQL fragment that continues or improves the query at specified position."};
    private static final String[] SQL_COMPLETION_INSTRUCTIONS = new String[]{"Scan the input for special SQL comments such as\n   -- add 3 rows in orders\n   -- remove orders with price > 1000\n   If such a comment appears, carry out its instruction instead of suggesting autocomplete.", "Otherwise, return **only** the next meaningful SQL fragment.", "Do not repeat any part of the existing query \u2014 produce new text only.", "Do not return a full query; supply just the fragment for insertion.", "If the fragment starts with a keyword that is right before the position, omit the keyword.", "If the cursor is right after `WHERE`, suggest only the condition without keywords.", "Add `AND` or `OR` keywords if needed.", "If the fragment is right after the keyword `JOIN` or `FROM`, suggest table name with condition.", "Exclude comments from your response."};
    private static final String[] SQL_COMPLETION_EXAMPLES = new String[]{"Correct examples:\n- Query: SELECT * FROM users WHERE \u2192 active = true\n- Query: SELECT * FROM orders WHERE total > \u2192 100\n- Query: SELECT * FROM us \u2192 ers", "Incorrect examples:\n- Query: SELECT * FROM users WHERE \u2192 SELECT * FROM users WHERE active = true (repeats query)\n- Query: SELECT * FROM orders \u2192 WHERE total > 100 ORDER BY date (too much at once)\n- Query: SELECT * FROM us \u2192 users (partially repeats query)"};
    private static final String[] SQL_COMPLETION_OUTPUT_FORMATS = new String[]{"A clean, raw SQL fragment with no comments or explanations."};

    @NotNull
    public static String readCompletionSuggestion(@NotNull DBRProgressMonitor monitor, @NotNull DBPWorkspace workspace, @NotNull DBCExecutionContext executionContext, @NotNull String queryText, int cursorPosition) throws DBException {
        AIMessage message;
        AIPromptSqlCompletion prompt;
        AIAssistantPro aiAssistant = (AIAssistantPro)AIAssistantRegistry.getInstance().createAssistant(workspace);
        DBPDataSourceContainer dataSourceContainer = executionContext.getDataSource().getContainer();
        AICompletionSettings completionSettings = new AICompletionSettings(dataSourceContainer);
        if (!completionSettings.isMetaTransferConfirmed()) {
            throw new DBException("AI assistant disabled for " + dataSourceContainer.getName());
        }
        AIUtils.updateScopeSettingsIfNeeded((AIContextSettings)completionSettings, (DBPDataSourceContainer)dataSourceContainer, (DBCExecutionContext)executionContext);
        AIDatabaseScope scope = completionSettings.getScope();
        if (scope == null) {
            throw new DBException("AI scope not determined");
        }
        DBSLogicalDataSource logicalDataSource = new DBSLogicalDataSource(dataSourceContainer);
        AIDatabaseContext aiContext = new AIDatabaseContext.Builder(logicalDataSource).setExecutionContext(executionContext).setScope(scope).build();
        AIAssistantResponse suggestion = aiAssistant.generateText(monitor, aiContext, (AIPromptGenerator)(prompt = AIPromptSqlCompletion.create(() -> logicalDataSource)), List.of(message = AIMessage.userMessage((String)("The user is currently editing the following SQL query at position " + cursorPosition + " : " + queryText))));
        if (!suggestion.isText()) {
            throw new DBException("AI assistant returned " + String.valueOf(suggestion) + " - it cannot be used as suggestion");
        }
        MessageChunk[] messageChunks = AITextUtils.processAndSplitCompletion((DBRProgressMonitor)monitor, (AIDatabaseContext)aiContext, (AISqlFormatter)AIAssistantRegistry.getInstance().getDescriptor().createSqlFormatter(), (String)suggestion.getText());
        String suggestionText = "";
        String suggestionCode = "";
        MessageChunk[] messageChunkArray = messageChunks;
        int n = messageChunks.length;
        int n2 = 0;
        while (n2 < n) {
            MessageChunk chunk = messageChunkArray[n2];
            if (chunk instanceof MessageChunk.Code) {
                MessageChunk.Code code = (MessageChunk.Code)chunk;
                suggestionCode = code.text();
            } else if (chunk instanceof MessageChunk.Text) {
                MessageChunk.Text text = (MessageChunk.Text)chunk;
                suggestionText = text.text();
            }
            ++n2;
        }
        return suggestionText + suggestionCode;
    }

    @NotNull
    public String generatorId() {
        return "sql-completion";
    }

    @NotNull
    public static AIPromptSqlCompletion create(@NotNull DBSLogicalDataSourceSupplier dsSupplier) {
        AIPromptSqlCompletion builder = new AIPromptSqlCompletion();
        DBSLogicalDataSource dataSource = (DBSLogicalDataSource)dsSupplier.get();
        if (dataSource != null) {
            builder.addContexts(AIPromptUtils.describeDataSourceInfo((DBSLogicalDataSource)dataSource)).addInstructions(AIPromptUtils.createGenerateQueryInstructions((DBSLogicalDataSource)dataSource));
        }
        builder.addInstructions(SQL_COMPLETION_INSTRUCTIONS).addGoals(SQL_COMPLETION_GOALS).addExamples(SQL_COMPLETION_EXAMPLES).addOutputFormats(SQL_COMPLETION_OUTPUT_FORMATS);
        return builder;
    }
}

