/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.openai;

import com.dbeaver.model.ai.audio.AIAudioStream;
import com.dbeaver.model.ai.audio.AITranscriptResult;
import com.dbeaver.model.ai.engine.openai.OpenAIBaseProProperties;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIClient;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class OpenAITranscriber<PROPERTIES extends OpenAIBaseProProperties> {
    private static final Log log = Log.getLog(OpenAITranscriber.class);
    public static final String ENDPOINT = "audio/transcriptions";
    private static final String FORMAT_JSON = "json";
    private static final String FIELD_MODEL = "model";
    private static final String FIELD_RESPONSE_FORMAT = "response_format";
    private static final String FIELD_LANGUAGE = "language";
    private static final String FIELD_PROMPT = "prompt";
    private static final String CRLF = "\r\n";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(AITranscriptResult.Usage.class, (Object)new UsageAdapter()).create();
    private final OpenAIClient client;
    private final PROPERTIES properties;
    private final URI uri;

    public OpenAITranscriber(OpenAIClient client, PROPERTIES properties) {
        this(client, properties, URI.create("https://api.openai.com/v1/").resolve(ENDPOINT));
    }

    public OpenAITranscriber(OpenAIClient client, PROPERTIES properties, URI uri) {
        this.client = client;
        this.properties = properties;
        this.uri = uri;
    }

    @NotNull
    public CompletableFuture<AITranscriptResult> transcribe(@NotNull AIAudioStream audio) throws DBException {
        String boundary = "Boundary-" + String.valueOf(UUID.randomUUID());
        HttpRequest.Builder builder = this.createRequestBuilder(boundary);
        HttpRequest request = builder.POST(HttpRequest.BodyPublishers.ofInputStream(() -> {
            try {
                return OpenAITranscriber.buildMultipartInputStream(audio, boundary, this.properties.getTranscribeModel());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        })).build();
        request = this.client.applyFilters(request, false);
        HttpClient httpClient = this.client.getHttpClient();
        return httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).handle((response, ex) -> {
            if (ex != null) {
                throw new CompletionException("HTTP request failed", (Throwable)ex);
            }
            if (response.statusCode() != 200) {
                throw new CompletionException(new IOException("Service API error (" + response.statusCode() + "): " + (String)response.body()));
            }
            return (AITranscriptResult)GSON.fromJson((String)response.body(), AITranscriptResult.class);
        });
    }

    @NotNull
    protected HttpRequest.Builder createRequestBuilder(@NotNull String boundary) {
        return HttpRequest.newBuilder().uri(this.uri).timeout(Duration.ofSeconds(120L)).header("Content-Type", "multipart/form-data; boundary=" + boundary);
    }

    @NotNull
    public static InputStream buildMultipartInputStream(@NotNull AIAudioStream audio, @NotNull String boundary, @NotNull String model) throws IOException {
        String mime = audio.mimeType();
        String boundaryPrefix = "--" + boundary + CRLF;
        byte[] modelPart = OpenAITranscriber.buildPart(FIELD_MODEL, model, boundaryPrefix);
        byte[] responsePart = OpenAITranscriber.buildPart(FIELD_RESPONSE_FORMAT, FORMAT_JSON, boundaryPrefix);
        String useLanguage = DBWorkbench.getPlatform().getPreferenceStore().getString("ai.language");
        byte[] languagePart = CommonUtils.isEmpty((String)useLanguage) ? null : OpenAITranscriber.buildPart(FIELD_PROMPT, "Use language " + useLanguage + " in your responses", boundaryPrefix);
        byte[] fileHeaderPart = (boundaryPrefix + "Content-Disposition: form-data; name=\"file\"; filename=\"" + audio.fileName() + "\"\r\nContent-Type: " + mime + "\r\n\r\n").getBytes();
        byte[] endPart = ("\r\n--" + boundary + "--\r\n").getBytes();
        ArrayList<InputStream> parts = new ArrayList<InputStream>();
        parts.add(new ByteArrayInputStream(modelPart));
        parts.add(new ByteArrayInputStream(responsePart));
        if (languagePart != null) {
            parts.add(new ByteArrayInputStream(languagePart));
        }
        parts.add(new ByteArrayInputStream(fileHeaderPart));
        parts.add(audio.stream());
        parts.add(new ByteArrayInputStream(endPart));
        return new SequenceInputStream(Collections.enumeration(parts));
    }

    @NotNull
    private static byte[] buildPart(@NotNull String field, @NotNull String value, @NotNull String boundaryPrefix) {
        return (boundaryPrefix + "Content-Disposition: form-data; name=\"" + field + "\"\r\n\r\n" + value + CRLF).getBytes(StandardCharsets.UTF_8);
    }

    public static class UsageAdapter
    extends TypeAdapter<AITranscriptResult.Usage> {
        public void write(JsonWriter out, AITranscriptResult.Usage value) throws IOException {
            out.beginObject();
            out.name("seconds").value(value.duration().getSeconds());
            out.endObject();
        }

        public AITranscriptResult.Usage read(JsonReader in) throws IOException {
            Duration duration = null;
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if ("seconds".equals(name)) {
                    duration = Duration.ofSeconds(in.nextLong());
                    continue;
                }
                in.skipValue();
            }
            in.endObject();
            return new AITranscriptResult.Usage(duration);
        }
    }
}

