/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.gemini;

import com.dbeaver.model.ai.audio.AIAudioStream;
import com.dbeaver.model.ai.audio.AITranscriptResult;
import com.dbeaver.model.ai.engine.gemini.GeminiClient;
import com.dbeaver.model.ai.engine.gemini.GeminiProperties;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiCandidate;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiGenerateResponse;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.Base64;
import org.jkiss.utils.CommonUtils;

public record GeminiAITranscriber<PROPERTIES extends GeminiProperties>(@NotNull GeminiClient client, @NotNull PROPERTIES properties) {
    public static final String DEFAULT_MODEL = "models/gemini-2.5-flash";
    public static final String URI_TEMPLATE = "https://generativelanguage.googleapis.com/v1beta/%s:generateContent";
    private static final Duration API_REQUEST_TIMEOUT = Duration.ofMinutes(2L);

    @NotNull
    public CompletableFuture<AITranscriptResult> transcribe(@NotNull AIAudioStream audio) {
        String useLanguage = DBWorkbench.getPlatform().getPreferenceStore().getString("ai.language");
        String model = CommonUtils.isEmpty((String)((GeminiProperties)this.properties).getTranscribeModel()) ? DEFAULT_MODEL : ((GeminiProperties)this.properties).getTranscribeModel();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(URI_TEMPLATE.formatted(model))).timeout(API_REQUEST_TIMEOUT).header("x-goog-api-key", ((GeminiProperties)this.properties).getToken()).header("Accept", "application/json").header("Content-Type", "application/json; charset=utf-8").POST(HttpRequest.BodyPublishers.ofInputStream(() -> {
            try {
                return new SequenceInputStream(Collections.enumeration(List.of(new ByteArrayInputStream(GeminiAITranscriber.buildJsonPrefix(useLanguage, audio.mimeType())), new Base64InputStream(audio.stream()), new ByteArrayInputStream(GeminiAITranscriber.buildJsonSuffix()))));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        })).build();
        return this.client.getHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).thenApply(response -> {
            if (response.statusCode() / 100 != 2) {
                throw new CompletionException(new IOException("Service API error (" + response.statusCode() + "): " + (String)response.body()));
            }
            try {
                return this.parseResponse((String)response.body());
            }
            catch (DBException e) {
                throw new CompletionException("Cannot extract data from response", e);
            }
        });
    }

    @NotNull
    private static byte[] buildJsonPrefix(@Nullable String language, @NotNull String mime) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);
        JsonWriter jw = new JsonWriter((Writer)writer);
        try {
            jw.beginObject();
            jw.name("contents").beginArray();
            jw.beginObject();
            jw.name("parts").beginArray();
            jw.beginObject();
            GeminiAITranscriber.createPrompt(language, jw);
            jw.endObject();
            jw.beginObject();
            jw.name("inline_data").beginObject();
            jw.name("mime_type").value(mime);
            writer.write(",\"data\":\"");
            ((Writer)writer).flush();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void createPrompt(@Nullable String language, JsonWriter jw) throws IOException {
        String base = "Generate a transcript of the speech. Output plain text only.";
        String prompt = language != null && !language.isBlank() ? String.format("%s Use %s in your responses", base, language) : base;
        jw.name("text").value(prompt);
    }

    private static byte[] buildJsonSuffix() {
        return "\"}}]}]}".getBytes(StandardCharsets.UTF_8);
    }

    @NotNull
    private AITranscriptResult parseResponse(@NotNull String json) throws DBException {
        try {
            GeminiGenerateResponse response = (GeminiGenerateResponse)JSONUtils.GSON.fromJson(json, GeminiGenerateResponse.class);
            String text = response.candidates().stream().map(GeminiCandidate::content).filter(Objects::nonNull).map(GeminiCandidate.Content::parts).filter(parts -> parts != null && !parts.isEmpty()).map(parts -> ((GeminiCandidate.ContentPart)parts.getFirst()).text()).collect(Collectors.joining(","));
            return new AITranscriptResult(text, null);
        }
        catch (Exception e) {
            throw new DBException("Cannot parse Gemini response", (Throwable)e);
        }
    }

    public static final class Base64InputStream
    extends InputStream {
        private static final int SRC_CHUNK = 3072;
        private static final int DEFAULT_BUFFER_SIZE = 8192;
        private final InputStream src;
        private final byte[] inBuf = new byte[3072];
        private final ByteArrayOutputStream chunk = new ByteArrayOutputStream(8192);
        private final OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.chunk, StandardCharsets.UTF_8);
        private byte[] outBuf = new byte[0];
        private int pos = 0;
        private boolean eof = false;

        public Base64InputStream(@NotNull InputStream src) {
            this.src = src;
        }

        @Override
        public int read() throws IOException {
            if (this.pos >= this.outBuf.length && !this.refill()) {
                return -1;
            }
            return this.outBuf[this.pos++] & 0xFF;
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            if (this.pos >= this.outBuf.length && !this.refill()) {
                return -1;
            }
            int n = Math.min(len, this.outBuf.length - this.pos);
            System.arraycopy(this.outBuf, this.pos, b, off, n);
            this.pos += n;
            return n;
        }

        private boolean refill() throws IOException {
            if (this.eof) {
                return false;
            }
            int n = this.src.read(this.inBuf);
            if (n == -1) {
                this.eof = true;
                this.outBuf = new byte[0];
                this.pos = 0;
                return false;
            }
            this.chunk.reset();
            Base64.encode((byte[])this.inBuf, (int)0, (int)n, (Writer)this.writer);
            this.writer.flush();
            this.outBuf = this.chunk.toByteArray();
            this.pos = 0;
            return this.outBuf.length > 0;
        }

        @Override
        public void close() throws IOException {
            try {
                this.src.close();
            }
            finally {
                super.close();
            }
        }
    }
}

