/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.stringprep;

import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.stringprep.Option;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.stringprep.Profile;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.stringprep.StringprepLocator;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.stringprep.Tables;
import java.nio.CharBuffer;
import java.text.Normalizer;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.function.IntPredicate;

public final class Stringprep {
    private final Profile profile;
    private final boolean mapToNothing;
    private final boolean additionalMapping;
    private final boolean caseFoldNfkc;
    private final boolean caseFoldNoNormalization;
    private final boolean normalizeKc;
    private final boolean checkBidi;
    private final boolean forbidAdditionalCharacters;
    private final boolean forbidAsciiSpaces;
    private final boolean forbidNonAsciiSpaces;
    private final boolean forbidAsciiControl;
    private final boolean forbidNonAsciiControl;
    private final boolean forbidPrivateUse;
    private final boolean forbidNonCharacter;
    private final boolean forbidSurrogate;
    private final boolean forbidInappropriatePlainText;
    private final boolean forbidInappropriateCanonRep;
    private final boolean forbidChangeDisplayDeprecated;
    private final boolean forbidTagging;
    private final boolean forbidUnassigned;

    Stringprep(Profile profile, boolean storedStrings) {
        Objects.requireNonNull(profile);
        EnumSet options = EnumSet.copyOf(Objects.requireNonNull(profile.profile()));
        this.mapToNothing = options.contains((Object)Option.MAP_TO_NOTHING);
        this.additionalMapping = options.contains((Object)Option.ADDITIONAL_MAPPING);
        this.caseFoldNfkc = options.contains((Object)Option.CASE_FOLD_NFKC);
        this.caseFoldNoNormalization = options.contains((Object)Option.CASE_FOLD_NO_NORMALIZATION);
        this.normalizeKc = options.contains((Object)Option.NORMALIZE_KC);
        this.checkBidi = options.contains((Object)Option.CHECK_BIDI);
        this.forbidAdditionalCharacters = options.contains((Object)Option.FORBID_ADDITIONAL_CHARACTERS);
        this.forbidAsciiSpaces = options.contains((Object)Option.FORBID_ASCII_SPACES);
        this.forbidNonAsciiSpaces = options.contains((Object)Option.FORBID_NON_ASCII_SPACES);
        this.forbidAsciiControl = options.contains((Object)Option.FORBID_ASCII_CONTROL);
        this.forbidNonAsciiControl = options.contains((Object)Option.FORBID_NON_ASCII_CONTROL);
        this.forbidPrivateUse = options.contains((Object)Option.FORBID_PRIVATE_USE);
        this.forbidNonCharacter = options.contains((Object)Option.FORBID_NON_CHARACTER);
        this.forbidSurrogate = options.contains((Object)Option.FORBID_SURROGATE);
        this.forbidInappropriatePlainText = options.contains((Object)Option.FORBID_INAPPROPRIATE_FOR_PLAIN_TEXT);
        this.forbidInappropriateCanonRep = options.contains((Object)Option.FORBID_INAPPROPRIATE_FOR_CANON_REP);
        this.forbidChangeDisplayDeprecated = options.contains((Object)Option.FORBID_CHANGE_DISPLAY_AND_DEPRECATED);
        this.forbidTagging = options.contains((Object)Option.FORBID_TAGGING);
        this.forbidUnassigned = storedStrings;
        this.profile = profile;
    }

    public static Profile getProvider(String profileName) {
        Objects.requireNonNull(profileName, "The profile name must not be null");
        Profile profile = StringprepLocator.getProfile(profileName);
        if (profile == null) {
            throw new IllegalArgumentException("No provider found for: " + profileName);
        }
        return profile;
    }

    char[] prepare(char[] string) {
        int codePoint;
        Objects.requireNonNull(string, "The string to prepare must not be null");
        if (string.length == 0) {
            return string;
        }
        char[] value = (char[])string.clone();
        value = this.map(value);
        if (this.normalizeKc) {
            value = Normalizer.normalize(CharBuffer.wrap(value), Normalizer.Form.NFKC).toCharArray();
        }
        boolean firstRandAlCat = Tables.bidirectionalPropertyRorAL(Character.codePointAt(value, 0));
        boolean lastRandAlCat = Tables.bidirectionalPropertyRorAL(Character.codePointAt(value, value.length - 1));
        boolean containsRandAlCat = false;
        boolean containsLcat = false;
        for (int i = 0; i < value.length; i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(value, i);
            this.prohibitedOutput(codePoint);
            if (!this.checkBidi) continue;
            Stringprep.checkProhibited(true, Tables::prohibitionChangeDisplayProperties, codePoint, "Prohibited control character");
            if (Tables.bidirectionalPropertyRorAL(codePoint)) {
                containsRandAlCat = true;
            }
            if (Tables.bidirectionalPropertyL(codePoint)) {
                containsLcat = true;
            }
            if (containsRandAlCat && containsLcat) {
                throw new IllegalArgumentException("Prohibited string with RandALCat and LCat");
            }
            if (!containsRandAlCat || firstRandAlCat && lastRandAlCat) continue;
            throw new IllegalArgumentException("RandALCat character is not the first and the last character");
        }
        return value;
    }

    private char[] map(char[] string) {
        int codePoint;
        StringBuilder mapping = new StringBuilder(string.length);
        for (int i = 0; i < string.length; i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(string, i);
            if (this.mapToNothing && Tables.mapToNothing(codePoint)) continue;
            if (this.normalizeKc && this.caseFoldNfkc) {
                for (int cp : Tables.mapWithNfkc(codePoint)) {
                    mapping.appendCodePoint(cp);
                }
                continue;
            }
            if (!this.normalizeKc && this.caseFoldNoNormalization) {
                for (int cp : Tables.mapWithoutNormalization(codePoint)) {
                    mapping.appendCodePoint(cp);
                }
                continue;
            }
            if (this.additionalMapping) {
                for (int cp : this.profile.additionalMappingTable(codePoint)) {
                    mapping.appendCodePoint(cp);
                }
                continue;
            }
            mapping.appendCodePoint(codePoint);
        }
        char[] arr = new char[mapping.length()];
        mapping.getChars(0, mapping.length(), arr, 0);
        return arr;
    }

    private void prohibitedOutput(int codePoint) {
        Stringprep.checkProhibited(this.forbidAdditionalCharacters, this.profile::prohibitedAdditionalCharacters, codePoint, "Prohibited code point");
        Stringprep.checkProhibited(this.forbidAsciiSpaces, Tables::prohibitionAsciiSpace, codePoint, "Prohibited ASCII space");
        Stringprep.checkProhibited(this.forbidNonAsciiSpaces, Tables::prohibitionNonAsciiSpace, codePoint, "Prohibited non-ASCII space");
        Stringprep.checkProhibited(this.forbidAsciiControl, Tables::prohibitionAsciiControl, codePoint, "Prohibited ASCII control");
        Stringprep.checkProhibited(this.forbidNonAsciiControl, Tables::prohibitionNonAsciiControl, codePoint, "Prohibited non-ASCII control");
        Stringprep.checkProhibited(this.forbidPrivateUse, Tables::prohibitionPrivateUse, codePoint, "Prohibited private use character");
        Stringprep.checkProhibited(this.forbidNonCharacter, Tables::prohibitionNonCharacterCodePoints, codePoint, "Prohibited non-character code point");
        Stringprep.checkProhibited(this.forbidSurrogate, Tables::prohibitionSurrogateCodes, codePoint, "Prohibited surrogate code point");
        Stringprep.checkProhibited(this.forbidInappropriatePlainText, Tables::prohibitionInappropriatePlainText, codePoint, "Prohibited plain text code point");
        Stringprep.checkProhibited(this.forbidInappropriateCanonRep, Tables::prohibitionInappropriateCanonicalRepresentation, codePoint, "Prohibited non-canonical code point");
        Stringprep.checkProhibited(this.forbidChangeDisplayDeprecated, Tables::prohibitionChangeDisplayProperties, codePoint, "Prohibited control character");
        Stringprep.checkProhibited(this.forbidTagging, Tables::prohibitionTaggingCharacters, codePoint, "Prohibited tagging character");
        Stringprep.checkProhibited(this.forbidUnassigned, Tables::unassignedCodePoints, codePoint, "Unassigned code point");
    }

    private static void checkProhibited(boolean forbid, IntPredicate tableCheck, int codePoint, String msg) {
        if (forbid && tableCheck.test(codePoint)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s \"0x%04X\"", msg, codePoint));
        }
    }
}

