/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common;

import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.AbstractScramMessage;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ScramAttributeValue;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ScramAttributes;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.StringWritableCsv;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.exception.ScramParseException;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import org.jetbrains.annotations.NotNull;

public final class ServerFirstMessage
extends AbstractScramMessage {
    @NotNull
    private final String clientNonce;
    @NotNull
    private final String serverNonce;
    @NotNull
    private final String salt;
    private final int iterationCount;

    public ServerFirstMessage(@NotNull String clientNonce, @NotNull String serverNonce, @NotNull String salt, int iterationCount) {
        this.clientNonce = Preconditions.checkNotEmpty(clientNonce, "clientNonce");
        this.serverNonce = Preconditions.checkNotEmpty(serverNonce, "serverNonce");
        this.salt = Preconditions.checkNotNull(salt, "salt");
        this.iterationCount = Preconditions.gt0(iterationCount, "iterationCount");
    }

    @NotNull
    public String getClientNonce() {
        return this.clientNonce;
    }

    @NotNull
    public String getServerNonce() {
        return this.serverNonce;
    }

    @NotNull
    public String getNonce() {
        return this.clientNonce + this.serverNonce;
    }

    public String getSalt() {
        return this.salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    @NotNull
    public static ServerFirstMessage parseFrom(@NotNull String serverFirstMessage, @NotNull String clientNonce) throws ScramParseException {
        int iterationInt;
        Preconditions.checkNotEmpty(serverFirstMessage, "serverFirstMessage");
        Preconditions.checkNotEmpty(clientNonce, "clientNonce");
        String[] attributeValues = StringWritableCsv.parseFrom(serverFirstMessage, 3, 0);
        if (attributeValues.length != 3) {
            throw new ScramParseException("Invalid server-first-message");
        }
        ScramAttributeValue nonce = ScramAttributeValue.parse(Preconditions.castNonNull(attributeValues[0]));
        if (ScramAttributes.NONCE.getChar() != nonce.getChar()) {
            throw new ScramParseException("nonce must be the 1st element of the server-first-message");
        }
        if (!nonce.getValue().startsWith(clientNonce)) {
            throw new ScramParseException("parsed nonce does not start with client nonce");
        }
        ScramAttributeValue salt = ScramAttributeValue.parse(Preconditions.castNonNull(attributeValues[1]));
        if (ScramAttributes.SALT.getChar() != salt.getChar()) {
            throw new ScramParseException("salt must be the 2nd element of the server-first-message");
        }
        ScramAttributeValue iteration = ScramAttributeValue.parse(Preconditions.castNonNull(attributeValues[2]));
        if (ScramAttributes.ITERATION.getChar() != iteration.getChar()) {
            throw new ScramParseException("iteration must be the 3rd element of the server-first-message");
        }
        try {
            iterationInt = Integer.parseInt(iteration.getValue());
        }
        catch (NumberFormatException ex) {
            throw new ScramParseException("invalid iteration", ex);
        }
        return new ServerFirstMessage(clientNonce, nonce.getValue().substring(clientNonce.length()), salt.getValue(), iterationInt);
    }

    @Override
    StringBuilder writeTo(StringBuilder sb) {
        return StringWritableCsv.writeTo(sb, new ScramAttributeValue(ScramAttributes.NONCE, this.getNonce()), new ScramAttributeValue(ScramAttributes.SALT, this.salt), new ScramAttributeValue(ScramAttributes.ITERATION, Integer.toString(this.iterationCount)));
    }
}

