/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common;

import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.AbstractCharAttributeValue;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ScramAttributes;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.exception.ScramParseException;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import org.jetbrains.annotations.NotNull;

class ScramAttributeValue
extends AbstractCharAttributeValue<ScramAttributes> {
    public ScramAttributeValue(@NotNull ScramAttributes attribute, @NotNull String value) {
        super(attribute, Preconditions.checkNotNull(value, "value"));
    }

    @Override
    @NotNull
    public final String getValue() {
        return Preconditions.castNonNull(super.getValue());
    }

    @NotNull
    public static ScramAttributeValue parse(@NotNull String value) throws ScramParseException {
        if (value == null || value.length() < 3 || value.charAt(1) != '=') {
            throw new ScramParseException("Invalid ScramAttributeValue '" + value + "'");
        }
        return new ScramAttributeValue(ScramAttributes.byChar(value.charAt(0)), value.substring(2));
    }
}

