/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common;

import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.CharSupplier;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.Gs2CbindFlag;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ScramAttributes;
import org.jetbrains.annotations.NotNull;

enum Gs2Attributes implements CharSupplier
{
    CLIENT_NOT(Gs2CbindFlag.CLIENT_NOT.getChar(), false),
    CLIENT_YES_SERVER_NOT(Gs2CbindFlag.CLIENT_YES_SERVER_NOT.getChar(), false),
    CHANNEL_BINDING_REQUIRED(Gs2CbindFlag.CHANNEL_BINDING_REQUIRED.getChar(), true),
    AUTHZID(ScramAttributes.AUTHZID.getChar(), true);

    private final char flag;
    private final boolean requiredValue;

    private Gs2Attributes(char flag, boolean requiredValue) {
        this.flag = flag;
        this.requiredValue = requiredValue;
    }

    @Override
    public char getChar() {
        return this.flag;
    }

    boolean isRequiredValue() {
        return this.requiredValue;
    }

    @NotNull
    static Gs2Attributes byChar(char c) {
        switch (c) {
            case 'n': {
                return CLIENT_NOT;
            }
            case 'y': {
                return CLIENT_YES_SERVER_NOT;
            }
            case 'p': {
                return CHANNEL_BINDING_REQUIRED;
            }
            case 'a': {
                return AUTHZID;
            }
        }
        throw new IllegalArgumentException("Invalid GS2Attribute character '" + c + "'");
    }

    @NotNull
    static Gs2Attributes byGs2CbindFlag(Gs2CbindFlag cbindFlag) {
        return Gs2Attributes.byChar(cbindFlag.getChar());
    }
}

