/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.client;

import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ClientFinalMessage;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ClientFirstMessage;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ScramFunctions;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ScramMechanism;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ServerFinalMessage;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.ServerFirstMessage;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.StringPreparation;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.exception.ScramParseException;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.exception.ScramServerErrorException;
import io.yellowbrick.shaded.org.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClientFinalProcessor {
    private final byte[] clientKey;
    private final byte[] storedKey;
    private final byte[] serverKey;
    private final ScramMechanism scramMechanism;
    private final ClientFirstMessage clientFirstMessage;
    private final ServerFirstMessage serverFirstMessage;
    private String authMessage;

    private ClientFinalProcessor(ScramMechanism scramMechanism, byte[] clientKey, byte[] storedKey, byte[] serverKey, ClientFirstMessage clientFirstMessage, ServerFirstMessage serverFirstMessage) {
        this.scramMechanism = scramMechanism;
        this.clientKey = Preconditions.checkNotNull(clientKey, "clientKey");
        this.storedKey = Preconditions.checkNotNull(storedKey, "storedKey");
        this.serverKey = Preconditions.checkNotNull(serverKey, "serverKey");
        this.clientFirstMessage = clientFirstMessage;
        this.serverFirstMessage = serverFirstMessage;
    }

    ClientFinalProcessor(ScramMechanism scramMechanism, byte[] clientKey, byte[] serverKey, ClientFirstMessage clientFirstMessage, ServerFirstMessage serverFirstMessage) {
        this(scramMechanism, clientKey, ScramFunctions.storedKey(scramMechanism, clientKey), serverKey, clientFirstMessage, serverFirstMessage);
    }

    ClientFinalProcessor(ScramMechanism scramMechanism, byte[] saltedPassword, ClientFirstMessage clientFirstMessage, ServerFirstMessage serverFirstMessage) {
        this(scramMechanism, ScramFunctions.clientKey(scramMechanism, saltedPassword), ScramFunctions.serverKey(scramMechanism, saltedPassword), clientFirstMessage, serverFirstMessage);
    }

    ClientFinalProcessor(ScramMechanism scramMechanism, StringPreparation stringPreparation, char[] password, byte[] salt, ClientFirstMessage clientFirstMessage, ServerFirstMessage serverFirstMessage) {
        this(scramMechanism, ScramFunctions.saltedPassword(scramMechanism, stringPreparation, password, salt, serverFirstMessage.getIterationCount()), clientFirstMessage, serverFirstMessage);
    }

    private void generateAndCacheAuthMessage(byte[] cbindData) {
        if (null == this.authMessage) {
            this.authMessage = ScramFunctions.authMessage(this.clientFirstMessage, this.serverFirstMessage, cbindData);
        }
    }

    @NotNull
    ClientFinalMessage clientFinalMessage(byte @Nullable [] cbindData) {
        this.generateAndCacheAuthMessage(cbindData);
        return new ClientFinalMessage(this.clientFirstMessage.getGs2Header(), cbindData, this.serverFirstMessage.getNonce(), ScramFunctions.clientProof(this.clientKey, ScramFunctions.clientSignature(this.scramMechanism, this.storedKey, this.authMessage)));
    }

    @NotNull
    ServerFinalMessage receiveServerFinalMessage(@NotNull String serverFinalMessage) throws ScramParseException, ScramServerErrorException, ScramInvalidServerSignatureException {
        Preconditions.checkNotEmpty(serverFinalMessage, "serverFinalMessage");
        ServerFinalMessage message = ServerFinalMessage.parseFrom(serverFinalMessage);
        if (message.isError()) {
            throw new ScramServerErrorException(message.getServerError());
        }
        if (!ScramFunctions.verifyServerSignature(this.scramMechanism, this.serverKey, this.authMessage, message.getVerifier())) {
            throw new ScramInvalidServerSignatureException("Invalid SCRAM server signature");
        }
        return message;
    }
}

