/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.largeobject;

import io.yellowbrick.shaded.org.postgresql.jdbc.ResourceLock;
import io.yellowbrick.shaded.org.postgresql.largeobject.LargeObject;
import io.yellowbrick.shaded.org.postgresql.util.ByteStreamWriter;
import io.yellowbrick.shaded.org.postgresql.util.GT;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BlobOutputStream
extends OutputStream {
    static final int DEFAULT_MAX_BUFFER_SIZE = 524288;
    private @Nullable LargeObject lo;
    private final ResourceLock lock = new ResourceLock();
    private byte @Nullable [] buf;
    private final @Positive int maxBufferSize;
    private int bufferPosition;

    public BlobOutputStream(LargeObject lo) {
        this(lo, 524288);
    }

    public BlobOutputStream(LargeObject lo, int bufferSize) {
        this.lo = lo;
        this.maxBufferSize = Integer.highestOneBit(Math.max(bufferSize, 1));
    }

    private byte[] growBuffer(int extraBytes) {
        byte[] buf = this.buf;
        if (buf != null && (buf.length == this.maxBufferSize || buf.length - this.bufferPosition >= extraBytes)) {
            return buf;
        }
        int newSize = Math.min(this.maxBufferSize, Integer.highestOneBit(this.bufferPosition + extraBytes) * 2);
        byte[] newBuffer = new byte[newSize];
        if (buf != null && this.bufferPosition != 0) {
            System.arraycopy(buf, 0, newBuffer, 0, this.bufferPosition);
        }
        this.buf = newBuffer;
        return newBuffer;
    }

    @Override
    public void write(int b) throws IOException {
        long loId = 0L;
        try (ResourceLock ignore = this.lock.obtain();){
            LargeObject lo = this.checkClosed();
            loId = lo.getLongOID();
            byte[] buf = this.growBuffer(16);
            if (this.bufferPosition >= buf.length) {
                lo.write(buf);
                this.bufferPosition = 0;
            }
            buf[this.bufferPosition++] = (byte)b;
        }
        catch (SQLException e) {
            throw new IOException(GT.tr("Can not write data to large object {0}, requested write length: {1}", loId, 1), e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long loId = 0L;
        try (ResourceLock ignore = this.lock.obtain();){
            int tailLength;
            LargeObject lo = this.checkClosed();
            loId = lo.getLongOID();
            byte[] buf = this.buf;
            int totalData = this.bufferPosition + len;
            int n = this.maxBufferSize >= 8192 ? totalData % 8192 : (tailLength = this.maxBufferSize >= 2048 ? totalData % 2048 : 0);
            if (totalData >= this.maxBufferSize) {
                int writeFromBuffer = Math.min(this.bufferPosition, totalData - tailLength);
                int writeFromB = Math.max(0, totalData - writeFromBuffer - tailLength);
                if (buf == null || this.bufferPosition <= 0) {
                    lo.write(b, off, writeFromB);
                } else {
                    if (writeFromB == 0) {
                        lo.write(buf, 0, writeFromBuffer);
                    } else {
                        lo.write(ByteStreamWriter.of(ByteBuffer.wrap(buf, 0, writeFromBuffer), ByteBuffer.wrap(b, off, writeFromB)));
                    }
                    if (writeFromBuffer >= this.bufferPosition) {
                        this.bufferPosition = 0;
                    } else {
                        System.arraycopy(buf, writeFromBuffer, buf, 0, this.bufferPosition - writeFromBuffer);
                        this.bufferPosition -= writeFromBuffer;
                    }
                }
                len -= writeFromB;
                off += writeFromB;
            }
            if (len > 0) {
                buf = this.growBuffer(len);
                System.arraycopy(b, off, buf, this.bufferPosition, len);
                this.bufferPosition += len;
            }
        }
        catch (SQLException e) {
            throw new IOException(GT.tr("Can not write data to large object {0}, requested write length: {1}", loId, len), e);
        }
    }

    @Override
    public void flush() throws IOException {
        long loId = 0L;
        try (ResourceLock ignore = this.lock.obtain();){
            LargeObject lo = this.checkClosed();
            loId = lo.getLongOID();
            byte[] buf = this.buf;
            if (buf != null && this.bufferPosition > 0) {
                lo.write(buf, 0, this.bufferPosition);
            }
            this.bufferPosition = 0;
        }
        catch (SQLException e) {
            throw new IOException(GT.tr("Can not flush large object {0}", loId), e);
        }
    }

    @Override
    public void close() throws IOException {
        long loId = 0L;
        try (ResourceLock ignore = this.lock.obtain();){
            LargeObject lo = this.lo;
            if (lo != null) {
                loId = lo.getLongOID();
                this.flush();
                lo.close();
                this.lo = null;
            }
        }
        catch (SQLException e) {
            throw new IOException(GT.tr("Can not close large object {0}", loId), e);
        }
    }

    private LargeObject checkClosed() throws IOException {
        if (this.lo == null) {
            throw new IOException("BlobOutputStream is closed");
        }
        return this.lo;
    }
}

