/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.shaded.org.postgresql.core.v3;

import io.yellowbrick.shaded.org.postgresql.PGProperty;
import io.yellowbrick.shaded.org.postgresql.util.GT;
import io.yellowbrick.shaded.org.postgresql.util.PSQLException;
import io.yellowbrick.shaded.org.postgresql.util.PSQLState;
import io.yellowbrick.shaded.org.postgresql.util.internal.Nullness;
import java.util.Properties;

enum ChannelBindingOption {
    DISABLE,
    PREFER,
    REQUIRE;


    public static ChannelBindingOption of(Properties info) throws PSQLException {
        String option;
        switch (option = Nullness.castNonNull(PGProperty.CHANNEL_BINDING.getOrDefault(info))) {
            case "disable": {
                return DISABLE;
            }
            case "prefer": {
                return PREFER;
            }
            case "require": {
                return REQUIRE;
            }
        }
        throw new PSQLException(GT.tr("Invalid channelBinding value: {0}", option), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }
}

