/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.jdbc.web;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;

public class DeviceCodeServer {
    private final HttpServer server;

    public DeviceCodeServer(int port, String userCode, String verificationUri) throws IOException {
        this.server = HttpServer.create(new InetSocketAddress("localhost", port), 0);
        this.server.createContext("/", new DeviceHandler(userCode, verificationUri));
        this.server.createContext("/favicon.ico", new FavIconHandler());
        this.server.createContext("/particles.js", new ParticlesJSHandler());
        this.server.setExecutor(null);
        this.server.start();
    }

    public void stop() {
        this.server.stop(0);
    }

    static class ParticlesJSHandler
    implements HttpHandler {
        private final byte[] particlesJSBytes;

        public ParticlesJSHandler() throws IOException {
            try (InputStream is = this.getClass().getResourceAsStream("particles.js");){
                if (is == null) {
                    throw new IOException("particles.js not found in resources");
                }
                this.particlesJSBytes = is.readAllBytes();
            }
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            exchange.getResponseHeaders().set("Content-Type", "application/javascript");
            exchange.sendResponseHeaders(200, this.particlesJSBytes.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(this.particlesJSBytes);
            }
        }
    }

    static class FavIconHandler
    implements HttpHandler {
        private final byte[] faviconBytes;

        public FavIconHandler() throws IOException {
            try (InputStream is = this.getClass().getResourceAsStream("favicon.ico");){
                if (is == null) {
                    throw new IOException("favicon.ico not found in resources");
                }
                this.faviconBytes = is.readAllBytes();
            }
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            exchange.getResponseHeaders().set("Content-Type", "image/vnd.microsoft.icon");
            exchange.sendResponseHeaders(200, this.faviconBytes.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(this.faviconBytes);
            }
        }
    }

    static class DeviceHandler
    implements HttpHandler {
        private final String userCode;
        private final String verificationUri;

        public DeviceHandler(String userCode, String verificationUri) {
            this.userCode = userCode;
            this.verificationUri = verificationUri;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String response = this.loadTemplate().replace("{{code}}", this.userCode).replace("{{url}}", this.verificationUri);
            exchange.getResponseHeaders().add("Content-Type", "text/html; charset=UTF-8");
            exchange.sendResponseHeaders(200, response.getBytes().length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(response.getBytes());
            }
        }

        private String loadTemplate() throws IOException {
            try (InputStream in = this.getClass().getResourceAsStream("device-login.html");){
                if (in == null) {
                    throw new IOException("device-login.html not found");
                }
                String string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                return string;
            }
        }
    }
}

