/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.jdbc.dialog;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Supplier;

public final class FrameFinder {
    private static volatile Supplier<Frame> supplier;

    private FrameFinder() {
    }

    public static void setSupplier(Supplier<Frame> s) {
        supplier = s;
    }

    public static Optional<Frame> findTopLevelFrame() {
        try {
            Frame owner;
            Frame f;
            if (supplier != null && FrameFinder.isUsable(f = FrameFinder.safeGet(supplier))) {
                return Optional.of(f);
            }
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window w = kfm.getActiveWindow();
            if (w == null) {
                w = kfm.getFocusedWindow();
            }
            if (FrameFinder.isUsable(owner = FrameFinder.windowToFrame(w))) {
                return Optional.of(owner);
            }
            Optional<Frame> fr = Arrays.stream(Frame.getFrames()).filter(FrameFinder::isVisibleNotIconified).min(Comparator.comparingInt(FrameFinder::zOrderHint));
            if (fr.isPresent()) {
                return fr;
            }
            for (Window win : Window.getWindows()) {
                Frame f2 = FrameFinder.windowToFrame(win);
                if (!FrameFinder.isUsable(f2)) continue;
                return Optional.of(f2);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static <T> T safeGet(Supplier<T> s) {
        try {
            return s.get();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Frame windowToFrame(Window w) {
        while (w != null && !(w instanceof Frame)) {
            w = w.getOwner();
        }
        return (Frame)w;
    }

    private static boolean isUsable(Frame f) {
        return f != null && f.isDisplayable() && FrameFinder.isVisibleNotIconified(f);
    }

    private static boolean isVisibleNotIconified(Frame f) {
        return f != null && f.isVisible() && (f.getExtendedState() & 1) == 0;
    }

    private static int zOrderHint(Frame f) {
        int score = 0;
        if (f.isFocused()) {
            score -= 10;
        }
        if (f.isActive()) {
            score -= 5;
        }
        if (f.isAlwaysOnTop()) {
            score -= 3;
        }
        Dimension d = f.getSize();
        int areaPenalty = 10000000 - Math.max(1, d.width * d.height);
        return score += areaPenalty;
    }
}

