/*
 * Decompiled with CFR 0.152.
 */
package io.yellowbrick.jdbc;

import java.util.Properties;

public class DriverConfiguration {
    public final String clientId;
    public final String clientSecret;
    public final String issuer;
    public final String loginHint;
    public final String scopes;
    public final String audience;
    public final TokenType tokenType;
    public final TokenCacheOption tokenCache;
    public final InteractionMode interactionMode;
    public final boolean quiet;
    public final String cacertPath;
    public final boolean disableTrust;

    public DriverConfiguration(Properties info) {
        this.clientId = info.getProperty("oauth2ClientId");
        this.clientSecret = info.getProperty("oauth2ClientSecret");
        this.issuer = info.getProperty("oauth2Issuer");
        this.loginHint = info.getProperty("oauth2LoginHint");
        this.audience = info.getProperty("oauth2Audience");
        this.scopes = info.getProperty("oauth2Scopes", "openid email profile offline_access");
        this.tokenType = TokenType.fromString(info.getProperty("oauth2TokenType", "id-token"));
        this.tokenCache = TokenCacheOption.fromString(info.getProperty("oauth2TokenCache", "memory"));
        this.interactionMode = InteractionMode.fromString(info.getProperty("oauth2InteractionMode", "browser"));
        this.quiet = Boolean.parseBoolean(info.getProperty("oauth2Quiet", "false"));
        this.cacertPath = info.getProperty("oauth2CAcertPath");
        this.disableTrust = Boolean.parseBoolean(info.getProperty("oauth2SSLDisableTrust", "false"));
    }

    public static enum InteractionMode {
        DIALOG,
        BROWSER,
        CONSOLE;


        public static InteractionMode fromString(String value) {
            if (value == null) {
                return BROWSER;
            }
            switch (value.toLowerCase()) {
                case "dialog": {
                    return DIALOG;
                }
                case "browser": {
                    return BROWSER;
                }
                case "console": {
                    return CONSOLE;
                }
            }
            throw new IllegalArgumentException("Invalid interaction mode option: " + value);
        }
    }

    public static enum TokenType {
        ID_TOKEN("id-token"),
        ACCESS_TOKEN("access-token");

        private final String value;

        private TokenType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static TokenType fromString(String value) {
            if (value == null) {
                return ID_TOKEN;
            }
            for (TokenType t : TokenType.values()) {
                if (!t.value.equalsIgnoreCase(value)) continue;
                return t;
            }
            throw new IllegalArgumentException("Invalid token type: " + value);
        }
    }

    public static enum TokenCacheOption {
        MEMORY,
        FILE,
        DISABLED;


        public static TokenCacheOption fromString(String value) {
            if (value == null) {
                return MEMORY;
            }
            switch (value.toLowerCase()) {
                case "memory": {
                    return MEMORY;
                }
                case "file": {
                    return FILE;
                }
                case "disabled": {
                    return DISABLED;
                }
            }
            throw new IllegalArgumentException("Invalid token cache option: " + value);
        }
    }
}

