/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.kafka.ui.views;

import com.dbeaver.db.kafka.ui.KFMessages;
import com.dbeaver.db.kafka.ui.KFUIActivator;
import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.utils.CommonUtils;

public class KFConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static ImageDescriptor logoImage = KFUIActivator.getImageDescriptor("icons/kafka_logo.png");
    private boolean activated;
    private Text nodeAddressText;
    private Text nodePortText;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite group = UIUtils.createComposite((Composite)composite, (int)1);
        group.setLayoutData((Object)new GridData(1808));
        this.createGeneralTab(group);
        this.createDriverPanel(group);
        this.setControl((Control)group);
    }

    private Composite createGeneralTab(Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        Composite settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        settingsGroup.setLayoutData((Object)gd);
        new Label(settingsGroup, 0).setText(KFMessages.connection_page_text_kafka_support);
        Group serverGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)KFMessages.connection_page_control_group_server, (int)4, (int)768, (int)-1);
        this.nodeAddressText = UIUtils.createLabelText((Composite)serverGroup, (String)"Node", (String)"", (int)2048);
        this.nodeAddressText.setLayoutData((Object)new GridData(768));
        this.nodeAddressText.addModifyListener(textListener);
        this.nodeAddressText.setText("localhost");
        this.nodePortText = UIUtils.createLabelText((Composite)serverGroup, (String)"Port", (String)"");
        gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Font)this.nodePortText.getFont()) * 10;
        this.nodePortText.setLayoutData((Object)gd);
        this.nodePortText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.nodePortText.addModifyListener(textListener);
        UIUtils.createEmptyLabel((Composite)serverGroup, (int)2, (int)1);
        this.createAuthPanel(settingsGroup, 1);
        return settingsGroup;
    }

    public boolean isComplete() {
        return true;
    }

    public void loadSettings() {
        String portNumber;
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        String hostName = connectionInfo.getHostName();
        if (CommonUtils.isEmpty((String)hostName)) {
            hostName = "localhost";
        }
        if (CommonUtils.isEmpty((String)(portNumber = connectionInfo.getHostPort()))) {
            portNumber = String.valueOf(8088);
        }
        this.nodeAddressText.setText(hostName);
        this.nodePortText.setText(portNumber);
        super.loadSettings();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setHostName(this.nodeAddressText.getText());
        connectionInfo.setHostPort(this.nodePortText.getText());
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[0];
    }
}

