/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.IdentityType;
import com.azure.resourcemanager.postgresqlflexibleserver.models.UserIdentity;
import java.io.IOException;
import java.util.Map;

public final class UserAssignedIdentity
implements JsonSerializable<UserAssignedIdentity> {
    private Map<String, UserIdentity> userAssignedIdentities;
    private IdentityType type;
    private String tenantId;
    private static final ClientLogger LOGGER = new ClientLogger(UserAssignedIdentity.class);

    public Map<String, UserIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public UserAssignedIdentity withUserAssignedIdentities(Map<String, UserIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public IdentityType type() {
        return this.type;
    }

    public UserAssignedIdentity withType(IdentityType type) {
        this.type = type;
        return this;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model UserAssignedIdentity"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static UserAssignedIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (UserAssignedIdentity)jsonReader.readObject(reader -> {
            UserAssignedIdentity deserializedUserAssignedIdentity = new UserAssignedIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedUserAssignedIdentity.type = IdentityType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedUserAssignedIdentity.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> UserIdentity.fromJson(reader1));
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedUserAssignedIdentity.tenantId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserAssignedIdentity;
        });
    }
}

