/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerThreatProtectionSettingsModelInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerThreatProtectionSettingsModel;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ThreatProtectionName;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ThreatProtectionState;
import java.time.OffsetDateTime;

public final class ServerThreatProtectionSettingsModelImpl
implements ServerThreatProtectionSettingsModel,
ServerThreatProtectionSettingsModel.Definition,
ServerThreatProtectionSettingsModel.Update {
    private ServerThreatProtectionSettingsModelInner innerObject;
    private final PostgreSqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private ThreatProtectionName threatProtectionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ThreatProtectionState state() {
        return this.innerModel().state();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ServerThreatProtectionSettingsModelInner innerModel() {
        return this.innerObject;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ServerThreatProtectionSettingsModelImpl withExistingFlexibleServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    @Override
    public ServerThreatProtectionSettingsModel create() {
        this.innerObject = this.serviceManager.serviceClient().getServerThreatProtectionSettings().createOrUpdate(this.resourceGroupName, this.serverName, this.threatProtectionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ServerThreatProtectionSettingsModel create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServerThreatProtectionSettings().createOrUpdate(this.resourceGroupName, this.serverName, this.threatProtectionName, this.innerModel(), context);
        return this;
    }

    ServerThreatProtectionSettingsModelImpl(ThreatProtectionName name, PostgreSqlManager serviceManager) {
        this.innerObject = new ServerThreatProtectionSettingsModelInner();
        this.serviceManager = serviceManager;
        this.threatProtectionName = name;
    }

    @Override
    public ServerThreatProtectionSettingsModelImpl update() {
        return this;
    }

    @Override
    public ServerThreatProtectionSettingsModel apply() {
        this.innerObject = this.serviceManager.serviceClient().getServerThreatProtectionSettings().createOrUpdate(this.resourceGroupName, this.serverName, this.threatProtectionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ServerThreatProtectionSettingsModel apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServerThreatProtectionSettings().createOrUpdate(this.resourceGroupName, this.serverName, this.threatProtectionName, this.innerModel(), context);
        return this;
    }

    ServerThreatProtectionSettingsModelImpl(ServerThreatProtectionSettingsModelInner innerObject, PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "flexibleServers");
        this.threatProtectionName = ThreatProtectionName.fromString(ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "advancedThreatProtectionSettings"));
    }

    @Override
    public ServerThreatProtectionSettingsModel refresh() {
        this.innerObject = (ServerThreatProtectionSettingsModelInner)((Object)this.serviceManager.serviceClient().getServerThreatProtectionSettings().getWithResponse(this.resourceGroupName, this.serverName, this.threatProtectionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ServerThreatProtectionSettingsModel refresh(Context context) {
        this.innerObject = (ServerThreatProtectionSettingsModelInner)((Object)this.serviceManager.serviceClient().getServerThreatProtectionSettings().getWithResponse(this.resourceGroupName, this.serverName, this.threatProtectionName, context).getValue());
        return this;
    }

    @Override
    public ServerThreatProtectionSettingsModelImpl withState(ThreatProtectionState state) {
        this.innerModel().withState(state);
        return this;
    }
}

