/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.LocationBasedCapabilitiesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.FlexibleServerCapabilityInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.FlexibleServerCapabilityImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.FlexibleServerCapability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LocationBasedCapabilities;

public final class LocationBasedCapabilitiesImpl
implements LocationBasedCapabilities {
    private static final ClientLogger LOGGER = new ClientLogger(LocationBasedCapabilitiesImpl.class);
    private final LocationBasedCapabilitiesClient innerClient;
    private final PostgreSqlManager serviceManager;

    public LocationBasedCapabilitiesImpl(LocationBasedCapabilitiesClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<FlexibleServerCapability> execute(String locationName) {
        PagedIterable<FlexibleServerCapabilityInner> inner = this.serviceClient().execute(locationName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FlexibleServerCapabilityImpl((FlexibleServerCapabilityInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<FlexibleServerCapability> execute(String locationName, Context context) {
        PagedIterable<FlexibleServerCapabilityInner> inner = this.serviceClient().execute(locationName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FlexibleServerCapabilityImpl((FlexibleServerCapabilityInner)inner1, this.manager()));
    }

    private LocationBasedCapabilitiesClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

