/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AuthConfig;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Backup;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Network;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Replica;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerState;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerVersion;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Storage;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ServerProperties
implements JsonSerializable<ServerProperties> {
    private String administratorLogin;
    private String administratorLoginPassword;
    private ServerVersion version;
    private String minorVersion;
    private ServerState state;
    private String fullyQualifiedDomainName;
    private Storage storage;
    private AuthConfig authConfig;
    private DataEncryption dataEncryption;
    private Backup backup;
    private Network network;
    private HighAvailability highAvailability;
    private MaintenanceWindow maintenanceWindow;
    private String sourceServerResourceId;
    private OffsetDateTime pointInTimeUtc;
    private String availabilityZone;
    private ReplicationRole replicationRole;
    private Integer replicaCapacity;
    private Replica replica;
    private CreateMode createMode;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ServerProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ServerProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public ServerVersion version() {
        return this.version;
    }

    public ServerProperties withVersion(ServerVersion version) {
        this.version = version;
        return this;
    }

    public String minorVersion() {
        return this.minorVersion;
    }

    public ServerState state() {
        return this.state;
    }

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public Storage storage() {
        return this.storage;
    }

    public ServerProperties withStorage(Storage storage) {
        this.storage = storage;
        return this;
    }

    public AuthConfig authConfig() {
        return this.authConfig;
    }

    public ServerProperties withAuthConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    public DataEncryption dataEncryption() {
        return this.dataEncryption;
    }

    public ServerProperties withDataEncryption(DataEncryption dataEncryption) {
        this.dataEncryption = dataEncryption;
        return this;
    }

    public Backup backup() {
        return this.backup;
    }

    public ServerProperties withBackup(Backup backup) {
        this.backup = backup;
        return this;
    }

    public Network network() {
        return this.network;
    }

    public ServerProperties withNetwork(Network network) {
        this.network = network;
        return this;
    }

    public HighAvailability highAvailability() {
        return this.highAvailability;
    }

    public ServerProperties withHighAvailability(HighAvailability highAvailability) {
        this.highAvailability = highAvailability;
        return this;
    }

    public MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public ServerProperties withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
        return this;
    }

    public String sourceServerResourceId() {
        return this.sourceServerResourceId;
    }

    public ServerProperties withSourceServerResourceId(String sourceServerResourceId) {
        this.sourceServerResourceId = sourceServerResourceId;
        return this;
    }

    public OffsetDateTime pointInTimeUtc() {
        return this.pointInTimeUtc;
    }

    public ServerProperties withPointInTimeUtc(OffsetDateTime pointInTimeUtc) {
        this.pointInTimeUtc = pointInTimeUtc;
        return this;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public ServerProperties withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public ReplicationRole replicationRole() {
        return this.replicationRole;
    }

    public ServerProperties withReplicationRole(ReplicationRole replicationRole) {
        this.replicationRole = replicationRole;
        return this;
    }

    public Integer replicaCapacity() {
        return this.replicaCapacity;
    }

    public Replica replica() {
        return this.replica;
    }

    public ServerProperties withReplica(Replica replica) {
        this.replica = replica;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public ServerProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public void validate() {
        if (this.storage() != null) {
            this.storage().validate();
        }
        if (this.authConfig() != null) {
            this.authConfig().validate();
        }
        if (this.dataEncryption() != null) {
            this.dataEncryption().validate();
        }
        if (this.backup() != null) {
            this.backup().validate();
        }
        if (this.network() != null) {
            this.network().validate();
        }
        if (this.highAvailability() != null) {
            this.highAvailability().validate();
        }
        if (this.maintenanceWindow() != null) {
            this.maintenanceWindow().validate();
        }
        if (this.replica() != null) {
            this.replica().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("version", this.version == null ? null : this.version.toString());
        jsonWriter.writeJsonField("storage", (JsonSerializable)this.storage);
        jsonWriter.writeJsonField("authConfig", (JsonSerializable)this.authConfig);
        jsonWriter.writeJsonField("dataEncryption", (JsonSerializable)this.dataEncryption);
        jsonWriter.writeJsonField("backup", (JsonSerializable)this.backup);
        jsonWriter.writeJsonField("network", (JsonSerializable)this.network);
        jsonWriter.writeJsonField("highAvailability", (JsonSerializable)this.highAvailability);
        jsonWriter.writeJsonField("maintenanceWindow", (JsonSerializable)this.maintenanceWindow);
        jsonWriter.writeStringField("sourceServerResourceId", this.sourceServerResourceId);
        jsonWriter.writeStringField("pointInTimeUTC", this.pointInTimeUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.pointInTimeUtc));
        jsonWriter.writeStringField("availabilityZone", this.availabilityZone);
        jsonWriter.writeStringField("replicationRole", this.replicationRole == null ? null : this.replicationRole.toString());
        jsonWriter.writeJsonField("replica", (JsonSerializable)this.replica);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static ServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServerProperties)jsonReader.readObject(reader -> {
            ServerProperties deserializedServerProperties = new ServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorLogin".equals(fieldName)) {
                    deserializedServerProperties.administratorLogin = reader.getString();
                    continue;
                }
                if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedServerProperties.administratorLoginPassword = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedServerProperties.version = ServerVersion.fromString(reader.getString());
                    continue;
                }
                if ("minorVersion".equals(fieldName)) {
                    deserializedServerProperties.minorVersion = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedServerProperties.state = ServerState.fromString(reader.getString());
                    continue;
                }
                if ("fullyQualifiedDomainName".equals(fieldName)) {
                    deserializedServerProperties.fullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("storage".equals(fieldName)) {
                    deserializedServerProperties.storage = Storage.fromJson(reader);
                    continue;
                }
                if ("authConfig".equals(fieldName)) {
                    deserializedServerProperties.authConfig = AuthConfig.fromJson(reader);
                    continue;
                }
                if ("dataEncryption".equals(fieldName)) {
                    deserializedServerProperties.dataEncryption = DataEncryption.fromJson(reader);
                    continue;
                }
                if ("backup".equals(fieldName)) {
                    deserializedServerProperties.backup = Backup.fromJson(reader);
                    continue;
                }
                if ("network".equals(fieldName)) {
                    deserializedServerProperties.network = Network.fromJson(reader);
                    continue;
                }
                if ("highAvailability".equals(fieldName)) {
                    deserializedServerProperties.highAvailability = HighAvailability.fromJson(reader);
                    continue;
                }
                if ("maintenanceWindow".equals(fieldName)) {
                    deserializedServerProperties.maintenanceWindow = MaintenanceWindow.fromJson(reader);
                    continue;
                }
                if ("sourceServerResourceId".equals(fieldName)) {
                    deserializedServerProperties.sourceServerResourceId = reader.getString();
                    continue;
                }
                if ("pointInTimeUTC".equals(fieldName)) {
                    deserializedServerProperties.pointInTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("availabilityZone".equals(fieldName)) {
                    deserializedServerProperties.availabilityZone = reader.getString();
                    continue;
                }
                if ("replicationRole".equals(fieldName)) {
                    deserializedServerProperties.replicationRole = ReplicationRole.fromString(reader.getString());
                    continue;
                }
                if ("replicaCapacity".equals(fieldName)) {
                    deserializedServerProperties.replicaCapacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("replica".equals(fieldName)) {
                    deserializedServerProperties.replica = Replica.fromJson(reader);
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedServerProperties.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedServerProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerProperties;
        });
    }
}

