/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ExecutionStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class LtrBackupOperationResponseProperties
implements JsonSerializable<LtrBackupOperationResponseProperties> {
    private Long datasourceSizeInBytes;
    private Long dataTransferredInBytes;
    private String backupName;
    private String backupMetadata;
    private ExecutionStatus status;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private Double percentComplete;
    private String errorCode;
    private String errorMessage;
    private static final ClientLogger LOGGER = new ClientLogger(LtrBackupOperationResponseProperties.class);

    public Long datasourceSizeInBytes() {
        return this.datasourceSizeInBytes;
    }

    public LtrBackupOperationResponseProperties withDatasourceSizeInBytes(Long datasourceSizeInBytes) {
        this.datasourceSizeInBytes = datasourceSizeInBytes;
        return this;
    }

    public Long dataTransferredInBytes() {
        return this.dataTransferredInBytes;
    }

    public LtrBackupOperationResponseProperties withDataTransferredInBytes(Long dataTransferredInBytes) {
        this.dataTransferredInBytes = dataTransferredInBytes;
        return this;
    }

    public String backupName() {
        return this.backupName;
    }

    public LtrBackupOperationResponseProperties withBackupName(String backupName) {
        this.backupName = backupName;
        return this;
    }

    public String backupMetadata() {
        return this.backupMetadata;
    }

    public LtrBackupOperationResponseProperties withBackupMetadata(String backupMetadata) {
        this.backupMetadata = backupMetadata;
        return this;
    }

    public ExecutionStatus status() {
        return this.status;
    }

    public LtrBackupOperationResponseProperties withStatus(ExecutionStatus status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public LtrBackupOperationResponseProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public LtrBackupOperationResponseProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public Double percentComplete() {
        return this.percentComplete;
    }

    public LtrBackupOperationResponseProperties withPercentComplete(Double percentComplete) {
        this.percentComplete = percentComplete;
        return this;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public void validate() {
        if (this.status() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property status in model LtrBackupOperationResponseProperties"));
        }
        if (this.startTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property startTime in model LtrBackupOperationResponseProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeNumberField("datasourceSizeInBytes", (Number)this.datasourceSizeInBytes);
        jsonWriter.writeNumberField("dataTransferredInBytes", (Number)this.dataTransferredInBytes);
        jsonWriter.writeStringField("backupName", this.backupName);
        jsonWriter.writeStringField("backupMetadata", this.backupMetadata);
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeNumberField("percentComplete", (Number)this.percentComplete);
        return jsonWriter.writeEndObject();
    }

    public static LtrBackupOperationResponseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LtrBackupOperationResponseProperties)jsonReader.readObject(reader -> {
            LtrBackupOperationResponseProperties deserializedLtrBackupOperationResponseProperties = new LtrBackupOperationResponseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.status = ExecutionStatus.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("datasourceSizeInBytes".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.datasourceSizeInBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("dataTransferredInBytes".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.dataTransferredInBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("backupName".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.backupName = reader.getString();
                    continue;
                }
                if ("backupMetadata".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.backupMetadata = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.percentComplete = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("errorCode".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.errorCode = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.errorMessage = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLtrBackupOperationResponseProperties;
        });
    }
}

