/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.security;

import com.dbeaver.ui.security.PasswordProvidersInfo;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.security.storage.PasswordProviderSelector;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.storage.friends.PasswordProviderDescription;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.registry.settings.GlobalSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import org.osgi.service.prefs.BackingStoreException;

public class PasswordProviderUtils {
    public static final String DBEAVER_MASTER_PASSWORD_PROVIDER_ID = "com.dbeaver.app.advanced.dbeaverpasswordprovider";
    public static final String PREFERRED_PASSWORD_PROVIDER_PROP = "preferred-password-provider";
    public static final String ECLIPSE_SECURITY_PLUGIN = "org.eclipse.equinox.security";
    private static final Log log = Log.getLog(PasswordProviderUtils.class);

    public static void setPreferredProvider(@NotNull PasswordProviderDescription selectedProvider) {
        List allProviders = InternalExchangeUtils.passwordProvidersFind();
        StringJoiner disabledModules = new StringJoiner(",");
        for (PasswordProviderDescription item : allProviders) {
            if (item.getId().equals(selectedProvider.getId())) continue;
            disabledModules.add(item.getId());
        }
        PasswordProviderSelector.getInstance().clearCaches();
        IEclipsePreferences node = PasswordProviderUtils.getSecurityPreferences();
        node.put("org.eclipse.equinox.security.preferences.disabledProviders", disabledModules.toString());
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            log.error((Object)"Password providers config save error", (Throwable)e);
        }
        GlobalSettings globalSettings = GlobalSettings.getInstance();
        globalSettings.setGlobalProperty(PREFERRED_PASSWORD_PROVIDER_PROP, selectedProvider.getId());
    }

    @Nullable
    public static IEclipsePreferences getSecurityPreferences() {
        return ConfigurationScope.INSTANCE.getNode(ECLIPSE_SECURITY_PLUGIN);
    }

    @NotNull
    public static Set<String> getDisabledModules() {
        String savedValue = PasswordProviderUtils.getSecurityPreferences().get("org.eclipse.equinox.security.preferences.disabledProviders", "");
        return Set.of(savedValue.split(","));
    }

    @NotNull
    public static PasswordProvidersInfo loadPasswordProviderSettings() {
        Set<String> disabledModules = PasswordProviderUtils.getDisabledModules();
        List providers = InternalExchangeUtils.passwordProvidersFind();
        int selectedProviderPriority = Integer.MIN_VALUE;
        PasswordProviderDescription[] passwordProviders = new PasswordProviderDescription[providers.size()];
        PasswordProviderDescription selectedProvider = null;
        int i = 0;
        while (i < providers.size()) {
            PasswordProviderDescription provider;
            passwordProviders[i] = provider = (PasswordProviderDescription)providers.get(i);
            if (!disabledModules.contains(provider.getId()) && provider.getPriority() > selectedProviderPriority) {
                selectedProviderPriority = provider.getPriority();
                selectedProvider = provider;
            }
            ++i;
        }
        return new PasswordProvidersInfo(passwordProviders, selectedProvider);
    }

    public static void deleteDefaultStorage() {
        URL location = InternalExchangeUtils.defaultStorageLocation();
        if (location == null) {
            return;
        }
        ISecurePreferences defaultStorage = SecurePreferencesFactory.getDefault();
        defaultStorage.clear();
        defaultStorage.removeNode();
        InternalExchangeUtils.defaultStorageDelete();
        try {
            SecurePreferencesFactory.getDefault().putBoolean("passwordWasCleared", true, false);
        }
        catch (StorageException e) {
            log.error((Object)"Error saving password was cleared flag", (Throwable)e);
        }
        PlatformUI.getWorkbench().restart();
    }

    public static void resetPasswordProviders() {
        InternalExchangeUtils.passwordProvidersReset();
    }

    public static boolean hasHints(@Nullable PasswordProviderDescription selectedPasswordProvider) {
        if (selectedPasswordProvider == null) {
            return false;
        }
        String moduleID = selectedPasswordProvider.getId();
        ISecurePreferences rootNode = SecurePreferencesFactory.getDefault();
        String[] questions = InternalExchangeUtils.getPasswordRecoveryQuestions((ISecurePreferences)rootNode, (String)moduleID);
        return questions.length > 0;
    }

    public static void initializePasswordProviders() {
        if (DBWorkbench.isDistributed()) {
            return;
        }
        GlobalSettings globalSettings = GlobalSettings.getInstance();
        String prefProviderId = globalSettings.getGlobalProperty(PREFERRED_PASSWORD_PROVIDER_PROP);
        PasswordProvidersInfo passwordProvidersInfo = PasswordProviderUtils.loadPasswordProviderSettings();
        boolean forceUpdate = false;
        if (CommonUtils.isEmpty((String)prefProviderId)) {
            forceUpdate = true;
            if (passwordProvidersInfo.selectedProvider() != null) {
                prefProviderId = passwordProvidersInfo.selectedProvider().getId();
            } else {
                prefProviderId = DBEAVER_MASTER_PASSWORD_PROVIDER_ID;
                log.debug((Object)("No preferred password provider. Use default to '" + prefProviderId + "'"));
            }
        }
        if (forceUpdate || passwordProvidersInfo.selectedProvider() == null || !CommonUtils.equalObjects((Object)prefProviderId, (Object)passwordProvidersInfo.selectedProvider().getId())) {
            String providerId = prefProviderId;
            PasswordProviderDescription prefProvider = Arrays.stream(passwordProvidersInfo.providers()).filter(pp -> pp.getId().equals(providerId)).findFirst().orElse(null);
            if (prefProvider != null) {
                log.debug((Object)("Switching preferred password provider to '" + prefProviderId + "'"));
                PasswordProviderUtils.setPreferredProvider(prefProvider);
                globalSettings.setGlobalProperty(PREFERRED_PASSWORD_PROVIDER_PROP, providerId);
            } else {
                log.error((Object)("Password provider '" + prefProviderId + "' not found"));
            }
        }
    }
}

