/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.internal.preferences.secrets;

import com.dbeaver.model.datasource.parameters.DBPParametersConfiguration;
import com.dbeaver.model.datasource.parameters.registry.DBPParametersProviderDescriptor;
import com.dbeaver.model.datasource.parameters.registry.DBPParametersProviderRegistry;
import com.dbeaver.ui.internal.preferences.secrets.EditConfigurationDialog;
import com.dbeaver.ui.internal.preferences.secrets.ProviderSelectDialog;
import java.util.UUID;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;

public class SecretParametersProvidersPrefPage
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "com.dbeaver.preferences.secretManagers";
    private static final Log log = Log.getLog(SecretParametersProvidersPrefPage.class);
    private Table configsTable;
    private IAdaptable element;
    private DBPParametersConfiguration selectedConfiguration;
    private ToolItem editButton;
    private ToolItem deleteButton;
    private final boolean enabledSecretManagement = DBWorkbench.getPlatform().getWorkspace().isEnabledSecretProviders();

    public SecretParametersProvidersPrefPage() {
        this.noDefaultAndApplyButton();
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite group = UIUtils.createComposite((Composite)parent, (int)2);
        if (!this.enabledSecretManagement) {
            return UIUtils.createLabel((Composite)parent, (String)UIMessages.preference_page_disabled_secret_management);
        }
        this.configsTable = new Table(group, 2052);
        this.configsTable.setLayoutData((Object)new GridData(1808));
        UIUtils.createTableColumn((Table)this.configsTable, (int)16384, (String)"Configuration");
        UIUtils.createTableColumn((Table)this.configsTable, (int)16384, (String)"Provider");
        this.configsTable.setHeaderVisible(true);
        this.configsTable.setLayoutData((Object)new GridData(1808));
        this.configsTable.addMouseListener(MouseListener.mouseDoubleClickAdapter(e -> this.editSelectedConfiguration()));
        ToolBar toolbar = new ToolBar(group, 0x800200);
        toolbar.setLayoutData((Object)new GridData(2));
        UIUtils.createToolItem((ToolBar)toolbar, (String)"Add", (DBPImage)UIIcon.ADD, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.createNewConfiguration()));
        this.editButton = UIUtils.createToolItem((ToolBar)toolbar, (String)"Edit", (DBPImage)UIIcon.EDIT, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.editSelectedConfiguration()));
        this.editButton.setEnabled(false);
        this.deleteButton = UIUtils.createToolItem((ToolBar)toolbar, (String)"Delete", (DBPImage)UIIcon.DELETE, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.deleteSelectedConfiguration()));
        this.deleteButton.setEnabled(false);
        this.configsTable.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> this.updateButtons()));
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.configsTable, (boolean)true));
        this.performDefaults();
        return group;
    }

    private void deleteSelectedConfiguration() {
        if (UIUtils.confirmAction((Shell)this.getShell(), (String)"Delete configuration", (String)("Are you sure you want to delete secret parameters provider configuration '" + this.selectedConfiguration.getConfigurationName() + "'?"))) {
            try {
                DBPParametersProviderRegistry.getInstance().deleteConfiguration(this.selectedConfiguration.getConfigurationId());
                TableItem item = this.configsTable.getItem(this.configsTable.getSelectionIndex());
                item.dispose();
                this.selectedConfiguration = null;
                this.updateButtons();
            }
            catch (DBException ex) {
                DBWorkbench.getPlatformUI().showError("Delete secret configuration", "Error deleting configuration", (Throwable)ex);
            }
        }
    }

    private void createNewConfiguration() {
        ProviderSelectDialog selectDialog = new ProviderSelectDialog(this.getShell());
        if (selectDialog.open() == 0) {
            DBPParametersProviderDescriptor provider = selectDialog.getSelectedProvider();
            if (provider == null) {
                return;
            }
            DBPParametersConfiguration newCfg = provider.getInstance().createDefaultConfiguration();
            newCfg.setConfigurationId(UUID.randomUUID().toString());
            EditConfigurationDialog cfgDialog = new EditConfigurationDialog(this.getShell(), provider, newCfg);
            if (cfgDialog.open() == 0) {
                this.addConfigurationItem(newCfg);
            }
        }
    }

    private void editSelectedConfiguration() {
        EditConfigurationDialog cfgDialog;
        DBPParametersProviderDescriptor provider = this.getSelectedConfigurationProvider();
        if (provider != null && (cfgDialog = new EditConfigurationDialog(this.getShell(), provider, this.selectedConfiguration)).open() == 0) {
            this.configsTable.getItem(this.configsTable.getSelectionIndex()).setText(this.selectedConfiguration.getConfigurationName());
        }
    }

    private void updateButtons() {
        int selectionIndex = this.configsTable.getSelectionIndex();
        this.selectedConfiguration = selectionIndex < 0 ? null : (DBPParametersConfiguration)this.configsTable.getItem(selectionIndex).getData();
        this.editButton.setEnabled(this.selectedConfiguration != null);
        this.deleteButton.setEnabled(this.selectedConfiguration != null);
    }

    public DBPParametersConfiguration getSelectedConfiguration() {
        return this.selectedConfiguration;
    }

    private DBPParametersProviderDescriptor getSelectedConfigurationProvider() {
        if (this.selectedConfiguration == null) {
            return null;
        }
        try {
            return DBPParametersProviderRegistry.getInstance().getProviderDescriptor(this.selectedConfiguration.getProviderId());
        }
        catch (DBException e) {
            log.error((Object)e);
            return null;
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        DBPParametersProviderRegistry registry = DBPParametersProviderRegistry.getInstance();
        for (DBPParametersConfiguration config : registry.getAllConfigurations(true)) {
            this.addConfigurationItem(config);
        }
    }

    private void addConfigurationItem(DBPParametersConfiguration config) {
        TableItem item = new TableItem(this.configsTable, 0);
        item.setData((Object)config);
        item.setText(0, config.getConfigurationName());
        try {
            DBPParametersProviderDescriptor providerDescriptor = DBPParametersProviderRegistry.getInstance().getProviderDescriptor(config.getProviderId());
            item.setText(1, providerDescriptor.getLabel());
        }
        catch (DBException e) {
            item.setText(1, e.getMessage());
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean performOk() {
        return true;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    protected boolean hasAccessToPage() {
        return DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("admin");
    }
}

