/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.internal.panel;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.trace.DBCTrace;
import org.jkiss.dbeaver.model.exec.trace.DBCTraceDynamic;
import org.jkiss.dbeaver.model.exec.trace.DBCTraceProperty;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.UIWidgets;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.panel.ResultSetPanelBase;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;

public class ResultDetailsPanel
extends ResultSetPanelBase {
    public static final String PANEL_ID = "pannel.result.details";
    private IResultSetPresentation presentation;
    private TracePropertyTable traceTable;

    public void contributeActions(IContributionManager manager) {
    }

    public Control createContents(IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        this.traceTable = new TracePropertyTable(composite);
        this.traceTable.setLayoutData(new GridData(1808));
        this.traceTable.setFitWidth(true);
        this.traceTable.createProgressPanel();
        return composite;
    }

    public boolean isDirty() {
        return false;
    }

    public void activatePanel() {
        this.refresh(false);
    }

    public void deactivatePanel() {
    }

    public void setFocus() {
    }

    public void refresh(boolean force) {
        this.traceTable.clearListData();
        DBCTrace trace = this.presentation.getController().getModel().getTrace();
        if (trace != null) {
            this.traceTable.loadData();
        }
    }

    private class DBCTraceLoadService
    extends AbstractLoadService<Collection<DBCTraceProperty>> {
        DBCTraceLoadService() {
            super("Loading trace details");
        }

        public Collection<DBCTraceProperty> evaluate(@NotNull DBRProgressMonitor monitor) throws InvocationTargetException {
            try {
                DBCTrace trace = ResultDetailsPanel.this.presentation.getController().getModel().getTrace();
                if (trace instanceof DBCTraceDynamic) {
                    DBCTraceDynamic td = (DBCTraceDynamic)trace;
                    return td.getTraceProperties(monitor);
                }
                return Collections.emptyList();
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }

        public DBCTrace getFamily() {
            return ResultDetailsPanel.this.presentation.getController().getModel().getTrace();
        }
    }

    private class TracePropertyTable
    extends DatabaseObjectListControl<DBCTraceProperty> {
        protected TracePropertyTable(Composite parent) {
            super(parent, 0x10000000, (IWorkbenchSite)ResultDetailsPanel.this.presentation.getController().getSite(), (IContentProvider)new TreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    return new Object[0];
                }

                public boolean hasChildren(Object element) {
                    return false;
                }
            });
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            UIWidgets.fillDefaultTreeContextMenu((IContributionManager)contributionManager, (Tree)((Tree)this.getItemsViewer().getControl()));
        }

        @NotNull
        protected String getListConfigId(List<Class<?>> classList) {
            return ((Object)((Object)ResultDetailsPanel.this)).getClass().getName();
        }

        protected LoadingJob<Collection<DBCTraceProperty>> createLoadService(boolean forUpdate) {
            return LoadingJob.createService((ILoadService)new DBCTraceLoadService(), (ILoadVisualizer)new ObjectListControl.ObjectsLoadVisualizer((ObjectListControl)this));
        }
    }
}

