/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.connections.k8s;

import com.dbeaver.model.net.k8s.K8SResourceType;
import com.dbeaver.model.net.k8s.K8SServiceInfo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

class K8SServiceListDialog
extends BaseDialog {
    private final K8SServiceInfo serviceInfo;
    private K8SServiceInfo.K8sInfoItem selectedK8sInfo = null;

    public K8SServiceListDialog(Shell parentShell, K8SServiceInfo serviceInfo) {
        super(parentShell, "Resources", null);
        this.serviceInfo = serviceInfo;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite mainGroup = UIUtils.createComposite((Composite)composite, (int)1);
        mainGroup.setLayoutData((Object)new GridData(1808));
        Table svcTable = new Table(mainGroup, 2052);
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = 300;
        svcTable.setLayoutData((Object)layoutData);
        svcTable.setHeaderVisible(true);
        UIUtils.createTableColumn((Table)svcTable, (int)16384, (String)"Name");
        UIUtils.createTableColumn((Table)svcTable, (int)16384, (String)"Port");
        UIUtils.createTableColumn((Table)svcTable, (int)16384, (String)"Type");
        for (K8SServiceInfo.K8sInfoItem k8sItem : this.serviceInfo.getK8sInfoItems()) {
            TableItem item = new TableItem(svcTable, 0);
            item.setText(0, k8sItem.svcName());
            item.setText(1, String.valueOf(k8sItem.portInfo().port()));
            item.setText(2, String.valueOf(k8sItem.resourceType().getTitle()));
            item.setData((Object)k8sItem);
        }
        svcTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button okButton = K8SServiceListDialog.this.getButton(0);
                if (okButton != null) {
                    K8SServiceListDialog.this.selectedK8sInfo = e.item != null ? (K8SServiceInfo.K8sInfoItem)e.item.getData() : null;
                    okButton.setEnabled(K8SServiceListDialog.this.selectedK8sInfo != null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                super.widgetDefaultSelected(e);
                K8SServiceListDialog.this.okPressed();
            }
        });
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)svcTable, (boolean)false));
        return composite;
    }

    @NotNull
    private Button createResourceTypeItem(Composite typeGroup, K8SResourceType type) {
        return UIUtils.createRadioButton((Composite)typeGroup, (String)type.getTitle(), (Object)type, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
            }
        });
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(false);
        }
    }

    protected void okPressed() {
        super.okPressed();
    }

    public K8SResourceType getResourceType() {
        return this.selectedK8sInfo == null ? null : this.selectedK8sInfo.resourceType();
    }

    public String getSelectedResource() {
        return this.selectedK8sInfo == null ? null : this.selectedK8sInfo.svcName();
    }

    public int getSelectedPort() {
        return this.selectedK8sInfo == null ? 0 : this.selectedK8sInfo.portInfo().port();
    }
}

