/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.GuardrailContentFilter;
import software.amazon.awssdk.services.bedrock.model.GuardrailContentFiltersCopier;
import software.amazon.awssdk.services.bedrock.model.GuardrailContentFiltersTier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailContentPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailContentPolicy> {
    private static final SdkField<List<GuardrailContentFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(GuardrailContentPolicy.getter(GuardrailContentPolicy::filters)).setter(GuardrailContentPolicy.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailContentFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GuardrailContentFiltersTier> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tier").getter(GuardrailContentPolicy.getter(GuardrailContentPolicy::tier)).setter(GuardrailContentPolicy.setter(Builder::tier)).constructor(GuardrailContentFiltersTier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, TIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailContentPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<GuardrailContentFilter> filters;
    private final GuardrailContentFiltersTier tier;

    private GuardrailContentPolicy(BuilderImpl builder) {
        this.filters = builder.filters;
        this.tier = builder.tier;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<GuardrailContentFilter> filters() {
        return this.filters;
    }

    public final GuardrailContentFiltersTier tier() {
        return this.tier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContentPolicy)) {
            return false;
        }
        GuardrailContentPolicy other = (GuardrailContentPolicy)obj;
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.tier(), other.tier());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailContentPolicy").add("Filters", this.hasFilters() ? this.filters() : null).add("Tier", (Object)this.tier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "tier": {
                return Optional.ofNullable(clazz.cast(this.tier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filters", FILTERS_FIELD);
        map.put("tier", TIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContentPolicy, T> g) {
        return obj -> g.apply((GuardrailContentPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GuardrailContentFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private GuardrailContentFiltersTier tier;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContentPolicy model) {
            this.filters(model.filters);
            this.tier(model.tier);
        }

        public final List<GuardrailContentFilter.Builder> getFilters() {
            List<GuardrailContentFilter.Builder> result = GuardrailContentFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<GuardrailContentFilter.BuilderImpl> filters) {
            this.filters = GuardrailContentFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<GuardrailContentFilter> filters) {
            this.filters = GuardrailContentFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(GuardrailContentFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<GuardrailContentFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (GuardrailContentFilter)((GuardrailContentFilter.Builder)GuardrailContentFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GuardrailContentFiltersTier.Builder getTier() {
            return this.tier != null ? this.tier.toBuilder() : null;
        }

        public final void setTier(GuardrailContentFiltersTier.BuilderImpl tier) {
            this.tier = tier != null ? tier.build() : null;
        }

        @Override
        public final Builder tier(GuardrailContentFiltersTier tier) {
            this.tier = tier;
            return this;
        }

        public GuardrailContentPolicy build() {
            return new GuardrailContentPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailContentPolicy> {
        public Builder filters(Collection<GuardrailContentFilter> var1);

        public Builder filters(GuardrailContentFilter ... var1);

        public Builder filters(Consumer<GuardrailContentFilter.Builder> ... var1);

        public Builder tier(GuardrailContentFiltersTier var1);

        default public Builder tier(Consumer<GuardrailContentFiltersTier.Builder> tier) {
            return this.tier((GuardrailContentFiltersTier)((GuardrailContentFiltersTier.Builder)GuardrailContentFiltersTier.builder().applyMutation(tier)).build());
        }
    }
}

