/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.hybrid;

import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.common.AbstractDriver;
import com.vertica.jdbc.common.JDBCObjectFactory;
import com.vertica.jdbc.hybrid.HybridJDBCObjectFactory;
import com.vertica.jdbc.hybrid.HybridUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.JDBCVersion;
import java.sql.DriverManager;
import java.sql.SQLException;

public abstract class HybridAbstractDriver
extends AbstractDriver {
    public HybridAbstractDriver() {
        HybridUtilities.setExeceptionConverter(this.runningJDBCVersion());
    }

    @Override
    protected JDBCObjectFactory createJDBCObjectFactory() {
        return new HybridJDBCObjectFactory(this.runningJDBCVersion());
    }

    @Override
    public void initializeDriver() throws SQLException {
        try {
            DriverManager.registerDriver(this);
            s_isInitialized = true;
        }
        catch (SQLException e) {
            ExceptionConverter.getInstance().toSQLException("HY000", "A database access error occurred while registering the driver", 0, ExceptionType.DEFAULT);
        }
    }

    protected abstract JDBCVersion runningJDBCVersion();
}

