/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.exception.KsqlClientException;
import io.confluent.ksql.api.client.impl.ResponseHandler;
import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.parsetools.RecordParser;
import java.util.concurrent.CompletableFuture;

public class InsertIntoResponseHandler
extends ResponseHandler<CompletableFuture<Void>> {
    private int numAcks;

    InsertIntoResponseHandler(Context context, RecordParser recordParser, CompletableFuture<Void> cf) {
        super(context, recordParser, cf);
    }

    @Override
    protected void doHandleBodyBuffer(Buffer buff) {
        JsonObject jsonObject = new JsonObject(buff);
        String status = jsonObject.getString("status");
        if ("ok".equals(status)) {
            ++this.numAcks;
        } else if ("error".equals(status)) {
            this.cf.completeExceptionally(new KsqlClientException(String.format("Received error from /inserts-stream. Error code: %d. Message: %s", jsonObject.getInteger("error_code"), jsonObject.getString("message"))));
        } else {
            throw new IllegalStateException("Unrecognized status response from /inserts-stream: " + status);
        }
    }

    @Override
    protected void doHandleException(Throwable t) {
        if (!this.cf.isDone()) {
            this.cf.completeExceptionally(t);
        }
    }

    @Override
    protected void doHandleBodyEnd() {
        if (this.numAcks != 1) {
            throw new IllegalStateException("Received unexpected number of acks from /inserts-stream. Expected: 1. Got: " + this.numAcks);
        }
        if (!this.cf.isDone()) {
            this.cf.complete(null);
        }
    }
}

