/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.api.client.AcksPublisher;
import io.confluent.ksql.api.client.BatchedQueryResult;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.api.client.ClientOptions;
import io.confluent.ksql.api.client.ConnectorDescription;
import io.confluent.ksql.api.client.ConnectorInfo;
import io.confluent.ksql.api.client.ExecuteStatementResult;
import io.confluent.ksql.api.client.KsqlObject;
import io.confluent.ksql.api.client.QueryInfo;
import io.confluent.ksql.api.client.ServerInfo;
import io.confluent.ksql.api.client.SourceDescription;
import io.confluent.ksql.api.client.StreamInfo;
import io.confluent.ksql.api.client.StreamedQueryResult;
import io.confluent.ksql.api.client.TableInfo;
import io.confluent.ksql.api.client.TopicInfo;
import io.confluent.ksql.api.client.exception.KsqlClientException;
import io.confluent.ksql.api.client.impl.AdminResponseHandlers;
import io.confluent.ksql.api.client.impl.AssertResponseHandler;
import io.confluent.ksql.api.client.impl.BatchedQueryResultImpl;
import io.confluent.ksql.api.client.impl.ConnectorCommandResponseHandler;
import io.confluent.ksql.api.client.impl.DdlDmlRequestValidators;
import io.confluent.ksql.api.client.impl.DdlDmlResponseHandlers;
import io.confluent.ksql.api.client.impl.ExecuteQueryResponseHandler;
import io.confluent.ksql.api.client.impl.HttpRequestImpl;
import io.confluent.ksql.api.client.impl.HttpResponseImpl;
import io.confluent.ksql.api.client.impl.InsertIntoResponseHandler;
import io.confluent.ksql.api.client.impl.ResponseHandler;
import io.confluent.ksql.api.client.impl.StreamInsertsResponseHandler;
import io.confluent.ksql.api.client.impl.StreamQueryResponseHandler;
import io.confluent.ksql.rest.entity.KsqlMediaType;
import io.confluent.ksql.security.AuthType;
import io.confluent.ksql.security.Credentials;
import io.confluent.ksql.security.CredentialsFactory;
import io.confluent.ksql.security.oauth.IdpConfig;
import io.confluent.ksql.util.AppInfo;
import io.confluent.ksql.util.PushOffsetVector;
import io.confluent.ksql.util.VertxSslOptionsFactory;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.streams.ReadStream;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientImpl
implements Client {
    protected static final Logger log = LoggerFactory.getLogger(ClientImpl.class);
    private static final String QUERY_STREAM_ENDPOINT = "/query-stream";
    private static final String INSERTS_ENDPOINT = "/inserts-stream";
    private static final String CLOSE_QUERY_ENDPOINT = "/close-query";
    private static final String KSQL_ENDPOINT = "/ksql";
    private static final String INFO_ENDPOINT = "/info";
    private static final String SSL_STORE_TYPE_BCFKS = "BCFKS";
    private final ClientOptions clientOptions;
    private final Vertx vertx;
    private final HttpClient httpClient;
    private final SocketAddress serverSocketAddress;
    private final String authHeader;
    private final boolean ownedVertx;
    private final Map<String, Object> sessionVariables;
    private final Map<String, Object> requestProperties;
    private final AtomicReference<String> serializedConsistencyVector;
    private final AtomicReference<String> continuationToken;
    private final ClientImpl client;

    public ClientImpl(ClientOptions clientOptions) {
        this(clientOptions, Vertx.vertx(), true);
    }

    public ClientImpl(ClientOptions clientOptions, Vertx vertx) {
        this(clientOptions, vertx, false);
    }

    private ClientImpl(ClientOptions clientOptions, Vertx vertx, boolean ownedVertx) {
        this.clientOptions = clientOptions.copy();
        this.vertx = vertx;
        this.ownedVertx = ownedVertx;
        this.httpClient = ClientImpl.createHttpClient(vertx, clientOptions);
        this.authHeader = ClientImpl.createAuthHeader(clientOptions);
        this.serverSocketAddress = SocketAddress.inetSocketAddress((int)clientOptions.getPort(), (String)clientOptions.getHost());
        this.sessionVariables = new HashMap<String, Object>();
        this.serializedConsistencyVector = new AtomicReference<String>("");
        this.continuationToken = new AtomicReference<String>("");
        this.requestProperties = new HashMap<String, Object>();
        this.client = this;
    }

    @Override
    public CompletableFuture<StreamedQueryResult> streamQuery(String sql) {
        return this.streamQuery(sql, new HashMap<String, Object>());
    }

    @Override
    public CompletableFuture<StreamedQueryResult> streamQuery(String sql, Map<String, Object> properties) {
        if (PushOffsetVector.isContinuationTokenEnabled(properties)) {
            properties.put("ksql.query.push.v2.continuation.tokens.enabled", true);
            if (!this.continuationToken.get().equalsIgnoreCase("")) {
                this.requestProperties.put("request.ksql.query.push.continuation.token", this.continuationToken.get());
            }
        }
        CompletableFuture<StreamedQueryResult> cf = new CompletableFuture<StreamedQueryResult>();
        this.makeQueryRequest(sql, properties, cf, (ctx, rp, fut, req) -> new StreamQueryResponseHandler(ctx, rp, fut, this.serializedConsistencyVector, this.continuationToken, sql, properties, this.client));
        return cf;
    }

    @Override
    public BatchedQueryResult executeQuery(String sql) {
        return this.executeQuery(sql, Collections.emptyMap());
    }

    @Override
    public BatchedQueryResult executeQuery(String sql, Map<String, Object> properties) {
        BatchedQueryResultImpl result = new BatchedQueryResultImpl();
        this.makeQueryRequest(sql, properties, result, (context, recordParser, cf, request) -> new ExecuteQueryResponseHandler(context, recordParser, (BatchedQueryResult)cf, this.clientOptions.getExecuteQueryMaxResultRows(), this.serializedConsistencyVector));
        return result;
    }

    @Override
    public CompletableFuture<Void> insertInto(String streamName, KsqlObject row) {
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        Buffer requestBody = Buffer.buffer();
        JsonObject params = new JsonObject().put("target", (Object)streamName);
        requestBody.appendBuffer(params.toBuffer()).appendString("\n");
        requestBody.appendString(row.toJsonString()).appendString("\n");
        this.makePostRequest(INSERTS_ENDPOINT, requestBody, cf, (Handler<HttpClientResponse>)((Handler)response -> this.handleStreamedResponse((HttpClientResponse)response, (CompletableFuture)cf, (ctx, rp, fut, req) -> new InsertIntoResponseHandler(ctx, rp, fut))));
        return cf;
    }

    @Override
    public CompletableFuture<AcksPublisher> streamInserts(String streamName, Publisher<KsqlObject> insertsPublisher) {
        CompletableFuture<AcksPublisher> cf = new CompletableFuture<AcksPublisher>();
        Buffer requestBody = Buffer.buffer();
        JsonObject params = new JsonObject().put("target", (Object)streamName);
        requestBody.appendBuffer(params.toBuffer()).appendString("\n");
        this.makePostRequest(INSERTS_ENDPOINT, requestBody, cf, (Handler<HttpClientResponse>)((Handler)response -> this.handleStreamedResponse((HttpClientResponse)response, (CompletableFuture)cf, (ctx, rp, fut, req) -> new StreamInsertsResponseHandler(ctx, rp, fut, req, insertsPublisher))), false);
        return cf;
    }

    @Override
    public CompletableFuture<Void> terminatePushQuery(String queryId) {
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        this.makePostRequest(CLOSE_QUERY_ENDPOINT, new JsonObject().put("queryId", (Object)queryId), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleCloseQueryResponse(response, cf)));
        return cf;
    }

    @Override
    public CompletableFuture<ExecuteStatementResult> executeStatement(String sql) {
        return this.executeStatement(sql, Collections.emptyMap());
    }

    @Override
    public CompletableFuture<ExecuteStatementResult> executeStatement(String sql, Map<String, Object> properties) {
        CompletableFuture<ExecuteStatementResult> cf = new CompletableFuture<ExecuteStatementResult>();
        if (!DdlDmlRequestValidators.validateExecuteStatementRequest(sql, cf)) {
            return cf;
        }
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)sql).put("streamsProperties", properties).put("sessionVariables", this.sessionVariables), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, DdlDmlResponseHandlers::handleExecuteStatementResponse, DdlDmlResponseHandlers::handleUnexpectedNumResponseEntities)));
        return cf;
    }

    @Override
    public CompletableFuture<List<StreamInfo>> listStreams() {
        CompletableFuture<List<StreamInfo>> cf = new CompletableFuture<List<StreamInfo>>();
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)"list streams;"), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, AdminResponseHandlers::handleListStreamsResponse)));
        return cf;
    }

    @Override
    public CompletableFuture<List<TableInfo>> listTables() {
        CompletableFuture<List<TableInfo>> cf = new CompletableFuture<List<TableInfo>>();
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)"list tables;"), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, AdminResponseHandlers::handleListTablesResponse)));
        return cf;
    }

    @Override
    public CompletableFuture<List<TopicInfo>> listTopics() {
        CompletableFuture<List<TopicInfo>> cf = new CompletableFuture<List<TopicInfo>>();
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)"list topics;"), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, AdminResponseHandlers::handleListTopicsResponse)));
        return cf;
    }

    @Override
    public CompletableFuture<List<QueryInfo>> listQueries() {
        CompletableFuture<List<QueryInfo>> cf = new CompletableFuture<List<QueryInfo>>();
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)"list queries;"), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, AdminResponseHandlers::handleListQueriesResponse)));
        return cf;
    }

    @Override
    public CompletableFuture<SourceDescription> describeSource(String sourceName) {
        CompletableFuture<SourceDescription> cf = new CompletableFuture<SourceDescription>();
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)("describe " + sourceName + ";")).put("sessionVariables", this.sessionVariables), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, AdminResponseHandlers::handleDescribeSourceResponse)));
        return cf;
    }

    @Override
    public CompletableFuture<ServerInfo> serverInfo() {
        CompletableFuture<ServerInfo> cf = new CompletableFuture<ServerInfo>();
        this.makeGetRequest(INFO_ENDPOINT, new JsonObject(), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleObjectResponse(response, cf, AdminResponseHandlers::handleServerInfoResponse)));
        return cf;
    }

    @Override
    public CompletableFuture<Void> createConnector(String name, boolean isSource, Map<String, Object> properties) {
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        String connectorConfigs = properties.entrySet().stream().map(e -> String.format("'%s'='%s'", e.getKey(), e.getValue())).collect(Collectors.joining(","));
        String type = isSource ? "SOURCE" : "SINK";
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)String.format("CREATE %s CONNECTOR %s WITH (%s);", type, name, connectorConfigs)).put("sessionVariables", this.sessionVariables), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, ConnectorCommandResponseHandler::handleCreateConnectorResponse)));
        return cf;
    }

    @Override
    public CompletableFuture<Void> createConnector(String name, boolean isSource, Map<String, Object> properties, boolean ifNotExists) {
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        String connectorConfigs = properties.entrySet().stream().map(e -> String.format("'%s'='%s'", e.getKey(), e.getValue())).collect(Collectors.joining(","));
        String type = isSource ? "SOURCE" : "SINK";
        String ifNotExistsClause = ifNotExists ? "IF NOT EXISTS" : "";
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)String.format("CREATE %s CONNECTOR %s %s WITH (%s);", type, ifNotExistsClause, name, connectorConfigs)).put("sessionVariables", this.sessionVariables), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, ConnectorCommandResponseHandler::handleCreateConnectorResponse)));
        return cf;
    }

    @Override
    public CompletableFuture<Void> dropConnector(String name) {
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)("drop connector " + name + ";")).put("sessionVariables", this.sessionVariables), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, ConnectorCommandResponseHandler::handleDropConnectorResponse)));
        return cf;
    }

    @Override
    public CompletableFuture<Void> dropConnector(String name, boolean ifExists) {
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        String ifExistsClause = ifExists ? "if exists " : "";
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)("drop connector " + ifExistsClause + name + ";")).put("sessionVariables", this.sessionVariables), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, ConnectorCommandResponseHandler::handleDropConnectorResponse)));
        return cf;
    }

    @Override
    public CompletableFuture<List<ConnectorInfo>> listConnectors() {
        CompletableFuture<List<ConnectorInfo>> cf = new CompletableFuture<List<ConnectorInfo>>();
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)"list connectors;"), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, ConnectorCommandResponseHandler::handleListConnectorsResponse)));
        return cf;
    }

    @Override
    public CompletableFuture<ConnectorDescription> describeConnector(String name) {
        CompletableFuture<ConnectorDescription> cf = new CompletableFuture<ConnectorDescription>();
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)("describe connector " + name + ";")).put("sessionVariables", this.sessionVariables), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, ConnectorCommandResponseHandler::handleDescribeConnectorsResponse)));
        return cf;
    }

    @Override
    public CompletableFuture<Void> assertSchema(String subject, boolean exists) {
        return this.assertSchema(Optional.of(subject), Optional.empty(), exists, Optional.empty());
    }

    @Override
    public CompletableFuture<Void> assertSchema(int id, boolean exists) {
        return this.assertSchema(Optional.empty(), Optional.of(id), exists, Optional.empty());
    }

    @Override
    public CompletableFuture<Void> assertSchema(String subject, int id, boolean exists) {
        return this.assertSchema(Optional.of(subject), Optional.of(id), exists, Optional.empty());
    }

    @Override
    public CompletableFuture<Void> assertSchema(String subject, boolean exists, Duration timeout) {
        return this.assertSchema(Optional.of(subject), Optional.empty(), exists, Optional.of(timeout));
    }

    @Override
    public CompletableFuture<Void> assertSchema(int id, boolean exists, Duration timeout) {
        return this.assertSchema(Optional.empty(), Optional.of(id), exists, Optional.of(timeout));
    }

    @Override
    public CompletableFuture<Void> assertSchema(String subject, int id, boolean exists, Duration timeout) {
        return this.assertSchema(Optional.of(subject), Optional.of(id), exists, Optional.of(timeout));
    }

    private CompletableFuture<Void> assertSchema(Optional<String> subject, Optional<Integer> id, boolean exists, Optional<Duration> timeout) {
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        String existClause = exists ? "" : " not exists";
        String subjectClause = subject.isPresent() ? " subject '" + subject.get() + "'" : "";
        String idClause = id.isPresent() ? " id " + id.get() : "";
        String timeoutClause = timeout.isPresent() ? " timeout " + timeout.get().getSeconds() + " seconds" : "";
        String command = "assert" + existClause + " schema" + subjectClause + idClause + timeoutClause + ";";
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)command).put("sessionVariables", this.sessionVariables), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, AssertResponseHandler::handleAssertSchemaResponse)));
        return cf;
    }

    @Override
    public CompletableFuture<Void> assertTopic(String topic, boolean exists) {
        return this.assertTopic(topic, (Map<String, Integer>)ImmutableMap.of(), exists, Optional.empty());
    }

    @Override
    public CompletableFuture<Void> assertTopic(String topic, boolean exists, Duration timeout) {
        return this.assertTopic(topic, (Map<String, Integer>)ImmutableMap.of(), exists, Optional.of(timeout));
    }

    @Override
    public CompletableFuture<Void> assertTopic(String topic, Map<String, Integer> configs, boolean exists) {
        return this.assertTopic(topic, configs, exists, Optional.empty());
    }

    @Override
    public CompletableFuture<Void> assertTopic(String topic, Map<String, Integer> configs, boolean exists, Duration timeout) {
        return this.assertTopic(topic, configs, exists, Optional.of(timeout));
    }

    private CompletableFuture<Void> assertTopic(String topic, Map<String, Integer> configs, boolean exists, Optional<Duration> timeout) {
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        String existClause = exists ? "" : " not exists";
        String configString = configs.size() > 0 ? this.createConfigString(configs) : "";
        String timeoutClause = timeout.isPresent() ? " timeout " + timeout.get().getSeconds() + " seconds" : "";
        String command = "assert" + existClause + " topic '" + topic + "'" + configString + timeoutClause + ";";
        this.makePostRequest(KSQL_ENDPOINT, new JsonObject().put("ksql", (Object)command).put("sessionVariables", this.sessionVariables), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleSingleEntityResponse(response, cf, AssertResponseHandler::handleAssertTopicResponse)));
        return cf;
    }

    private String createConfigString(Map<String, Integer> configs) {
        return " with (" + configs.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(",")) + ")";
    }

    @Override
    public void define(String variable, Object value) {
        this.sessionVariables.put(variable, value);
    }

    @Override
    public void undefine(String variable) {
        this.sessionVariables.remove(variable);
    }

    @Override
    public Map<String, Object> getVariables() {
        return new HashMap<String, Object>(this.sessionVariables);
    }

    @VisibleForTesting
    public String getSerializedConsistencyVector() {
        return this.serializedConsistencyVector.get();
    }

    @Override
    public void close() {
        this.httpClient.close();
        if (this.ownedVertx) {
            this.vertx.close();
        }
    }

    private <T extends CompletableFuture<?>> void makeQueryRequest(String sql, Map<String, Object> properties, T cf, StreamedResponseHandlerSupplier<T> responseHandlerSupplier) {
        JsonObject requestBody = new JsonObject().put("sql", (Object)sql).put("properties", properties).put("sessionVariables", this.sessionVariables).put("requestProperties", this.requestProperties);
        this.makePostRequest(QUERY_STREAM_ENDPOINT, requestBody, cf, (Handler<HttpClientResponse>)((Handler)response -> this.handleStreamedResponse((HttpClientResponse)response, cf, responseHandlerSupplier)));
    }

    @Override
    public Client.HttpRequest buildRequest(String method, String path) {
        return new HttpRequestImpl(method, path, this);
    }

    CompletableFuture<Client.HttpResponse> send(HttpMethod method, String path, Map<String, Object> payload) {
        CompletableFuture<Client.HttpResponse> cf = new CompletableFuture<Client.HttpResponse>();
        JsonObject jsonPayload = new JsonObject(payload).put("sessionVariables", this.sessionVariables);
        this.makeRequest(path, jsonPayload.toBuffer(), cf, (Handler<HttpClientResponse>)((Handler)response -> ClientImpl.handleResponse(response, cf)), true, method);
        return cf;
    }

    private <T extends CompletableFuture<?>> void makeGetRequest(String path, JsonObject requestBody, T cf, Handler<HttpClientResponse> responseHandler) {
        this.makeRequest(path, requestBody.toBuffer(), cf, responseHandler, true, HttpMethod.GET);
    }

    private <T extends CompletableFuture<?>> void makePostRequest(String path, JsonObject requestBody, T cf, Handler<HttpClientResponse> responseHandler) {
        this.makePostRequest(path, requestBody.toBuffer(), cf, responseHandler);
    }

    private <T extends CompletableFuture<?>> void makePostRequest(String path, Buffer requestBody, T cf, Handler<HttpClientResponse> responseHandler) {
        this.makePostRequest(path, requestBody, cf, responseHandler, true);
    }

    private <T extends CompletableFuture<?>> void makePostRequest(String path, Buffer requestBody, T cf, Handler<HttpClientResponse> responseHandler, boolean endRequest) {
        this.makeRequest(path, requestBody, cf, responseHandler, endRequest, HttpMethod.POST);
    }

    private <T extends CompletableFuture<?>> void makeRequest(String path, Buffer requestBody, T cf, Handler<HttpClientResponse> responseHandler, boolean endRequest, HttpMethod method) {
        RequestOptions options = new RequestOptions();
        options.setMethod(method);
        options.setServer(this.serverSocketAddress);
        options.setPort(Integer.valueOf(this.clientOptions.getPort()));
        options.setHost(this.clientOptions.getHost());
        options.setURI(path);
        this.httpClient.request(options, ar -> {
            if (ar.failed()) {
                cf.completeExceptionally(ar.cause());
            }
            HttpClientRequest request = (HttpClientRequest)ar.result();
            request.response(response -> {
                if (response.failed()) {
                    cf.completeExceptionally(response.cause());
                }
                responseHandler.handle(response.result());
            });
            request.exceptionHandler(cf::completeExceptionally);
            request = this.configureUserAgent(request);
            if (this.clientOptions.getAuthType() != AuthType.NONE) {
                request = this.configureAuth(request);
            }
            if (path.equals(QUERY_STREAM_ENDPOINT)) {
                request = this.configureAcceptTypeToLatestMediaType(request);
            }
            if (this.clientOptions.getRequestHeaders() != null) {
                for (Map.Entry<String, String> entry : this.clientOptions.getRequestHeaders().entrySet()) {
                    request.putHeader(entry.getKey(), entry.getValue());
                }
            }
            if (endRequest) {
                request.end(requestBody);
            } else {
                HttpClientRequest finalRequest = request;
                finalRequest.sendHead(version -> finalRequest.writeCustomFrame(0, 0, requestBody));
            }
        });
    }

    private HttpClientRequest configureAuth(HttpClientRequest request) {
        return request.putHeader(HttpHeaderNames.AUTHORIZATION.toString(), this.authHeader);
    }

    private HttpClientRequest configureAcceptTypeToLatestMediaType(HttpClientRequest request) {
        return request.putHeader(HttpHeaderNames.ACCEPT.toString(), KsqlMediaType.LATEST_FORMAT.mediaType());
    }

    private HttpClientRequest configureUserAgent(HttpClientRequest request) {
        String clientVersion = AppInfo.getVersion();
        return request.putHeader(HttpHeaderNames.USER_AGENT.toString(), "ksqlDB Java Client v" + clientVersion);
    }

    private <T extends CompletableFuture<?>> void handleStreamedResponse(HttpClientResponse response, T cf, StreamedResponseHandlerSupplier<T> responseHandlerSupplier) {
        if (response.statusCode() == HttpResponseStatus.OK.code()) {
            RecordParser recordParser = RecordParser.newDelimited((String)"\n", (ReadStream)response);
            ResponseHandler<T> responseHandler = responseHandlerSupplier.get(Vertx.currentContext(), recordParser, cf, response.request());
            recordParser.handler(responseHandler::handleBodyBuffer);
            recordParser.endHandler(responseHandler::handleBodyEnd);
            recordParser.exceptionHandler(responseHandler::handleException);
        } else {
            ClientImpl.handleErrorResponse(response, cf);
        }
    }

    private static void handleCloseQueryResponse(HttpClientResponse response, CompletableFuture<Void> cf) {
        if (response.statusCode() == HttpResponseStatus.OK.code()) {
            cf.complete(null);
        } else {
            ClientImpl.handleErrorResponse(response, cf);
        }
    }

    private static <T> void handleSingleEntityResponse(HttpClientResponse response, CompletableFuture<T> cf, SingleEntityResponseHandler<T> responseHandler) {
        ClientImpl.handleSingleEntityResponse(response, cf, responseHandler, numEntities -> new IllegalStateException("Unexpected number of entities in server response: " + numEntities));
    }

    private static <T> void handleSingleEntityResponse(HttpClientResponse response, CompletableFuture<T> cf, SingleEntityResponseHandler<T> responseHandler, Function<Integer, RuntimeException> multipleEntityErrorSupplier) {
        if (response.statusCode() == HttpResponseStatus.OK.code()) {
            response.bodyHandler(buffer -> {
                JsonObject entity;
                JsonArray entities = buffer.toJsonArray();
                if (entities.size() != 1) {
                    cf.completeExceptionally((Throwable)multipleEntityErrorSupplier.apply(entities.size()));
                    return;
                }
                try {
                    entity = entities.getJsonObject(0);
                }
                catch (Exception e) {
                    cf.completeExceptionally(new IllegalStateException("Unexpected server response format. Response: " + entities.getJsonObject(0)));
                    return;
                }
                responseHandler.accept(entity, cf);
            });
        } else {
            ClientImpl.handleErrorResponse(response, cf);
        }
    }

    private static <T> void handleObjectResponse(HttpClientResponse response, CompletableFuture<T> cf, SingleEntityResponseHandler<T> responseHandler) {
        if (response.statusCode() == HttpResponseStatus.OK.code()) {
            response.bodyHandler(buffer -> {
                JsonObject entity = buffer.toJsonObject();
                responseHandler.accept(entity, cf);
            });
        } else {
            ClientImpl.handleErrorResponse(response, cf);
        }
    }

    static void handleResponse(HttpClientResponse httpResponse, CompletableFuture<Client.HttpResponse> cf) {
        httpResponse.bodyHandler(buffer -> cf.complete(new HttpResponseImpl(httpResponse.statusCode(), buffer.getBytes())));
        httpResponse.exceptionHandler(cf::completeExceptionally);
    }

    private static <T extends CompletableFuture<?>> void handleErrorResponse(HttpClientResponse response, T cf) {
        response.bodyHandler(buffer -> {
            JsonObject errorResponse = buffer.toJsonObject();
            cf.completeExceptionally(new KsqlClientException(String.format("Received %d response from server: %s. Error code: %d", response.statusCode(), errorResponse.getString("message"), errorResponse.getInteger("error_code"))));
        });
    }

    private static HttpClient createHttpClient(Vertx vertx, ClientOptions clientOptions) {
        JksOptions jksOptions;
        HttpClientOptions options = new HttpClientOptions().setSsl(clientOptions.isUseTls()).setUseAlpn(clientOptions.isUseAlpn()).setProtocolVersion(HttpVersion.HTTP_2).setHttp2ClearTextUpgrade(false).setVerifyHost(clientOptions.isVerifyHost()).setDefaultHost(clientOptions.getHost()).setDefaultPort(clientOptions.getPort()).setHttp2MultiplexingLimit(clientOptions.getHttp2MultiplexingLimit());
        if (clientOptions.isUseTls() && !clientOptions.getTrustStore().isEmpty()) {
            if (Objects.equals(clientOptions.getStoreType(), SSL_STORE_TYPE_BCFKS)) {
                Optional bcfksOptions = VertxSslOptionsFactory.getBcfksTrustStoreOptions((String)clientOptions.getSecurityProviders(), (String)clientOptions.getTrustStore(), (String)clientOptions.getTrustStorePassword(), (String)clientOptions.getTrustManagerAlgorithm());
                if (bcfksOptions.isPresent()) {
                    options = options.setTrustOptions((TrustOptions)bcfksOptions.get());
                }
            } else {
                jksOptions = VertxSslOptionsFactory.getJksTrustStoreOptions((String)clientOptions.getTrustStore(), (String)clientOptions.getTrustStorePassword());
                options = options.setTrustStoreOptions(jksOptions);
            }
        }
        if (!clientOptions.getKeyStore().isEmpty()) {
            if (Objects.equals(clientOptions.getStoreType(), SSL_STORE_TYPE_BCFKS)) {
                Optional keyStoreOptions = VertxSslOptionsFactory.getBcfksKeyStoreOptions((String)clientOptions.getSecurityProviders(), (String)clientOptions.getKeyStore(), (String)clientOptions.getKeyStorePassword(), (String)clientOptions.getKeyPassword(), (String)clientOptions.getKeyManagerAlgorithm());
                if (keyStoreOptions.isPresent()) {
                    options = options.setKeyCertOptions((KeyCertOptions)keyStoreOptions.get());
                }
            } else {
                jksOptions = VertxSslOptionsFactory.buildJksKeyStoreOptions((String)clientOptions.getKeyStore(), (String)clientOptions.getKeyStorePassword(), Optional.of(clientOptions.getKeyPassword()), Optional.of(clientOptions.getKeyAlias()));
                options = options.setKeyStoreOptions(jksOptions);
            }
        }
        return vertx.createHttpClient(options);
    }

    private static boolean isNullOrEmpty(String candidate) {
        return candidate == null || candidate.trim().isEmpty();
    }

    private static void putIfNotEmpty(Map<String, Object> map, String key, String value) {
        if (!ClientImpl.isNullOrEmpty(value)) {
            map.put(key, value);
        }
    }

    static Map<String, Object> getSslConfigs(ClientOptions clientOptions) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        ClientImpl.putIfNotEmpty(props, "ssl.truststore.location", clientOptions.getTrustStore());
        ClientImpl.putIfNotEmpty(props, "ssl.truststore.password", clientOptions.getTrustStorePassword());
        ClientImpl.putIfNotEmpty(props, "ssl.keystore.location", clientOptions.getKeyStore());
        ClientImpl.putIfNotEmpty(props, "ssl.keystore.password", clientOptions.getKeyStorePassword());
        ClientImpl.putIfNotEmpty(props, "ssl.key.password", clientOptions.getKeyPassword());
        ClientImpl.putIfNotEmpty(props, "ssl.key.alias", clientOptions.getKeyAlias());
        props.put("ssl.alpn", clientOptions.isUseAlpn());
        props.put("ssl.verify.host", clientOptions.isVerifyHost());
        return props;
    }

    public static String createAuthHeader(ClientOptions clientOptions) {
        Credentials credentials;
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (clientOptions.getAuthType() == AuthType.BASIC) {
            log.debug("Configuring basic auth for user = {}", (Object)clientOptions.getBasicAuthUsername());
            props.put("ksql.auth.basic.username", clientOptions.getBasicAuthUsername());
            props.put("ksql.auth.basic.password", clientOptions.getBasicAuthPassword());
        }
        if (clientOptions.getAuthType() == AuthType.OAUTHBEARER) {
            IdpConfig idpConfig = clientOptions.getIdpConfig();
            log.debug("Configuring bearer auth for clientId = {}", (Object)idpConfig.getIdpClientId());
            props.put("bearer.auth.issuer.endpoint.url", idpConfig.getIdpTokenEndpointUrl());
            props.put("bearer.auth.client.id", idpConfig.getIdpClientId());
            props.put("bearer.auth.client.secret", idpConfig.getIdpClientSecret());
            props.put("bearer.auth.scope", idpConfig.getIdpScope());
            props.put("bearer.auth.scope.claim.name", idpConfig.getIdpScopeClaimName());
            props.put("bearer.auth.sub.claim.name", idpConfig.getIdpSubClaimName());
            props.put("bearer.auth.cache.expiry.buffer.seconds", idpConfig.getIdpCacheExpiryBufferSeconds());
        }
        if (clientOptions.isUseTls()) {
            props.putAll(ClientImpl.getSslConfigs(clientOptions));
        }
        if ((credentials = CredentialsFactory.createCredentials((AuthType)clientOptions.getAuthType())) != null) {
            credentials.configure(props);
            return credentials.getAuthHeader();
        }
        log.debug("No authentication method provided for Ksql Client");
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientImpl client = (ClientImpl)o;
        return this.clientOptions.equals(client.clientOptions) && this.vertx.equals(client.vertx);
    }

    public int hashCode() {
        return Objects.hash(this.clientOptions, this.vertx);
    }

    public String toString() {
        return "Client{clientOptions=" + this.clientOptions + ", vertx=" + this.vertx + '}';
    }

    @FunctionalInterface
    private static interface SingleEntityResponseHandler<T> {
        public void accept(JsonObject var1, CompletableFuture<T> var2);
    }

    @FunctionalInterface
    private static interface StreamedResponseHandlerSupplier<T extends CompletableFuture<?>> {
        public ResponseHandler<T> get(Context var1, RecordParser var2, T var3, HttpClientRequest var4);
    }
}

