/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard.diagram.parts;

import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPResult;
import com.dbeaver.ee.scmp.model.CMPResultChangeItem;
import com.dbeaver.ee.scmp.ui.wizard.diagram.DiffDiagramDecorator;
import com.dbeaver.ee.scmp.ui.wizard.diagram.DiffEntityDetails;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.erd.ERDContainer;
import org.jkiss.dbeaver.model.erd.ERDContentProvider;
import org.jkiss.dbeaver.model.erd.ERDDiagram;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDPalettePreferences;
import org.jkiss.dbeaver.ui.editors.erd.model.ERDContentProviderDecorated;
import org.jkiss.dbeaver.ui.editors.erd.model.ERDDecorator;
import org.jkiss.dbeaver.ui.editors.erd.model.EntityDiagram;

public class DiffDiagramPart
extends ERDEditorPart {
    private static final Log log = Log.getLog(DiffDiagramPart.class);
    private CMPOptions options;
    private CMPResult compareResult;

    public boolean isReadOnly() {
        return true;
    }

    protected boolean hasProgressControl() {
        return false;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    protected void loadDiagram(boolean refreshMetadata) {
        if (this.options == null) {
            log.warn((Object)"Can't load input settings.");
            return;
        }
        DatabaseLoadService<EntityDiagram> loadService = new DatabaseLoadService<EntityDiagram>("Load diff", this.options.getSourceDataSourceContainer().getDataSource()){

            public EntityDiagram evaluate(@NotNull DBRProgressMonitor monitor) throws InvocationTargetException {
                EntityDiagram entityDiagram = new EntityDiagram(null, "Diff", DiffDiagramPart.this.getContentProvider(), DiffDiagramPart.this.getDecorator());
                entityDiagram.setLayoutManualAllowed(true);
                try {
                    DiffDiagramPart.this.loadDiagramFromDiff(monitor, entityDiagram);
                    if (monitor.isCanceled()) {
                        return entityDiagram;
                    }
                    UIUtils.syncExec(() -> {
                        ERDGraphicalViewer graphicalViewer = DiffDiagramPart.this.getGraphicalViewer();
                        graphicalViewer.setContents((Object)entityDiagram);
                        graphicalViewer.getEditor().getDiagramPart().resetArrangement();
                    });
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                monitor.done();
                return entityDiagram;
            }
        };
        this.diagramLoadingJob = LoadingJob.createService((ILoadService)loadService, (ILoadVisualizer)new ERDEditorPart.DiagramLoaderVisualizer(this, (ILoadService)loadService, (Composite)this.getGraphicalControl()){

            protected void finishLoading() {
            }
        });
        this.diagramLoadingJob.schedule();
    }

    @NotNull
    public DBPProject getDiagramProject() {
        return this.options.getSourceDataSourceContainer().getProject();
    }

    private void loadDiagramFromDiff(DBRProgressMonitor monitor, EntityDiagram diagram) throws DBException {
        ArrayList<ERDEntity> allEntities = new ArrayList<ERDEntity>();
        for (CMPResultChangeItem item : this.compareResult.getChangeSet().getChangeItems()) {
            DBSObject object;
            if (item.getObjectType() == RelationalObjectType.TYPE_TABLE) {
                object = item.getObject(monitor);
                if (object == null) {
                    log.debug((Object)("Can't find database object for " + item.getObjectName()));
                    continue;
                }
                if (object instanceof DBSEntity) {
                    ERDEntity entity = new ERDEntity((DBSEntity)object);
                    entity.setUserData((Object)new DiffEntityDetails(item));
                    diagram.addEntity(entity, false);
                    allEntities.add(entity);
                    continue;
                }
                log.debug((Object)("Table object " + DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI) + " is not DBSEntity"));
                continue;
            }
            if (item.getObjectType() != RelationalObjectType.TYPE_TABLE_COLUMN || !((object = item.getObject(monitor)) instanceof DBSEntityAttribute)) continue;
            DBSEntity dbsEntity = ((DBSEntityAttribute)object).getParentObject();
            ERDEntity erdEntity = diagram.getEntity(dbsEntity);
            if (erdEntity == null) {
                erdEntity = new ERDEntity(dbsEntity);
                erdEntity.setUserData((Object)new DiffEntityDetails());
                diagram.addEntity(erdEntity, false);
                allEntities.add(erdEntity);
            }
            DiffEntityDetails entityDetails = (DiffEntityDetails)erdEntity.getUserData();
            entityDetails.addNestedItem(item);
        }
        for (ERDEntity entity : allEntities) {
            diagram.getContentProvider().fillEntityFromObject(monitor, (ERDDiagram)diagram, allEntities, entity);
            entity.addModelRelations(monitor, (ERDContainer)diagram, true, false);
        }
    }

    public void setCompareResult(CMPOptions options, CMPResult compareResult) {
        this.options = options;
        this.compareResult = compareResult;
    }

    protected ERDContentProvider createContentProvider() {
        return new ERDContentProviderDecorated(){

            protected boolean isAttributeVisible(ERDEntity erdEntity, DBSEntityAttribute attribute) {
                DiffEntityDetails changeItem = (DiffEntityDetails)erdEntity.getUserData();
                switch (changeItem.getChangeType()) {
                    case CREATE: 
                    case RENAME: 
                    case DROP: {
                        return false;
                    }
                }
                return DiffDiagramDecorator.getAttributeItem(changeItem, attribute) != null;
            }
        };
    }

    protected ERDDecorator createDecorator() {
        return new DiffDiagramDecorator();
    }

    protected ERDPalettePreferences getPalettePreferences() {
        return new ERDPalettePreferences(){

            public int getPaletteState() {
                return 2;
            }
        };
    }
}

