/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.MetadataItem;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.sql.SQLException;

public class LimitedContentMetadataItem
extends MetadataItem {
    protected short dataType;
    protected long maxDataLengthInBytes;
    protected short totalNumberOfDigits;
    protected short numberOfIntervalDigits;
    protected short numberOfFractionalDigits;
    protected int m_nReceiveMetadataItemNum = 0;
    protected int m_nTransmitMetadataItemNum = 0;

    public LimitedContentMetadataItem(GenericTeradataConnection genericTeradataConnection, short s, short s2, short s3) {
        super(genericTeradataConnection, s, s2, s3);
    }

    @Override
    public void extractData(TDPacketStream tDPacketStream) throws SQLException {
        this.dataType = tDPacketStream.getShort();
        this.maxDataLengthInBytes = tDPacketStream.getLong();
        this.totalNumberOfDigits = tDPacketStream.getShort();
        this.numberOfIntervalDigits = tDPacketStream.getShort();
        this.numberOfFractionalDigits = tDPacketStream.getShort();
    }

    @Override
    public String toString() {
        String string = super.toString();
        if (this.m_nReceiveMetadataItemNum > 0) {
            string = string + "receiveItemNumber        : " + this.m_nReceiveMetadataItemNum + Log.LINE_SEP;
        }
        if (this.m_nTransmitMetadataItemNum > 0) {
            string = string + "transmitItemNumber       : " + this.m_nTransmitMetadataItemNum + Log.LINE_SEP;
        }
        string = string + "-- Body --" + Log.LINE_SEP;
        string = string + "dataType                 : " + this.dataType + Log.LINE_SEP;
        string = string + "maxDataLengthInBytes     : " + this.maxDataLengthInBytes + Log.LINE_SEP;
        string = string + "totalNumberOfDigits      : " + this.totalNumberOfDigits + Log.LINE_SEP;
        string = string + "numberOfIntervalDigits   : " + this.numberOfIntervalDigits + Log.LINE_SEP;
        string = string + "numberOfFractionalDigits : " + this.numberOfFractionalDigits + Log.LINE_SEP;
        return string;
    }

    public short getDataType() {
        return this.dataType;
    }

    public void setDataType(short s) {
        this.dataType = s;
    }

    public long getMaxDataLengthInBytes() {
        return this.maxDataLengthInBytes;
    }

    public void setMaxDataLengthInBytes(long l) {
        this.maxDataLengthInBytes = l;
    }

    public short getTotalNumberOfDigits() {
        return this.isFloatingNumber() ? (short)40 : (short)this.totalNumberOfDigits;
    }

    public void setTotalNumberOfDigits(short s) {
        this.totalNumberOfDigits = s;
    }

    public short getNumberOfIntervalDigits() {
        return this.numberOfIntervalDigits;
    }

    public void setNumberOfIntervalDigits(short s) {
        this.numberOfIntervalDigits = s;
    }

    public short getNumberOfFractionalDigits() {
        return this.isFloatingNumber() && this.numberOfFractionalDigits == -128 ? (short)0 : this.numberOfFractionalDigits;
    }

    public void setNumberOfFractionalDigits(short s) {
        this.numberOfFractionalDigits = s;
    }

    public long getPrepInfoDataLength(int n) {
        return JDBC4Constants.getTDBasicType(this.dataType) == 484 ? (long)this.totalNumberOfDigits << n | (long)this.numberOfFractionalDigits : this.maxDataLengthInBytes;
    }

    public boolean isFloatingNumber() {
        return JDBC4Constants.getJavaSQLType(this.dataType) == 2 && this.totalNumberOfDigits == -128;
    }

    public int getReceiveMetadataItemNumber() {
        return this.m_nReceiveMetadataItemNum;
    }

    public void setReceiveMetadataItemNumber(int n) {
        this.m_nReceiveMetadataItemNum = n;
    }

    public int getTransmitMetadataItemNumber() {
        return this.m_nTransmitMetadataItemNum;
    }

    public void setTransmitMetadataItemNumber(int n) {
        this.m_nTransmitMetadataItemNum = n;
    }
}

