/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.CurrentThreadIO;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.LocatorBlob;
import com.teradata.jdbc.LocatorClob;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ClientAttributesParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResultSetSelectionItem;
import com.teradata.jdbc.jdbc_4.statemachine.RSSelectionContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.security.Security;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeraDriver
implements Driver {
    protected static Log sm_log = new Log("TeraDriver/" + TeraDriver.class.getClassLoader());
    public static final String DEFAULT_CONN_PREFIX = "jdbc:default:connection";
    public static final String REMOTE_CONN_PREFIX = "jdbc:teradata://";
    private static Hashtable ioTable = new Hashtable();
    private static final int FORMAT_TEXT = 1;
    private static final int FORMAT_RAW = 2;
    private static final int FORMAT_CSV = 3;
    private static Calendar DUMMY_CALENDAR;

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        return TeraDriver.doConnect(string, properties);
    }

    private static Connection doConnect(String string, Properties properties) throws SQLException {
        Connection connection;
        String string2;
        String string3;
        if (!TeraDriver.doAcceptsURL(string)) {
            return null;
        }
        boolean bl = string.startsWith(DEFAULT_CONN_PREFIX);
        String string4 = "";
        String string5 = bl ? DEFAULT_CONN_PREFIX : REMOTE_CONN_PREFIX;
        String string6 = string.substring(string5.length());
        int n = string6.indexOf("/");
        if (n >= 0) {
            string3 = string6.substring(0, n);
            string4 = string6.substring(n + 1);
        } else {
            string3 = string6.trim();
            string4 = "";
        }
        if (string3.startsWith("[") && string3.endsWith("]")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        if (properties != null && properties.containsKey("username")) {
            boolean bl2;
            string2 = (String)properties.remove("username");
            boolean bl3 = bl2 = !properties.containsKey("user");
            if (bl2) {
                properties.setProperty("user", string2);
            }
        }
        URLParameters uRLParameters = new URLParameters(string4, properties);
        string2 = uRLParameters.getUser();
        String string7 = uRLParameters.getPassword();
        if (string2 == null) {
            string2 = "";
        }
        if (string7 == null) {
            string7 = "";
        }
        uRLParameters.setJavaSPDefaultConnection(bl);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        if (uRLParameters.isJavaSPDefaultConnection() && currentThreadIO == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ496");
        }
        if (uRLParameters.isJavaSPDefaultConnection() && "DEBUG".equalsIgnoreCase((String)currentThreadIO.getOptions().get("LOG"))) {
            uRLParameters.setLogLevel("DEBUG");
        }
        Connection connection2 = connection = uRLParameters.isJavaSPDefaultConnection() && currentThreadIO.getConnection() != null ? currentThreadIO.getConnection() : ConnectionFactory.createConnection(string3, string2, string7, uRLParameters);
        if (uRLParameters.isJavaSPDefaultConnection()) {
            TDSession tDSession = (TDSession)connection;
            if (currentThreadIO.getConnection() == null) {
                currentThreadIO.setConnection(connection);
                Integer n2 = (Integer)currentThreadIO.getOptions().get("SPReturnResult");
                if (n2 != null) {
                    tDSession.setSPReturnResult(n2.byteValue());
                }
                if (tDSession.getLog().isDebugEnabled()) {
                    tDSession.getLog().debug("options SPReturnResult=" + n2 + ", session getSPReturnResult=" + tDSession.getSPReturnResult());
                }
            }
            tDSession.updateURLParameters(uRLParameters);
        }
        return connection;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        return TeraDriver.doAcceptsURL(string);
    }

    private static boolean doAcceptsURL(String string) {
        return string != null && (string.startsWith(DEFAULT_CONN_PREFIX) || string.startsWith(REMOTE_CONN_PREFIX));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String string2 = properties != null && properties.containsKey("username") ? "username" : "user";
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, null);
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = ErrorMessage.messages.getString("TJ401");
        DriverPropertyInfo driverPropertyInfo2 = new DriverPropertyInfo("password", null);
        driverPropertyInfo2.required = true;
        driverPropertyInfo2.description = ErrorMessage.messages.getString("TJ402");
        return new DriverPropertyInfo[]{driverPropertyInfo, driverPropertyInfo2};
    }

    @Override
    public int getMajorVersion() {
        return 20;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static void setCurrentThreadDefaultConnection(InputStream inputStream, OutputStream outputStream, Map map) throws SQLException {
        CurrentThreadIO currentThreadIO = new CurrentThreadIO(inputStream, outputStream, map);
        ioTable.put(Thread.currentThread(), currentThreadIO);
        TeraDriver.doConnect(DEFAULT_CONN_PREFIX, new Properties());
    }

    public static CurrentThreadIO getCurrentThreadDefaultConnection() {
        return (CurrentThreadIO)ioTable.get(Thread.currentThread());
    }

    public static Clob createDefaultConnectionClob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        return tDSession.constructLocatorClob(l, byArray2, false);
    }

    public static byte[] getClobLocator(Clob clob) throws SQLException {
        LocatorClob locatorClob = (LocatorClob)clob;
        byte[] byArray = locatorClob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Object createDefaultConnectionSQLXML(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        return tDSession.constructLocatorSQLXML((short)860, l, byArray2);
    }

    public static byte[] getSQLXMLLocator(Object object) throws SQLException {
        byte[] byArray = ((TeraSQLXML)object).getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Blob createDefaultConnectionBlob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        return tDSession.constructLocatorBlob(l, byArray2, false);
    }

    public static byte[] getBlobLocator(Blob blob) throws SQLException {
        LocatorBlob locatorBlob = (LocatorBlob)blob;
        byte[] byArray = locatorBlob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDynamicResultSets(ResultSet[] resultSetArray, Integer n) throws SQLException {
        AutoCloseable autoCloseable;
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        Log log = ((TDSession)currentThreadIO.getConnection()).getLog();
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " total number of result sets is: " + (resultSetArray == null ? 0 : resultSetArray.length));
        }
        ArrayList<ResultSetSelectionItem> arrayList = new ArrayList<ResultSetSelectionItem>();
        for (int i = 0; resultSetArray != null && i < resultSetArray.length; ++i) {
            if (resultSetArray[i] == null || (autoCloseable = (TDResultSet)resultSetArray[i]) == null || ((TDResultSet)autoCloseable).isClosed()) continue;
            long l = ((TDResultSet)autoCloseable).getDynamicResultSetCurrentRowNumber();
            if (log.isDebugEnabled()) {
                log.debug("closeDynamicResultSets reqnum=" + n + " adding rs[" + i + "]" + " reqnum=" + ((TDResultSet)autoCloseable).getRequestNumber() + " stmtnum=" + ((TDResultSet)autoCloseable).getStatementNumber() + " row=" + l);
            }
            arrayList.add(new ResultSetSelectionItem(((TDResultSet)autoCloseable).getStatementNumber(), ((TDResultSet)autoCloseable).getRequestNumber(), l));
            ((TDResultSet)autoCloseable).suppressResponseCancel();
        }
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " number of open result sets: " + arrayList.size());
        }
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        autoCloseable = (TDStatement)tDSession.createStatement();
        StatementController statementController = new StatementController((TDStatement)autoCloseable, tDSession, null);
        statementController.setCurrentRequestNumber(n);
        StatementReceiveState statementReceiveState = new StatementReceiveState(statementController);
        statementReceiveState.setRequestNum(n);
        statementController.setHistoricalState(new RSSelectionContinueState(statementController, statementReceiveState, arrayList));
        tDSession.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        try {
            statementController.run();
        }
        finally {
            tDSession.releaseSessionLock();
        }
    }

    private static String quoteText(String string) {
        return string == null ? "null" : "\"" + string.replaceAll("[\r\n]+", " ").replaceAll("\"", "\"\"") + "\"";
    }

    private static String quoteCsvText(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= ' ' && c != ',' && c != '\"') continue;
            return "\"" + string.replaceAll("\"", "\"\"") + "\"";
        }
        return string;
    }

    private static String formatValue(int n, boolean bl, int n2, String string, String string2) {
        if (n == 1) {
            return string + " = " + TeraDriver.quoteText(string2);
        }
        if (n == 2) {
            return (bl ? string + "=" : (n2 > 1 ? " " : "")) + (string2 == null ? "null" : string2.replaceAll("[\r\n]+", "\n"));
        }
        return (n2 > 1 ? "," : "") + (string2 == null ? "" : TeraDriver.quoteCsvText(string2));
    }

    private static void printValue(PrintWriter printWriter, int n, boolean bl, int n2, int n3, String string, String string2) {
        boolean bl2;
        String string3 = TeraDriver.formatValue(n, bl, n2, string, string2);
        boolean bl3 = n == 1 || n == 2 && bl;
        boolean bl4 = bl2 = n2 >= n3;
        if (bl3 || bl2) {
            printWriter.println(string3);
        } else {
            printWriter.print(string3);
        }
    }

    private static void printArray(PrintWriter printWriter, int n, boolean bl, String[][] stringArray) {
        int n2;
        String[] stringArray2 = stringArray[0];
        for (int i = n2 = n == 3 ? 0 : 1; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            for (int j = 1; j <= stringArray3.length; ++j) {
                TeraDriver.printValue(printWriter, n, bl, j, stringArray3.length, stringArray2[j - 1], stringArray3[j - 1]);
            }
        }
    }

    private static void printNameValue(PrintWriter printWriter, int n, String string, String string2) {
        TeraDriver.printArray(printWriter, n, false, new String[][]{{string}, {string2}});
    }

    private static void printProps(PrintWriter printWriter, int n, Properties properties) {
        Map.Entry[] entryArray = properties == null ? new Map.Entry[]{} : properties.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(entryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                Comparable comparable = (Comparable)entry.getKey();
                Comparable comparable2 = (Comparable)entry2.getKey();
                return comparable.compareTo(comparable2);
            }
        });
        String[][] stringArray = new String[][]{new String[entryArray.length], new String[entryArray.length]};
        for (int i = 0; i < entryArray.length; ++i) {
            stringArray[0][i] = (String)entryArray[i].getKey();
            stringArray[1][i] = (String)entryArray[i].getValue();
        }
        if (n == 1) {
            printWriter.println("(Properties " + (properties == null ? "null" : "" + entryArray.length) + ")");
        }
        TeraDriver.printArray(printWriter, n, true, stringArray);
    }

    private static String formatCsvHeader(ResultSetMetaData resultSetMetaData, int n, boolean bl) throws SQLException {
        return resultSetMetaData.getColumnName(n) + (bl ? " " + resultSetMetaData.getColumnTypeName(n) + (resultSetMetaData.getColumnType(n) == -2 ? "(" + resultSetMetaData.getPrecision(n) + ")" : "") + (resultSetMetaData.getColumnType(n) == 3 ? "(" + resultSetMetaData.getPrecision(n) + (resultSetMetaData.getScale(n) != 0 ? "," + resultSetMetaData.getScale(n) : "") + ")" : "") : "");
    }

    private static String formatAsHexDigits(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i] & 0xFF);
            string = string + (string2.length() < 2 ? "0" : "") + string2;
        }
        return string;
    }

    private static byte[] parseHexDigits(String string) {
        boolean bl;
        if (string == null) {
            return null;
        }
        boolean bl2 = bl = (string.length() & 1) == 1;
        if (bl) {
            throw new IllegalArgumentException("Odd number of hex digits: " + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
        }
        return byArray;
    }

    private static void printResultSetMetaData(PrintWriter printWriter, int n, Map<String, Boolean> map, ResultSetMetaData resultSetMetaData) throws SQLException {
        if (!map.values().contains(true)) {
            return;
        }
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            int n2;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            if (map.get("getCatalogName").booleanValue()) {
                linkedHashMap.put("getCatalogName", "" + resultSetMetaData.getCatalogName(i));
            }
            if (map.get("getColumnClassName").booleanValue()) {
                linkedHashMap.put("getColumnClassName", "" + resultSetMetaData.getColumnClassName(i));
            }
            if (map.get("getColumnDisplaySize").booleanValue()) {
                linkedHashMap.put("getColumnDisplaySize", "" + resultSetMetaData.getColumnDisplaySize(i));
            }
            if (map.get("getColumnLabel").booleanValue()) {
                linkedHashMap.put("getColumnLabel", "" + resultSetMetaData.getColumnLabel(i));
            }
            if (map.get("getColumnName").booleanValue()) {
                linkedHashMap.put("getColumnName", "" + resultSetMetaData.getColumnName(i));
            }
            if (map.get("getColumnType").booleanValue()) {
                linkedHashMap.put("getColumnType", "" + resultSetMetaData.getColumnType(i));
            }
            if (map.get("getColumnTypeName").booleanValue()) {
                linkedHashMap.put("getColumnTypeName", "" + resultSetMetaData.getColumnTypeName(i));
            }
            if (map.get("getPrecision").booleanValue()) {
                linkedHashMap.put("getPrecision", "" + resultSetMetaData.getPrecision(i));
            }
            if (map.get("getScale").booleanValue()) {
                linkedHashMap.put("getScale", "" + resultSetMetaData.getScale(i));
            }
            if (map.get("getSchemaName").booleanValue()) {
                linkedHashMap.put("getSchemaName", "" + resultSetMetaData.getSchemaName(i));
            }
            if (map.get("getTableName").booleanValue()) {
                linkedHashMap.put("getTableName", "" + resultSetMetaData.getTableName(i));
            }
            if (map.get("isAutoIncrement").booleanValue()) {
                linkedHashMap.put("isAutoIncrement", "" + resultSetMetaData.isAutoIncrement(i));
            }
            if (map.get("isCaseSensitive").booleanValue()) {
                linkedHashMap.put("isCaseSensitive", "" + resultSetMetaData.isCaseSensitive(i));
            }
            if (map.get("isCurrency").booleanValue()) {
                linkedHashMap.put("isCurrency", "" + resultSetMetaData.isCurrency(i));
            }
            if (map.get("isDefinitelyWritable").booleanValue()) {
                linkedHashMap.put("isDefinitelyWritable", "" + resultSetMetaData.isDefinitelyWritable(i));
            }
            if (map.get("isNullable").booleanValue()) {
                linkedHashMap.put("isNullable", "" + resultSetMetaData.isNullable(i));
            }
            if (map.get("isReadOnly").booleanValue()) {
                linkedHashMap.put("isReadOnly", "" + resultSetMetaData.isReadOnly(i));
            }
            if (map.get("isSearchable").booleanValue()) {
                linkedHashMap.put("isSearchable", "" + resultSetMetaData.isSearchable(i));
            }
            if (map.get("isSigned").booleanValue()) {
                linkedHashMap.put("isSigned", "" + resultSetMetaData.isSigned(i));
            }
            if (map.get("isWritable").booleanValue()) {
                linkedHashMap.put("isWritable", "" + resultSetMetaData.isWritable(i));
            }
            ArrayList arrayList = new ArrayList(linkedHashMap.entrySet());
            if (n == 3 && i == 1) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    TeraDriver.printValue(printWriter, n, true, n2 + 1, arrayList.size(), null, (String)((Map.Entry)arrayList.get(n2)).getKey());
                }
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                TeraDriver.printValue(printWriter, n, true, n2 + 1, arrayList.size(), (String)((Map.Entry)arrayList.get(n2)).getKey() + "(" + i + ")", (String)((Map.Entry)arrayList.get(n2)).getValue());
            }
        }
    }

    private static void printResultSet(PrintWriter printWriter, int n, Map<String, Boolean> map, boolean bl, String string, ResultSet resultSet) throws SQLException {
        int n2;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        TeraDriver.printResultSetMetaData(printWriter, n, map, resultSetMetaData);
        if (n == 3) {
            for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                TeraDriver.printValue(printWriter, n, false, n2, resultSetMetaData.getColumnCount(), null, TeraDriver.formatCsvHeader(resultSetMetaData, n2, bl));
            }
        }
        while (resultSet.next()) {
            for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                Comparable<Calendar> comparable;
                String string2 = (string != null ? string + " " : "") + "Row " + resultSet.getRow() + " Column " + n2 + " " + TeraDriver.quoteText(resultSetMetaData.getColumnName(n2)) + " " + resultSetMetaData.getColumnTypeName(n2) + "(" + resultSetMetaData.getPrecision(n2) + ")";
                String string3 = resultSetMetaData.getColumnType(n2) == 2004 || resultSetMetaData.getColumnType(n2) == -2 || resultSetMetaData.getColumnType(n2) == -3 || resultSetMetaData.getColumnType(n2) == -4 ? TeraDriver.formatAsHexDigits(resultSet.getBytes(n2)) : (resultSetMetaData.getColumnType(n2) == 92 ? ((comparable = resultSet.getTimestamp(n2)) == null ? null : ((Timestamp)comparable).toString().substring("1970-01-01 ".length())) : resultSet.getString(n2));
                if (string3 != null && resultSetMetaData.getColumnTypeName(n2).endsWith(" WITH TIME ZONE")) {
                    comparable = Calendar.getInstance();
                    resultSet.getTimestamp(n2, (Calendar)comparable);
                    string3 = string3 + TDPreparedStatement.formatTimeZone(((Calendar)comparable).getTimeZone());
                }
                TeraDriver.printValue(printWriter, n, false, n2, resultSetMetaData.getColumnCount(), string2, string3);
            }
        }
    }

    private static void printUpdateCounts(PrintWriter printWriter, int n, int[] nArray) {
        if (n == 3) {
            TeraDriver.printValue(printWriter, n, false, 1, 1, null, "Update Counts");
        }
        for (int i = 0; i < nArray.length; ++i) {
            TeraDriver.printValue(printWriter, n, false, 1, 1, "Update count " + (i + 1), "" + nArray[i]);
        }
    }

    private static CsvHeader[] parseCsvHeaders(String[] stringArray) {
        CsvHeader[] csvHeaderArray = new CsvHeader[stringArray.length];
        block0: for (int i = 0; i < csvHeaderArray.length; ++i) {
            CsvHeader csvHeader;
            csvHeaderArray[i] = csvHeader = new CsvHeader();
            csvHeader.sHeader = stringArray[i];
            csvHeader.nType = 1111;
            if (csvHeader.sHeader == null) continue;
            for (int j = 0; j < TypeDesc.types.length; ++j) {
                Matcher matcher = Pattern.compile("(?i).* " + TypeDesc.types[j].sTypeName + "(?:\\(([0-9]+)(?:,([0-9]+))?\\))?").matcher(csvHeader.sHeader);
                if (!matcher.matches()) continue;
                csvHeader.sTypeName = TypeDesc.types[j].sTypeName;
                csvHeader.nType = TypeDesc.types[j].nType;
                csvHeader.bTimeZone = csvHeader.sTypeName.endsWith(" WITH TIME ZONE");
                if (matcher.group(2) != null) {
                    csvHeader.nScale = Integer.parseInt(matcher.group(2));
                    continue block0;
                }
                if (matcher.group(1) == null) continue block0;
                csvHeader.nScale = Integer.parseInt(matcher.group(1));
                continue block0;
            }
        }
        return csvHeaderArray;
    }

    private static String[] readCsvRow(PeekReader peekReader) throws IOException {
        if (peekReader.peek() < 0) {
            return null;
        }
        StringList stringList = new StringList();
        stringList.add(null);
        boolean bl = false;
        int n;
        while ((n = peekReader.read()) >= 0) {
            if (bl) {
                if (n != 34) {
                    stringList.append(n);
                    continue;
                }
                if (peekReader.peek() == 34) {
                    stringList.append(peekReader.read());
                    continue;
                }
                bl = false;
                continue;
            }
            if (n == 44) {
                stringList.add(null);
                continue;
            }
            if (n == 34) {
                bl = true;
                continue;
            }
            if (n == 13) continue;
            if (n == 10) {
                return stringList.toStringArray();
            }
            stringList.append(n);
        }
        return stringList.toStringArray();
    }

    private static void bindValue(PreparedStatement preparedStatement, int n, int n2, CsvHeader csvHeader, String string) {
        try {
            if (csvHeader.nType == -6) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setByte(n2, Byte.parseByte(string));
                }
            } else if (csvHeader.nType == 5) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setShort(n2, Short.parseShort(string));
                }
            } else if (csvHeader.nType == 4) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setInt(n2, Integer.parseInt(string));
                }
            } else if (csvHeader.nType == -5) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setLong(n2, Long.parseLong(string));
                }
            } else if (csvHeader.nType == 6) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setDouble(n2, Double.parseDouble(string));
                }
            } else if (csvHeader.nType == 3) {
                preparedStatement.setObject(n2, (Object)(string == null ? null : new BigDecimal(string)), csvHeader.nType, csvHeader.nScale);
            } else if (csvHeader.nType == 2) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setBigDecimal(n2, new BigDecimal(string));
                }
            } else if (csvHeader.nType == 2005) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setCharacterStream(n2, (Reader)new StringReader(string), string.length());
                }
            } else if (csvHeader.nType == 2004) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    byte[] byArray = TeraDriver.parseHexDigits(string);
                    preparedStatement.setBinaryStream(n2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                }
            } else if (csvHeader.nType == -2) {
                preparedStatement.setObject(n2, (Object)TeraDriver.parseHexDigits(string), csvHeader.nType, csvHeader.nScale);
            } else if (csvHeader.nType == -3 || csvHeader.nType == -4) {
                preparedStatement.setBytes(n2, TeraDriver.parseHexDigits(string));
            } else if (csvHeader.nType == 91) {
                preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
            } else if (csvHeader.nType == 92) {
                if (string == null && csvHeader.bTimeZone) {
                    preparedStatement.setTime(n2, null, DUMMY_CALENDAR);
                } else {
                    preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
                }
            } else if (csvHeader.nType == 93) {
                if (string == null && csvHeader.bTimeZone) {
                    preparedStatement.setTimestamp(n2, null, DUMMY_CALENDAR);
                } else {
                    preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
                }
            } else {
                preparedStatement.setString(n2, string);
            }
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error for CSV line " + n + " column " + n2 + " value: " + string);
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    private static <T> T safePeek(Stack<T> stack) {
        return stack.empty() ? null : (T)stack.peek();
    }

    private static <T> void pushDiff(Stack<T> stack, T t) {
        if (t != TeraDriver.safePeek(stack)) {
            stack.push(t);
        }
    }

    private static <T extends Closeable> void popClose(Stack<T> stack, T t) throws IOException {
        Closeable closeable = (Closeable)stack.pop();
        if (closeable != t) {
            closeable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static void main(String[] var0) throws Throwable {
        block221: {
            if (var0.length == 0) {
                System.err.println("Arguments: Command...");
                System.err.println("-i turns on interactive mode to prompt for commands from System.in");
                System.err.println("-im turns on interactive mode and sql:multi");
                System.err.println("-is turns on interactive mode and sql:semicolon");
                System.err.println("# begins a comment");
                System.err.println("agkr:generated returns generated keys");
                System.err.println("agkr:index,index,... returns the inserted column values corresponding to the specific column indexes");
                System.err.println("agkr:none (the default) does not use the Auto-Generated Key Retrieval feature");
                System.err.println("autocommit:off turns off autocommit");
                System.err.println("autocommit:on turns on autocommit");
                System.err.println("commit calls Connection.commit");
                System.err.println("cont:message sets the continuation prompt to the specified message");
                System.err.println("csvline:string appends comma-separated values from the specified string for use by a subsequent parameterized SQL request");
                System.err.println("driver prints the driver name and version");
                System.err.println("echo:message prints the specified message");
                System.err.println("exit stops reading commands from the current input source");
                System.err.println("format:csv formats output as comma-separated values");
                System.err.println("format:raw avoids formatting output");
                System.err.println("format:text (the default) formats output as text");
                System.err.println("getCatalogs prints the result from DatabaseMetaData.getCatalogs");
                System.err.println("getColumns:catalog,schemaPattern,tableNamePattern,columnNamePattern prints the result from DatabaseMetaData.getColumns");
                System.err.println("getDatabaseProductVersion prints the return value from DatabaseMetaData.getDatabaseProductVersion");
                System.err.println("getDriverVersion prints the return value from DatabaseMetaData.getDriverVersion");
                System.err.println("getSchemas prints the result from DatabaseMetaData.getSchemas");
                System.err.println("getTables:catalog,schemaPattern,tableNamePattern[,tableType]... prints the result from DatabaseMetaData.getTables");
                System.err.println("getURL prints the return value from DatabaseMetaData.getURL");
                System.err.println("host= prefix begins an ignored Python driver connection string");
                System.err.println("http-header:value adds an HTTP header for the next HTTP request");
                System.err.println("http-method:value overrides the default HTTP GET method to specify the HTTP method for the next HTTP request");
                System.err.println("http-params:name=value,name=value,... specifies driver connection parameters for the next HTTP request");
                System.err.println("http://... makes an HTTP request to the specified URL");
                System.err.println("https://... makes an HTTPS request to the specified URL");
                System.err.println("ignore:nsql:all ignores all non-SQLException");
                System.err.println("ignore:nsql:none (the default) stops for any non-SQLException");
                System.err.println("ignore:sql:all ignores all SQLException");
                System.err.println("ignore:sql:code,code,... ignores SQLException with one of the specified error codes");
                System.err.println("ignore:sql:none stops for any SQLException");
                System.err.println("input:filename reads commands from the specified file until EOF");
                System.err.println("input:stdin reads commands from System.in until EOF (interactive Ctrl+Z on Windows)");
                System.err.println("jdbc: prefix calls DriverManager.getConnection for the command");
                System.err.println("lsof prints the open file handles of the JVM on Linux");
                System.err.println("nativeSQL:command calls Connection.nativeSQL for the command");
                System.err.println("output:filename sends output to specified file");
                System.err.println("output:stdout (the default) sends output to System.out");
                System.err.println("pause waits for a line from System.in");
                System.err.println("pid prints the process ID of the JVM");
                System.err.println("prompt:message sets the prompt to the specified message");
                System.err.println("prop:name=value sets the property name to value for DriverManager.getConnection");
                System.err.println("props:filename reads Properties from the specified file for DriverManager.getConnection");
                System.err.println("props:list prints the Properties for DriverManager.getConnection");
                System.err.println("props:new specifies new empty Properties for DriverManager.getConnection");
                System.err.println("props:null (the default) specifies null Properties for DriverManager.getConnection");
                System.err.println("random:b64:count prints a base64 encoded string of the specified number of random bytes");
                System.err.println("random:b64u:count prints a base64 URL encoded string of the specified number of random bytes");
                System.err.println("random:hex:count prints a hex-format string of the specified number of random bytes");
                System.err.println("readcsv:filename reads comma-separated values from the specified UTF8-encoded file for use by a subsequent parameterized SQL request");
                System.err.println("rollback calls Connection.rollback");
                System.err.println("rsmd:all prints all result set column metadata");
                System.err.println("rsmd:function,function,... prints only the result set column metadata returned from the specified ResultSetMetaData functions");
                System.err.println("rsmd:none (the default) does not print result set column metadata");
                System.err.println("Security.getProperty:name prints the specified Security property");
                System.err.println("Security.getProviders prints the list of Security providers");
                System.err.println("Security.setProperty:name=value sets the Security property name to value");
                System.err.println("sleep:ms sleeps for the specified number of milliseconds");
                System.err.println("sql:multi accepts multiple arguments or input lines as a SQL request up to an empty argument or input line");
                System.err.println("sql:semicolon accepts multiple arguments or input lines as a SQL request up to an argument or input line ending with a semicolon");
                System.err.println("sql:single (the default) accepts a single argument or input line as a SQL request");
                System.err.println("System.getProperties prints the Properties from System.getProperties");
                System.err.println("System.getProperty:name prints the specified System property");
                System.err.println("System.setProperty:name=value sets the System property name to value");
                System.err.println("time prints the current date and time");
                System.err.println("verbose:connection (the default) and verbose:-connection control printing connection status");
                System.err.println("verbose:csvtypes and verbose:-csvtypes (the default) control printing data types in CSV header");
                System.err.println("verbose:dbmd and verbose:-dbmd (the default) control printing arguments before calling DatabaseMetaData methods");
                System.err.println("verbose:sleep (the default) and verbose:-sleep control printing sleep status");
                System.err.println("verbose:sql and verbose:-sql (the default) control printing the SQL request before executing");
                System.err.println("verbose:stack and verbose:-stack (the default) control printing SQLException stack traces");
                System.err.println("verbose:transaction and verbose:-transaction (the default) control printing transaction commands");
                System.err.println("verbose:updatecounts and verbose:-updatecounts (the default) control printing update counts after executing");
                System.err.println("version prints the Teradata JDBC Driver version");
                System.err.println("Otherwise the SQL request is executed, using parameter values if previously specified");
                return;
            }
            var1_1 = 1;
            var2_2 = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            var3_3 = new Stack<E>();
            try {
                var5_5 = var4_4 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
                try {
                    var6_6 = null;
                    try {
                        var7_7 = null;
                        var11_8 = 3;
                        var12_9 = null;
                        var13_10 = null;
                        var14_11 = null;
                        var15_12 = "GET";
                        var16_13 = new StringList();
                        var17_14 = new URLParameters("");
                        var18_15 = null;
                        var19_16 = false;
                        var20_17 = null;
                        var21_18 = new Integer(2);
                        var22_19 = true;
                        var23_20 = false;
                        var24_21 = true;
                        var25_22 = false;
                        var26_23 = false;
                        var27_24 = false;
                        var28_25 = false;
                        var29_26 = false;
                        var30_27 = new LinkedHashMap<String, Boolean>();
                        var30_27.put("getCatalogName", false);
                        var30_27.put("getColumnClassName", false);
                        var30_27.put("getColumnDisplaySize", false);
                        var30_27.put("getColumnLabel", false);
                        var30_27.put("getColumnName", false);
                        var30_27.put("getColumnType", false);
                        var30_27.put("getColumnTypeName", false);
                        var30_27.put("getPrecision", false);
                        var30_27.put("getScale", false);
                        var30_27.put("getSchemaName", false);
                        var30_27.put("getTableName", false);
                        var30_27.put("isAutoIncrement", false);
                        var30_27.put("isCaseSensitive", false);
                        var30_27.put("isCurrency", false);
                        var30_27.put("isDefinitelyWritable", false);
                        var30_27.put("isNullable", false);
                        var30_27.put("isReadOnly", false);
                        var30_27.put("isSearchable", false);
                        var30_27.put("isSigned", false);
                        var30_27.put("isWritable", false);
                        var31_28 = 0;
                        while (true) lbl-1000:
                        // 105 sources

                        {
                            var32_29 = null;
                            if (TeraDriver.safePeek(var3_3) == var2_2) {
                                if (var12_9 != null && var13_10 != null) {
                                    var4_4.print(var13_10);
                                } else if (var12_9 == null && var14_11 != null) {
                                    var4_4.print(var14_11);
                                }
                                var4_4.flush();
                            }
                            while (var32_29 == null && TeraDriver.safePeek(var3_3) != null) {
                                var32_29 = ((BufferedReader)TeraDriver.safePeek(var3_3)).readLine();
                                if (var32_29 != null) continue;
                                TeraDriver.popClose(var3_3, var2_2);
                            }
                            if (var32_29 == null && var31_28 < var0.length) {
                                var32_29 = var0[var31_28++];
                            }
                            var33_30 = false;
                            if (var12_9 != null) {
                                if (var32_29 == null) {
                                    var32_29 = var12_9;
                                    var12_9 = null;
                                    var33_30 = true;
                                } else if (var11_8 == 1 && var32_29.equals("")) {
                                    var32_29 = var12_9;
                                    var12_9 = null;
                                    var33_30 = true;
                                } else if (var11_8 == 2 && var32_29.endsWith(";")) {
                                    var32_29 = var12_9 + " " + var32_29;
                                    var12_9 = null;
                                    var33_30 = true;
                                } else {
                                    var12_9 = var12_9 + " " + var32_29;
                                    continue;
                                }
                            }
                            if (var32_29 == null) {
                                break block221;
                            }
                            try {
                                if (var32_29.equals("")) ** GOTO lbl-1000
                                if (var32_29.equals("-i") || var32_29.equals("-im") || var32_29.equals("-is")) {
                                    TeraDriver.pushDiff(var3_3, var2_2);
                                    var14_11 = ">>> ";
                                    var13_10 = "... ";
                                    var19_16 = true;
                                    var20_17 = new int[]{};
                                    if (var32_29.equals("-im")) {
                                        var11_8 = 1;
                                    }
                                    if (!var32_29.equals("-is")) ** GOTO lbl-1000
                                    var11_8 = 2;
                                }
                                if (var32_29.equals("sql:multi")) {
                                    var11_8 = 1;
                                }
                                if (var32_29.equals("sql:semicolon")) {
                                    var11_8 = 2;
                                }
                                if (var32_29.equals("sql:single")) {
                                    var11_8 = 3;
                                }
                                if (var32_29.startsWith("cont:")) {
                                    var13_10 = var32_29.substring("cont:".length());
                                }
                                if (var32_29.startsWith("prompt:")) {
                                    var14_11 = var32_29.substring("prompt:".length());
                                }
                                if (var32_29.equals("exit")) {
                                    if (var3_3.size() <= 0) ** GOTO lbl-1000
                                    TeraDriver.popClose(var3_3, var2_2);
                                }
                                if (var32_29.startsWith("#")) ** GOTO lbl-1000
                                if (var32_29.equals("time")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var32_29, new Timestamp(System.currentTimeMillis()).toString());
                                }
                                if (var32_29.equals("verbose:sleep")) {
                                    var24_21 = true;
                                }
                                if (var32_29.equals("verbose:-sleep")) {
                                    var24_21 = false;
                                }
                                if (var32_29.startsWith("sleep:")) {
                                    var34_31 = Long.parseLong(var32_29.substring("sleep:".length()));
                                    if (var24_21) {
                                        var5_5.println("Sleeping for " + var34_31 + " ms");
                                    }
                                    try {
                                        Thread.sleep(var34_31);
                                    }
                                    catch (InterruptedException var36_60) {
                                        // empty catch block
                                    }
                                    if (!var24_21) ** GOTO lbl-1000
                                    var5_5.println("Done sleeping for " + var34_31 + " ms");
                                }
                                if (var32_29.equals("driver")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var32_29, "Teradata JDBC Driver " + Const.DRIVER_VERSION);
                                }
                                if (var32_29.equals("version")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var32_29, Const.DRIVER_VERSION);
                                }
                                if (var32_29.equals("pid")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var32_29, ClientAttributesParcel.getJVMProcessID());
                                }
                                if (var32_29.equals("lsof")) {
                                    var34_32 = new File("/proc/self/fd").listFiles();
                                    if (var34_32 == null) {
                                        throw new IOException("/proc file system is not available");
                                    }
                                    var35_41 = new ArrayList<File>(Arrays.asList(var34_32));
                                    var34_32 = new File("/proc/self/map_files").listFiles();
                                    if (var34_32 != null) {
                                        var35_41.addAll(Arrays.asList(var34_32));
                                    }
                                    var36_61 = new LinkedHashMap<String, String>();
                                    for (String[][] var38_79 : var35_41) {
                                        var39_84 = var38_79.getName();
                                        var40_87 = null;
                                        try {
                                            var40_87 = Files.readSymbolicLink(var38_79.toPath()).toString();
                                        }
                                        catch (Throwable var41_90) {
                                            // empty catch block
                                        }
                                        if (var40_87 == null) continue;
                                        var41_91 = var39_84.indexOf(45);
                                        v0 = var42_93 = var41_91 >= 0;
                                        if (var42_93) {
                                            var39_84 = "mem-" + var39_84.substring(0, var41_91);
                                        }
                                        if (var43_96 = var42_93 != false && var36_61.containsValue(var40_87) != false) continue;
                                        var36_61.put(var39_84, (String)var40_87);
                                    }
                                    var37_72 = var36_61.entrySet().toArray(new Map.Entry[0]);
                                    var38_79 = new String[][]{new String[var37_72.length], new String[var37_72.length]};
                                    for (var39_83 = 0; var39_83 < var37_72.length; ++var39_83) {
                                        var38_79[0][var39_83] = (String)var37_72[var39_83].getKey();
                                        var38_79[1][var39_83] = (String)var37_72[var39_83].getValue();
                                    }
                                    if (var1_1 == 1) {
                                        var5_5.println("(Open files " + var37_72.length + ")");
                                    }
                                    TeraDriver.printArray(var5_5, var1_1, true, var38_79);
                                }
                                if (var32_29.startsWith("echo:")) {
                                    var34_32 = var32_29.substring("echo:".length());
                                    var5_5.println((String)var34_32);
                                }
                                if (var32_29.equals("pause")) {
                                    var5_5.println("Paused. Press Enter to continue:");
                                    var2_2.readLine();
                                }
                                if (var32_29.startsWith("prop:")) {
                                    var34_32 = Pattern.compile("prop:([^=]+)=(.*)").matcher(var32_29);
                                    if (!var34_32.matches()) {
                                        throw new IllegalArgumentException(var32_29);
                                    }
                                    if (var18_15 == null) {
                                        var18_15 = new Properties();
                                    }
                                    var18_15.setProperty(var34_32.group(1), var34_32.group(2));
                                }
                                if (var32_29.startsWith("props:")) {
                                    var34_32 = var32_29.substring("props:".length());
                                    if (var34_32.equals("null")) {
                                        var18_15 = null;
                                    }
                                    if (var34_32.equals("new")) {
                                        var18_15 = new Properties();
                                    }
                                    if (var34_32.equals("list")) {
                                        TeraDriver.printProps(var5_5, var1_1, var18_15);
                                    }
                                    var18_15 = new Properties();
                                    var35_42 = new FileInputStream((String)var34_32);
                                    try {
                                        var18_15.load(var35_42);
                                    }
                                    finally {
                                        var35_42.close();
                                    }
                                }
                                if (var32_29.equals("verbose:connection")) {
                                    var22_19 = true;
                                }
                                if (var32_29.equals("verbose:-connection")) {
                                    var22_19 = false;
                                }
                                if (var32_29.startsWith("host=")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "Ignored", var32_29);
                                }
                                if (var32_29.startsWith("jdbc:")) {
                                    if (var6_6 != null) {
                                        var34_32 = var6_6;
                                        var6_6 = null;
                                        var34_32.close();
                                    }
                                    var6_6 = DriverManager.getConnection(var32_29, var18_15);
                                    if (!var22_19) ** GOTO lbl-1000
                                    TeraDriver.printArray(var5_5, var1_1, false, new String[][]{{"Status", "Remote", "Version", "Session"}, {var6_6.isClosed() != false ? "Closed" : "Connected", var6_6.nativeSQL("{fn teradata_provide(remote_address)}:{fn teradata_provide(remote_port)}"), var6_6.getMetaData().getDatabaseProductVersion(), var6_6.isClosed() != false ? null : var6_6.nativeSQL("{fn teradata_session_number}")}});
                                }
                                if (var32_29.startsWith("input:")) {
                                    var34_32 = var32_29.substring("input:".length());
                                    TeraDriver.pushDiff(var3_3, var34_32.equals("stdin") != false ? var2_2 : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((String)var34_32), "UTF-8")));
                                }
                                if (var32_29.startsWith("output:")) {
                                    var34_32 = var32_29.substring("output:".length());
                                    if (var5_5 != var4_4) {
                                        var5_5.close();
                                    }
                                    var5_5 = var4_4;
                                    if (var34_32.equals("stdout")) ** GOTO lbl-1000
                                    var5_5 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((String)var34_32), "UTF-8"), true);
                                }
                                if (var32_29.startsWith("format:")) {
                                    var34_32 = var32_29.substring("format:".length());
                                    if (var34_32.equals("text")) {
                                        var1_1 = 1;
                                    }
                                    if (var34_32.equals("raw")) {
                                        var1_1 = 2;
                                    }
                                    if (var34_32.equals("csv")) {
                                        var1_1 = 3;
                                    }
                                    throw new IllegalArgumentException("Unknown format " + (String)var34_32);
                                }
                                if (var32_29.equals("ignore:nsql:all")) {
                                    var19_16 = true;
                                }
                                if (var32_29.equals("ignore:nsql:none")) {
                                    var19_16 = false;
                                }
                                if (var32_29.equals("ignore:sql:all")) {
                                    var20_17 = new int[]{};
                                }
                                if (var32_29.equals("ignore:sql:none")) {
                                    var20_17 = null;
                                }
                                if (var32_29.startsWith("ignore:sql:")) {
                                    var34_32 = var32_29.substring("ignore:sql:".length());
                                    var35_43 = var34_32.split(",");
                                    if (var35_43.length == 0) {
                                        throw new IllegalArgumentException(var32_29);
                                    }
                                    var20_17 = new int[var35_43.length];
                                    var36_62 = 0;
                                    while (true) {
                                        if (var36_62 >= var35_43.length) ** GOTO lbl-1000
                                        var20_17[var36_62] = Integer.parseInt(var35_43[var36_62]);
                                        ++var36_62;
                                    }
                                }
                                if (var32_29.startsWith("System.setProperty:")) {
                                    var34_32 = Pattern.compile("System\\.setProperty:([^=]+)=(.*)").matcher(var32_29);
                                    if (!var34_32.matches()) {
                                        throw new IllegalArgumentException(var32_29);
                                    }
                                    System.setProperty(var34_32.group(1), var34_32.group(2));
                                }
                                if (var32_29.startsWith("System.getProperty:")) {
                                    var34_32 = var32_29.substring("System.getProperty:".length());
                                    TeraDriver.printNameValue(var5_5, var1_1, (String)var34_32, System.getProperty((String)var34_32));
                                }
                                if (var32_29.equals("System.getProperties")) {
                                    TeraDriver.printProps(var5_5, var1_1, System.getProperties());
                                }
                                if (var32_29.startsWith("Security.setProperty:")) {
                                    var34_32 = Pattern.compile("Security\\.setProperty:([^=]+)=(.*)").matcher(var32_29);
                                    if (!var34_32.matches()) {
                                        throw new IllegalArgumentException(var32_29);
                                    }
                                    Security.setProperty(var34_32.group(1), var34_32.group(2));
                                }
                                if (var32_29.startsWith("Security.getProperty:")) {
                                    var34_32 = var32_29.substring("Security.getProperty:".length());
                                    TeraDriver.printNameValue(var5_5, var1_1, (String)var34_32, Security.getProperty((String)var34_32));
                                }
                                if (var32_29.equals("Security.getProviders")) {
                                    var34_32 = Security.getProviders();
                                    var35_44 = new String[][]{new String[((Object)var34_32).length], new String[((Object)var34_32).length]};
                                    for (var36_63 = 0; var36_63 < ((Object)var34_32).length; ++var36_63) {
                                        var35_44[0][var36_63] = String.valueOf(var34_32[var36_63]);
                                        var35_44[1][var36_63] = var34_32[var36_63].getInfo();
                                    }
                                    if (var1_1 == 1) {
                                        var5_5.println("(Providers " + ((Object)var34_32).length + ")");
                                    }
                                    TeraDriver.printArray(var5_5, var1_1, true, var35_44);
                                }
                                if (var32_29.startsWith("random:b64:") || var32_29.startsWith("random:b64u:") || var32_29.startsWith("random:hex:")) {
                                    var34_32 = var32_29.split(":", 3);
                                    var35_45 = Utility.getRandomBytes(Integer.parseInt((String)var34_32[2]));
                                    TeraDriver.printNameValue(var5_5, var1_1, var32_29, var34_32[1].equals("hex") != false ? Utility.formatByteArrayAsHexDigits(var35_45) : Utility.base64Encode(var34_32[1].equals("b64u"), var35_45));
                                }
                                if (var32_29.startsWith("http-method:")) {
                                    var15_12 = var32_29.substring("http-method:".length()).trim().toUpperCase();
                                }
                                if (var32_29.startsWith("http-header:")) {
                                    var16_13.add(var32_29.substring("http-header:".length()));
                                }
                                if (var32_29.startsWith("http-params:")) {
                                    var17_14 = new URLParameters(var32_29.substring("http-params:".length()));
                                    TeraDriver.sm_log.setLogLevel(var17_14.getLogLevel());
                                }
                                if (var32_29.startsWith("http:") || var32_29.startsWith("https:")) {
                                    var34_32 = var15_12;
                                    var15_12 = "GET";
                                    var35_46 = var16_13.isEmpty() != false ? null : var16_13.toStringArray();
                                    var16_13.clear();
                                    var36_64 = Utility.doHttpRequest(var17_14, TeraDriver.sm_log, (String)var34_32, var32_29, var35_46, null, false, null);
                                    TeraDriver.printNameValue(var5_5, var1_1, "Code", "" + var36_64.nCode);
                                    TeraDriver.printNameValue(var5_5, var1_1, "Message", var36_64.sMessage);
                                    TeraDriver.printNameValue(var5_5, var1_1, "Body", var36_64.sBody);
                                }
                                if (var32_29.equals("verbose:dbmd")) {
                                    var23_20 = true;
                                }
                                if (var32_29.equals("verbose:-dbmd")) {
                                    var23_20 = false;
                                }
                                if (var32_29.equals("verbose:sql")) {
                                    var25_22 = true;
                                }
                                if (var32_29.equals("verbose:-sql")) {
                                    var25_22 = false;
                                }
                                if (var32_29.equals("rsmd:all")) {
                                    var34_32 = var30_27.keySet().iterator();
                                    while (true) {
                                        if (!var34_32.hasNext()) ** GOTO lbl-1000
                                        var35_47 = (String)var34_32.next();
                                        var30_27.put(var35_47, true);
                                    }
                                }
                                if (var32_29.equals("rsmd:none")) {
                                    var34_32 = var30_27.keySet().iterator();
                                    while (true) {
                                        if (!var34_32.hasNext()) ** GOTO lbl-1000
                                        var35_48 = (String)var34_32.next();
                                        var30_27.put(var35_48, false);
                                    }
                                }
                                if (var32_29.startsWith("rsmd:")) {
                                    var34_32 = var32_29.substring("rsmd:".length()).split(",");
                                    if (((Object)var34_32).length == 0) {
                                        throw new IllegalArgumentException(var32_29);
                                    }
                                    for (String var36_65 : var30_27.keySet()) {
                                        var30_27.put(var36_65, false);
                                    }
                                    var35_49 = var34_32;
                                    var36_66 = ((Object)var35_49).length;
                                    var37_73 = 0;
                                    while (true) {
                                        if (var37_73 >= var36_66) ** GOTO lbl-1000
                                        var38_80 = var35_49[var37_73];
                                        if (!var30_27.containsKey(var38_80)) {
                                            throw new IllegalArgumentException((String)var38_80);
                                        }
                                        var30_27.put((String)var38_80, true);
                                        ++var37_73;
                                    }
                                }
                                if (var32_29.equals("verbose:csvtypes")) {
                                    var26_23 = true;
                                }
                                if (var32_29.equals("verbose:-csvtypes")) {
                                    var26_23 = false;
                                }
                                if (var32_29.equals("verbose:updatecounts")) {
                                    var27_24 = true;
                                }
                                if (var32_29.equals("verbose:-updatecounts")) {
                                    var27_24 = false;
                                }
                                if (var32_29.equals("verbose:stack")) {
                                    var28_25 = true;
                                }
                                if (var32_29.equals("verbose:-stack")) {
                                    var28_25 = false;
                                }
                                if (var32_29.equals("verbose:transaction")) {
                                    var29_26 = true;
                                }
                                if (var32_29.equals("verbose:-transaction")) {
                                    var29_26 = false;
                                }
                                if (var32_29.equals("agkr:none")) {
                                    var21_18 = new Integer(2);
                                }
                                if (var32_29.equals("agkr:generated")) {
                                    var21_18 = new Integer(1);
                                }
                                if (var32_29.startsWith("agkr:")) {
                                    var34_32 = var32_29.substring("agkr:".length());
                                    var35_50 = var34_32.split(",");
                                    if (var35_50.length == 0) {
                                        throw new IllegalArgumentException(var32_29);
                                    }
                                    var36_67 = new int[var35_50.length];
                                    var21_18 = var36_67;
                                    var37_74 = 0;
                                    while (true) {
                                        if (var37_74 >= var35_50.length) ** GOTO lbl-1000
                                        var36_67[var37_74] = Integer.parseInt(var35_50[var37_74]);
                                        ++var37_74;
                                    }
                                }
                                if (var32_29.startsWith("csvline:")) {
                                    var34_32 = var32_29.substring("csvline:".length()) + "\n";
                                    var35_51 = new ByteArrayInputStream(var34_32.getBytes("UTF-8"));
                                    var7_7 = var7_7 == null ? var35_51 : new SequenceInputStream(var7_7, var35_51);
                                }
                                if (var32_29.startsWith("readcsv:")) {
                                    var34_32 = var32_29.substring("readcsv:".length());
                                    var35_52 = new FileInputStream((String)var34_32);
                                    var7_7 = var7_7 == null ? var35_52 : new SequenceInputStream(var7_7, var35_52);
                                }
                                if (var6_6 == null) {
                                    throw new IllegalArgumentException("No connection available for " + var32_29);
                                }
                                if (var32_29.equals("autocommit:off")) {
                                    if (var29_26) {
                                        var5_5.println(var32_29);
                                    }
                                    var6_6.setAutoCommit(false);
                                }
                                if (var32_29.equals("autocommit:on")) {
                                    if (var29_26) {
                                        var5_5.println(var32_29);
                                    }
                                    var6_6.setAutoCommit(true);
                                }
                                if (var32_29.equals("commit")) {
                                    if (var29_26) {
                                        var5_5.println(var32_29);
                                    }
                                    var6_6.commit();
                                }
                                if (var32_29.equals("rollback")) {
                                    if (var29_26) {
                                        var5_5.println(var32_29);
                                    }
                                    var6_6.rollback();
                                }
                                if (var32_29.equals("getCatalogs")) {
                                    var34_33 = var6_6.getMetaData().getCatalogs();
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var30_27, var26_23, "getCatalogs", var34_33);
                                    }
                                    finally {
                                        var34_33.close();
                                    }
                                }
                                if (var32_29.equals("getSchemas")) {
                                    var34_34 = var6_6.getMetaData().getSchemas();
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var30_27, var26_23, "getSchemas", var34_34);
                                    }
                                    finally {
                                        var34_34.close();
                                    }
                                }
                                if (var32_29.startsWith("getTables:")) {
                                    var34_35 = var32_29.substring("getTables:".length()).split(",", -1);
                                    if (var34_35.length < 3) {
                                        throw new IllegalArgumentException("Invalid arguments for " + var32_29);
                                    }
                                    for (var35_53 = 0; var35_53 < var34_35.length; ++var35_53) {
                                        if (!"null".equals(var34_35[var35_53])) continue;
                                        var34_35[var35_53] = null;
                                    }
                                    v1 = var35_54 = var34_35.length <= 3 ? null : Arrays.copyOfRange(var34_35, 3, var34_35.length);
                                    if (var23_20) {
                                        TeraDriver.printArray(var5_5, var1_1, false, new String[][]{{"getTables catalog", "getTables schemaPattern", "getTables tableNamePattern", "getTables tableTypes"}, {var34_35[0], var34_35[1], var34_35[2], var35_54 == null ? null : Arrays.toString(var35_54)}});
                                    }
                                    var36_68 = var6_6.getMetaData().getTables(var34_35[0], var34_35[1], var34_35[2], (String[])var35_54);
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var30_27, var26_23, "getTables", var36_68);
                                    }
                                    finally {
                                        var36_68.close();
                                    }
                                }
                                if (var32_29.startsWith("getColumns:")) {
                                    var34_36 = var32_29.substring("getColumns:".length()).split(",", -1);
                                    if (var34_36.length != 4) {
                                        throw new IllegalArgumentException("Invalid arguments for " + var32_29);
                                    }
                                    for (var35_55 = 0; var35_55 < var34_36.length; ++var35_55) {
                                        if (!"null".equals(var34_36[var35_55])) continue;
                                        var34_36[var35_55] = null;
                                    }
                                    if (var23_20) {
                                        TeraDriver.printArray(var5_5, var1_1, false, new String[][]{{"getColumns catalog", "getColumns schemaPattern", "getColumns tableNamePattern", "getColumns columnNamePattern"}, {var34_36[0], var34_36[1], var34_36[2], var34_36[3]}});
                                    }
                                    var35_56 = var6_6.getMetaData().getColumns(var34_36[0], var34_36[1], var34_36[2], var34_36[3]);
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var30_27, var26_23, "getColumns", var35_56);
                                    }
                                    finally {
                                        var35_56.close();
                                    }
                                }
                                if (var32_29.equals("getDatabaseProductVersion")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var32_29, var6_6.getMetaData().getDatabaseProductVersion());
                                }
                                if (var32_29.equals("getDriverVersion")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var32_29, var6_6.getMetaData().getDriverVersion());
                                }
                                if (var32_29.equals("getURL")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var32_29, var6_6.getMetaData().getURL());
                                }
                                if (var32_29.startsWith("nativeSQL:")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "nativeSQL", var6_6.nativeSQL(var32_29.substring("nativeSQL:".length())));
                                }
                                if (var11_8 == 1 && !var33_30) {
                                    var12_9 = var32_29;
                                }
                                if (var11_8 == 2 && !var33_30 && !var32_29.endsWith(";")) {
                                    var12_9 = var32_29;
                                }
                                if (var7_7 != null) {
                                    try {
                                        var34_37 = new PeekReader(new InputStreamReader(var7_7, "UTF-8"));
                                        try {
                                            var35_57 = TeraDriver.readCsvRow(var34_37);
                                            if (var35_57 == null) {
                                                throw new IllegalArgumentException("CSV header line is missing and no CSV data lines are available");
                                            }
                                            var36_69 = TeraDriver.parseCsvHeaders(var35_57);
                                            if (var25_22) {
                                                var5_5.println(var32_29);
                                            }
                                            var37_75 = var21_18 instanceof int[] != false ? var6_6.prepareStatement(var32_29, (int[])var21_18) : var6_6.prepareStatement(var32_29, (Integer)var21_18);
                                            try {
                                                var38_81 = 0;
                                                while (true) {
                                                    if ((var39_85 = TeraDriver.readCsvRow(var34_37)) == null && var38_81 >= 2 || var39_85 != null && var38_81 >= 1) {
                                                        var37_75.addBatch();
                                                    }
                                                    if (var39_85 == null) break;
                                                    if (var39_85.length != var36_69.length) {
                                                        throw new IllegalArgumentException("CSV data line " + var34_37.lineNumber + " contains " + var39_85.length + " values instead of the expected " + var36_69.length + " values");
                                                    }
                                                    for (var40_89 = 0; var40_89 < var39_85.length; ++var40_89) {
                                                        TeraDriver.bindValue(var37_75, var34_37.lineNumber, var40_89 + 1, var36_69[var40_89], var39_85[var40_89]);
                                                    }
                                                    ++var38_81;
                                                }
                                                var39_83 = 0;
                                                var40_87 = null;
                                                if (var38_81 >= 2) {
                                                    var40_87 = var37_75.executeBatch();
                                                } else {
                                                    var39_83 = (int)var37_75.execute();
                                                }
                                                var41_92 = 1;
                                                while (true) {
                                                    if (var27_24) {
                                                        if (var38_81 >= 2) {
                                                            TeraDriver.printUpdateCounts(var5_5, var1_1, (int[])var40_87);
                                                        } else if (var39_83 == 0) {
                                                            TeraDriver.printNameValue(var5_5, var1_1, "Update count", "" + var37_75.getUpdateCount());
                                                        }
                                                    }
                                                    if (var39_83 != 0) {
                                                        var42_94 = var37_75.getResultSet();
                                                        try {
                                                            TeraDriver.printResultSet(var5_5, var1_1, var30_27, var26_23, "Result " + var41_92, var42_94);
                                                        }
                                                        finally {
                                                            var42_94.close();
                                                        }
                                                    }
                                                    var42_94 = var37_75.getGeneratedKeys();
                                                    try {
                                                        TeraDriver.printResultSet(var5_5, var1_1, var30_27, var26_23, var21_18 instanceof int[] != false ? "Inserted" : "Generated", var42_94);
                                                    }
                                                    finally {
                                                        var42_94.close();
                                                    }
                                                    if (var38_81 >= 2) ** GOTO lbl-1000
                                                    var39_83 = (int)var37_75.getMoreResults();
                                                    v2 = var42_95 = var39_83 != 0 || var37_75.getUpdateCount() != -1;
                                                    if (!var42_95) ** GOTO lbl-1000
                                                    ++var41_92;
                                                }
                                            }
                                            finally {
                                                var37_75.close();
                                            }
                                        }
                                        finally {
                                            var34_37.close();
                                        }
                                    }
                                    finally {
                                        var7_7 = null;
                                    }
                                }
                                var34_38 = var6_6.createStatement();
                                try {
                                    if (var25_22) {
                                        var5_5.println(var32_29);
                                    }
                                    var35_58 = var21_18 instanceof int[] != false ? var34_38.execute(var32_29, (int[])var21_18) : var34_38.execute(var32_29, (Integer)var21_18);
                                    var36_70 = 1;
                                    while (true) {
                                        if (!var35_58 && var34_38.getUpdateCount() == -1) ** GOTO lbl-1000
                                        if (var35_58) {
                                            var37_76 = var34_38.getResultSet();
                                            try {
                                                TeraDriver.printResultSet(var5_5, var1_1, var30_27, var26_23, "Result " + var36_70, var37_76);
                                            }
                                            finally {
                                                var37_76.close();
                                            }
                                        }
                                        if (var27_24) {
                                            TeraDriver.printNameValue(var5_5, var1_1, "Update count", "" + var34_38.getUpdateCount());
                                        }
                                        var37_76 = var34_38.getGeneratedKeys();
                                        try {
                                            TeraDriver.printResultSet(var5_5, var1_1, var30_27, var26_23, var21_18 instanceof int[] != false ? "Inserted" : "Generated", var37_76);
                                        }
                                        finally {
                                            var37_76.close();
                                        }
                                        var35_58 = var34_38.getMoreResults();
                                        ++var36_70;
                                    }
                                }
                                finally {
                                    var34_38.close();
                                }
                            }
                            catch (SQLException var34_39) {
                                var35_59 = var20_17 != null && var20_17.length == 0;
                                for (var36_71 = 0; !var35_59 && var20_17 != null && var36_71 < var20_17.length; ++var36_71) {
                                    if (var34_39.getErrorCode() != var20_17[var36_71]) continue;
                                    var35_59 = true;
                                }
                                if (var35_59) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "Exception", "" + var34_39);
                                }
                                var36_71 = 0;
                                for (var37_77 = var34_39; var37_77 != null; var37_77 = var37_77.getNextException()) {
                                    ++var36_71;
                                }
                                var37_78 = 1;
                                for (var38_82 = var34_39; var38_82 != null; var38_82 = var38_82.getNextException()) {
                                    var39_86 = new StringWriter();
                                    var38_82.printStackTrace(new PrintWriter((Writer)var39_86, true));
                                    var5_5.println("SQLException " + var37_78 + " of " + var36_71 + ": " + (var28_25 != false ? "" + var39_86 : "" + var38_82));
                                    ++var37_78;
                                }
                                throw var34_39;
                            }
                            catch (Throwable var34_40) {
                                if (var19_16) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "Exception", "" + var34_40);
                                    continue;
                                }
                                throw var34_40;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
                        finally {
                            if (var7_7 != null) {
                                var7_7.close();
                            }
                        }
                    }
                    finally {
                        if (var6_6 != null) {
                            var6_6.close();
                        }
                    }
                }
                finally {
                    if (var5_5 != var4_4) {
                        var5_5.close();
                    }
                }
            }
            finally {
                while (var3_3.size() > 0) {
                    TeraDriver.popClose(var3_3, var2_2);
                }
            }
        }
    }

    static {
        try {
            DriverManager.registerDriver(new TeraDriver());
        }
        catch (SQLException sQLException) {
            sm_log.error("Unable to register the Teradata JDBC Driver with DriverManager", sQLException);
        }
        DUMMY_CALENDAR = Calendar.getInstance();
    }

    private static class StringList
    extends ArrayList {
        public String[] toStringArray() {
            return this.toArray(new String[0]);
        }

        public void append(int n) {
            int n2 = this.size() - 1;
            String string = (String)this.get(n2);
            if (string == null) {
                string = "";
            }
            this.set(n2, string + (char)n);
        }
    }

    private static class PeekReader
    extends PushbackReader {
        public int lineNumber = 0;

        public PeekReader(Reader reader) {
            super(reader);
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            if (n == 10) {
                ++this.lineNumber;
            }
            return n;
        }

        public int peek() throws IOException {
            int n = super.read();
            if (n >= 0) {
                this.unread(n);
            }
            return n;
        }
    }

    private static class CsvHeader {
        public String sHeader;
        public int nType;
        public String sTypeName;
        public boolean bTimeZone;
        public int nScale;

        private CsvHeader() {
        }
    }

    private static class TypeDesc {
        public String sTypeName;
        public int nType;
        public static TypeDesc[] types = new TypeDesc[]{new TypeDesc("BYTEINT", -6), new TypeDesc("SMALLINT", 5), new TypeDesc("INTEGER", 4), new TypeDesc("BIGINT", -5), new TypeDesc("FLOAT", 6), new TypeDesc("DECIMAL", 3), new TypeDesc("NUMBER", 2), new TypeDesc("CLOB", 2005), new TypeDesc("CHAR", 1), new TypeDesc("VARCHAR", 12), new TypeDesc("LONGVARCHAR", -1), new TypeDesc("BLOB", 2004), new TypeDesc("BYTE", -2), new TypeDesc("VARBYTE", -3), new TypeDesc("LONGVARBYTE", -4), new TypeDesc("DATE", 91), new TypeDesc("TIME", 92), new TypeDesc("TIME WITH TIME ZONE", 92), new TypeDesc("TIMESTAMP", 93), new TypeDesc("TIMESTAMP WITH TIME ZONE", 93)};

        private TypeDesc(String string, int n) {
            this.sTypeName = string;
            this.nType = n;
        }
    }
}

