/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.ui.views;

import com.datastax.oss.driver.api.core.addresstranslation.AddressTranslator;
import com.dbeaver.db.ycql.ui.internal.CasUIMessages;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.registry.driver.DriverClassFindJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditDialog;
import org.jkiss.utils.CommonUtils;

public class CasSocketSettingsPage
extends ConnectionPageAbstract {
    private static final Log log = Log.getLog(CasSocketSettingsPage.class);
    private final String driverName;
    private Spinner connectTimeoutSpinner;
    private Spinner readTimeoutSpinner;
    private Button keepAliveButton;
    private Button reuseAddressButton;
    private Spinner receiveBufferSizeSpinner;
    private Spinner sendBufferSizeSpinner;
    private Spinner soLingerSpinner;
    private Button tcpNoDelayButton;
    private Combo addressTranslatorCombo;
    private boolean translatorsFound;

    public CasSocketSettingsPage(String driverName) {
        this.driverName = driverName;
        this.setTitle(NLS.bind((String)CasUIMessages.settings_page_title_cas_tcp_settings, (Object)driverName));
        this.setDescription(NLS.bind((String)CasUIMessages.settings_page_title_description, (Object)driverName));
    }

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite cfgGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 5;
        gl.marginWidth = 5;
        cfgGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        cfgGroup.setLayoutData((Object)gd);
        UIUtils.createLink((Composite)cfgGroup, (String)(NLS.bind((String)CasUIMessages.settings_page_text_tcp_settings_controls, (Object)this.driverName) + CasUIMessages.settings_page_link_online_documentation), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.openWebBrowser((String)"https://docs.datastax.com/en/developer/java-driver/3.1/manual/socket_options/");
            }
        });
        Group timeoutsGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)CasUIMessages.settings_page_group_timeouts, (int)2, (int)0, (int)0);
        timeoutsGroup.setLayoutData((Object)new GridData(768));
        this.connectTimeoutSpinner = UIUtils.createLabelSpinner((Composite)timeoutsGroup, (String)CasUIMessages.settings_page_label_spinner_connect_timeout, (String)NLS.bind((String)CasUIMessages.settings_page_label_spinner_tip_connect_timeout, (Object)this.driverName), (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.readTimeoutSpinner = UIUtils.createLabelSpinner((Composite)timeoutsGroup, (String)CasUIMessages.settings_page_label_spinner_read_timeout, (String)NLS.bind((String)CasUIMessages.settings_page_label_spinner_tip_read_timeout, (Object)this.driverName), (int)0, (int)0, (int)Integer.MAX_VALUE);
        Group tcpGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)"TCP/IP", (int)2, (int)0, (int)0);
        tcpGroup.setLayoutData((Object)new GridData(768));
        this.keepAliveButton = UIUtils.createCheckbox((Composite)tcpGroup, (String)CasUIMessages.settings_page_checkbox_keep_alive, (String)CasUIMessages.settings_page_checkbox_tip_keep_whether_tcp, (boolean)false, (int)2);
        this.reuseAddressButton = UIUtils.createCheckbox((Composite)tcpGroup, (String)CasUIMessages.settings_page_checkbox_reuse_address, (String)CasUIMessages.settings_page_checkbox_tip_wether_reuse_address, (boolean)false, (int)2);
        this.receiveBufferSizeSpinner = UIUtils.createLabelSpinner((Composite)tcpGroup, (String)CasUIMessages.settings_page_label_spinner_receive_buffer_size, (String)CasUIMessages.settings_page_label_spinner_tip_receive_buffer_size, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.sendBufferSizeSpinner = UIUtils.createLabelSpinner((Composite)tcpGroup, (String)CasUIMessages.settings_page_label_spinner_send_buffer_size, (String)CasUIMessages.settings_page_label_spinner_tip_send_buffer_size, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.soLingerSpinner = UIUtils.createLabelSpinner((Composite)tcpGroup, (String)CasUIMessages.settings_page_label_spinner_solinger, (String)CasUIMessages.settings_page_label_spinner_tip_solinger, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.tcpNoDelayButton = UIUtils.createCheckbox((Composite)tcpGroup, (String)CasUIMessages.settings_page_checkbox_tcp_no_delay, (String)CasUIMessages.settings_page_checkbox_tip_tcp_no_delay, (boolean)false, (int)2);
        this.addressTranslatorCombo = UIUtils.createLabelCombo((Composite)tcpGroup, (String)"Address Translator", (int)4);
        Link driverLink = UIUtils.createLink((Composite)tcpGroup, (String)"To use custom address translator you need to add your custom <a href=\"driver\">driver libraries</a>", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverEditDialog dialog = new DriverEditDialog(CasSocketSettingsPage.this.getShell(), CasSocketSettingsPage.this.getSite().getDriver());
                if (dialog.open() == 0) {
                    CasSocketSettingsPage.this.loadSettings();
                }
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        driverLink.setLayoutData((Object)gd);
        this.setControl((Control)cfgGroup);
        this.loadSettings();
    }

    public boolean isComplete() {
        return true;
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        Map providerProperties = connectionInfo.getProviderProperties();
        this.connectTimeoutSpinner.setSelection(CommonUtils.toInt(providerProperties.get("@dbeaver-cas.timeout.connect@"), (int)0));
        this.readTimeoutSpinner.setSelection(CommonUtils.toInt(providerProperties.get("@dbeaver-cas.timeout.read@"), (int)0));
        this.keepAliveButton.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-cas.net.keepAlive@")), (boolean)false));
        this.reuseAddressButton.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-cas.net.reuseAddr@")), (boolean)false));
        this.receiveBufferSizeSpinner.setSelection(CommonUtils.toInt(providerProperties.get("@dbeaver-cas.net.receiveBufferSize@"), (int)0));
        this.sendBufferSizeSpinner.setSelection(CommonUtils.toInt(providerProperties.get("@dbeaver-cas.net.sendBufferSize@"), (int)0));
        this.soLingerSpinner.setSelection(CommonUtils.toInt(providerProperties.get("@dbeaver-cas.net.soLinger@"), (int)0));
        this.tcpNoDelayButton.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-cas.net.soLinger@")), (boolean)false));
        this.addressTranslatorCombo.setText(CommonUtils.toString(providerProperties.get("cas.net.tcpAddressTranslator")));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!this.translatorsFound) {
            this.translatorsFound = true;
            try {
                this.addressTranslatorCombo.removeAll();
                DriverClassFindJob finder = new DriverClassFindJob(this.getSite().getDriver(), AddressTranslator.class.getName(), true);
                this.getSite().getRunnableContext().run(true, true, (DBRRunnableWithProgress)finder);
                for (String classNames : finder.getDriverClassNames()) {
                    this.addressTranslatorCombo.add(classNames);
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        Map providerProperties = dataSource.getConnectionConfiguration().getProviderProperties();
        if (this.connectTimeoutSpinner.getSelection() > 0) {
            providerProperties.put("@dbeaver-cas.timeout.connect@", String.valueOf(this.connectTimeoutSpinner.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.timeout.connect@");
        }
        if (this.readTimeoutSpinner.getSelection() > 0) {
            providerProperties.put("@dbeaver-cas.timeout.read@", String.valueOf(this.readTimeoutSpinner.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.timeout.read@");
        }
        if (this.keepAliveButton.getSelection()) {
            providerProperties.put("@dbeaver-cas.net.keepAlive@", String.valueOf(this.keepAliveButton.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.net.keepAlive@");
        }
        if (this.reuseAddressButton.getSelection()) {
            providerProperties.put("@dbeaver-cas.net.reuseAddr@", String.valueOf(this.reuseAddressButton.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.net.reuseAddr@");
        }
        if (this.receiveBufferSizeSpinner.getSelection() > 0) {
            providerProperties.put("@dbeaver-cas.net.receiveBufferSize@", String.valueOf(this.receiveBufferSizeSpinner.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.net.receiveBufferSize@");
        }
        if (this.sendBufferSizeSpinner.getSelection() > 0) {
            providerProperties.put("@dbeaver-cas.net.sendBufferSize@", String.valueOf(this.sendBufferSizeSpinner.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.net.sendBufferSize@");
        }
        if (this.soLingerSpinner.getSelection() > 0) {
            providerProperties.put("@dbeaver-cas.net.soLinger@", String.valueOf(this.soLingerSpinner.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.net.soLinger@");
        }
        if (this.tcpNoDelayButton.getSelection()) {
            providerProperties.put("@dbeaver-cas.net.tcpNoDelay@", String.valueOf(this.tcpNoDelayButton.getSelection()));
        } else {
            providerProperties.remove("@dbeaver-cas.net.tcpNoDelay@");
        }
        String addrTranslatorClass = this.addressTranslatorCombo.getText();
        if (!CommonUtils.isEmpty((String)addrTranslatorClass)) {
            providerProperties.put("cas.net.tcpAddressTranslator", addrTranslatorClass);
        } else {
            providerProperties.remove("cas.net.tcpAddressTranslator");
        }
        this.saveConnectionURL(dataSource.getConnectionConfiguration());
    }
}

